/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.AndroidException;
import android.util.Printer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable {
    private static final String SGLOB_STR = "sglob";
    private static final String PREFIX_STR = "prefix";
    private static final String LITERAL_STR = "literal";
    private static final String PATH_STR = "path";
    private static final String PORT_STR = "port";
    private static final String HOST_STR = "host";
    private static final String AUTH_STR = "auth";
    private static final String SCHEME_STR = "scheme";
    private static final String TYPE_STR = "type";
    private static final String CAT_STR = "cat";
    private static final String NAME_STR = "name";
    private static final String ACTION_STR = "action";
    public static final int SYSTEM_HIGH_PRIORITY = 1000;
    public static final int SYSTEM_LOW_PRIORITY = -1000;
    public static final int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static final int MATCH_ADJUSTMENT_MASK = 65535;
    public static final int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static final int MATCH_CATEGORY_EMPTY = 0x100000;
    public static final int MATCH_CATEGORY_SCHEME = 0x200000;
    public static final int MATCH_CATEGORY_HOST = 0x300000;
    public static final int MATCH_CATEGORY_PORT = 0x400000;
    public static final int MATCH_CATEGORY_PATH = 0x500000;
    public static final int MATCH_CATEGORY_TYPE = 0x600000;
    public static final int NO_MATCH_TYPE = -1;
    public static final int NO_MATCH_DATA = -2;
    public static final int NO_MATCH_ACTION = -3;
    public static final int NO_MATCH_CATEGORY = -4;
    private int mPriority;
    private final ArrayList<String> mActions;
    private ArrayList<String> mCategories = null;
    private ArrayList<String> mDataSchemes = null;
    private ArrayList<AuthorityEntry> mDataAuthorities = null;
    private ArrayList<PatternMatcher> mDataPaths = null;
    private ArrayList<String> mDataTypes = null;
    private boolean mHasPartialTypes = false;
    public static final Parcelable.Creator<IntentFilter> CREATOR = new Parcelable.Creator<IntentFilter>(){

        @Override
        public IntentFilter createFromParcel(Parcel parcel) {
            return new IntentFilter(parcel);
        }

        public IntentFilter[] newArray(int n) {
            return new IntentFilter[n];
        }
    };

    private static int findStringInSet(String[] stringArray, String string2, int[] nArray, int n) {
        if (stringArray == null) {
            return -1;
        }
        int n2 = nArray[n];
        for (int i = 0; i < n2; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static String[] addStringToSet(String[] stringArray, String string2, int[] nArray, int n) {
        if (IntentFilter.findStringInSet(stringArray, string2, nArray, n) >= 0) {
            return stringArray;
        }
        if (stringArray == null) {
            stringArray = new String[2];
            stringArray[0] = string2;
            nArray[n] = 1;
            return stringArray;
        }
        int n2 = nArray[n];
        if (n2 < stringArray.length) {
            stringArray[n2] = string2;
            nArray[n] = n2 + 1;
            return stringArray;
        }
        String[] stringArray2 = new String[n2 * 3 / 2 + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        stringArray = stringArray2;
        stringArray[n2] = string2;
        nArray[n] = n2 + 1;
        return stringArray;
    }

    private static String[] removeStringFromSet(String[] stringArray, String string2, int[] nArray, int n) {
        int n2 = IntentFilter.findStringInSet(stringArray, string2, nArray, n);
        if (n2 < 0) {
            return stringArray;
        }
        int n3 = nArray[n];
        if (n3 > stringArray.length / 4) {
            int n4 = n3 - (n2 + 1);
            if (n4 > 0) {
                System.arraycopy(stringArray, n2 + 1, stringArray, n2, n4);
            }
            stringArray[n3 - 1] = null;
            nArray[n] = n3 - 1;
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length / 3];
        if (n2 > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        }
        if (n2 + 1 < n3) {
            System.arraycopy(stringArray, n2 + 1, stringArray2, n2, n3 - (n2 + 1));
        }
        return stringArray2;
    }

    public static IntentFilter create(String string2, String string3) {
        try {
            return new IntentFilter(string2, string3);
        }
        catch (MalformedMimeTypeException malformedMimeTypeException) {
            throw new RuntimeException("Bad MIME type", malformedMimeTypeException);
        }
    }

    public IntentFilter() {
        this.mPriority = 0;
        this.mActions = new ArrayList();
    }

    public IntentFilter(String string2) {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(string2);
    }

    public IntentFilter(String string2, String string3) throws MalformedMimeTypeException {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(string2);
        this.addDataType(string3);
    }

    public IntentFilter(IntentFilter intentFilter) {
        this.mPriority = intentFilter.mPriority;
        this.mActions = new ArrayList<String>(intentFilter.mActions);
        if (intentFilter.mCategories != null) {
            this.mCategories = new ArrayList<String>(intentFilter.mCategories);
        }
        if (intentFilter.mDataTypes != null) {
            this.mDataTypes = new ArrayList<String>(intentFilter.mDataTypes);
        }
        if (intentFilter.mDataSchemes != null) {
            this.mDataSchemes = new ArrayList<String>(intentFilter.mDataSchemes);
        }
        if (intentFilter.mDataAuthorities != null) {
            this.mDataAuthorities = new ArrayList<AuthorityEntry>(intentFilter.mDataAuthorities);
        }
        if (intentFilter.mDataPaths != null) {
            this.mDataPaths = new ArrayList<PatternMatcher>(intentFilter.mDataPaths);
        }
        this.mHasPartialTypes = intentFilter.mHasPartialTypes;
    }

    public final void setPriority(int n) {
        this.mPriority = n;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final void addAction(String string2) {
        if (!this.mActions.contains(string2)) {
            this.mActions.add(string2.intern());
        }
    }

    public final int countActions() {
        return this.mActions.size();
    }

    public final String getAction(int n) {
        return this.mActions.get(n);
    }

    public final boolean hasAction(String string2) {
        return string2 != null && this.mActions.contains(string2);
    }

    public final boolean matchAction(String string2) {
        return this.hasAction(string2);
    }

    public final Iterator<String> actionsIterator() {
        return this.mActions != null ? this.mActions.iterator() : null;
    }

    public final void addDataType(String string2) throws MalformedMimeTypeException {
        int n = string2.indexOf(47);
        int n2 = string2.length();
        if (n > 0 && n2 >= n + 2) {
            if (this.mDataTypes == null) {
                this.mDataTypes = new ArrayList();
            }
            if (n2 == n + 2 && string2.charAt(n + 1) == '*') {
                String string3 = string2.substring(0, n);
                if (!this.mDataTypes.contains(string3)) {
                    this.mDataTypes.add(string3.intern());
                }
                this.mHasPartialTypes = true;
            } else if (!this.mDataTypes.contains(string2)) {
                this.mDataTypes.add(string2.intern());
            }
            return;
        }
        throw new MalformedMimeTypeException(string2);
    }

    public final boolean hasDataType(String string2) {
        return this.mDataTypes != null && this.findMimeType(string2);
    }

    public final int countDataTypes() {
        return this.mDataTypes != null ? this.mDataTypes.size() : 0;
    }

    public final String getDataType(int n) {
        return this.mDataTypes.get(n);
    }

    public final Iterator<String> typesIterator() {
        return this.mDataTypes != null ? this.mDataTypes.iterator() : null;
    }

    public final void addDataScheme(String string2) {
        if (this.mDataSchemes == null) {
            this.mDataSchemes = new ArrayList();
        }
        if (!this.mDataSchemes.contains(string2)) {
            this.mDataSchemes.add(string2.intern());
        }
    }

    public final int countDataSchemes() {
        return this.mDataSchemes != null ? this.mDataSchemes.size() : 0;
    }

    public final String getDataScheme(int n) {
        return this.mDataSchemes.get(n);
    }

    public final boolean hasDataScheme(String string2) {
        return this.mDataSchemes != null && this.mDataSchemes.contains(string2);
    }

    public final Iterator<String> schemesIterator() {
        return this.mDataSchemes != null ? this.mDataSchemes.iterator() : null;
    }

    public final void addDataAuthority(String string2, String string3) {
        if (this.mDataAuthorities == null) {
            this.mDataAuthorities = new ArrayList();
        }
        if (string3 != null) {
            string3 = string3.intern();
        }
        this.mDataAuthorities.add(new AuthorityEntry(string2.intern(), string3));
    }

    public final int countDataAuthorities() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.size() : 0;
    }

    public final AuthorityEntry getDataAuthority(int n) {
        return this.mDataAuthorities.get(n);
    }

    public final boolean hasDataAuthority(Uri uri) {
        return this.matchDataAuthority(uri) >= 0;
    }

    public final Iterator<AuthorityEntry> authoritiesIterator() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.iterator() : null;
    }

    public final void addDataPath(String string2, int n) {
        if (this.mDataPaths == null) {
            this.mDataPaths = new ArrayList();
        }
        this.mDataPaths.add(new PatternMatcher(string2.intern(), n));
    }

    public final int countDataPaths() {
        return this.mDataPaths != null ? this.mDataPaths.size() : 0;
    }

    public final PatternMatcher getDataPath(int n) {
        return this.mDataPaths.get(n);
    }

    public final boolean hasDataPath(String string2) {
        if (this.mDataPaths == null) {
            return false;
        }
        int n = this.mDataPaths.size();
        for (int i = 0; i < n; ++i) {
            PatternMatcher patternMatcher = this.mDataPaths.get(i);
            if (!patternMatcher.match(string2)) continue;
            return true;
        }
        return false;
    }

    public final Iterator<PatternMatcher> pathsIterator() {
        return this.mDataPaths != null ? this.mDataPaths.iterator() : null;
    }

    public final int matchDataAuthority(Uri uri) {
        if (this.mDataAuthorities == null) {
            return -2;
        }
        int n = this.mDataAuthorities.size();
        for (int i = 0; i < n; ++i) {
            AuthorityEntry authorityEntry = this.mDataAuthorities.get(i);
            int n2 = authorityEntry.match(uri);
            if (n2 < 0) continue;
            return n2;
        }
        return -2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int matchData(String string2, String string3, Uri uri) {
        ArrayList<String> arrayList = this.mDataTypes;
        ArrayList<String> arrayList2 = this.mDataSchemes;
        ArrayList<AuthorityEntry> arrayList3 = this.mDataAuthorities;
        ArrayList<PatternMatcher> arrayList4 = this.mDataPaths;
        int n = 0x100000;
        if (arrayList == null && arrayList2 == null) {
            if (string2 != null) return -2;
            if (uri != null) return -2;
            return 0x108000;
        }
        if (arrayList2 != null) {
            if (!arrayList2.contains(string3 != null ? string3 : "")) return -2;
            n = 0x200000;
            if (arrayList3 != null) {
                int n2 = this.matchDataAuthority(uri);
                if (n2 < 0) return -2;
                if (arrayList4 == null) {
                    n = n2;
                } else {
                    if (!this.hasDataPath(uri.getPath())) return -2;
                    n = 0x500000;
                }
            }
        } else if (!(string3 == null || "".equals(string3) || "content".equals(string3) || "file".equals(string3))) {
            return -2;
        }
        if (arrayList != null) {
            if (!this.findMimeType(string2)) return -1;
            return 0x608000;
        }
        if (string2 == null) return n + 32768;
        return -1;
    }

    public final void addCategory(String string2) {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList();
        }
        if (!this.mCategories.contains(string2)) {
            this.mCategories.add(string2.intern());
        }
    }

    public final int countCategories() {
        return this.mCategories != null ? this.mCategories.size() : 0;
    }

    public final String getCategory(int n) {
        return this.mCategories.get(n);
    }

    public final boolean hasCategory(String string2) {
        return this.mCategories != null && this.mCategories.contains(string2);
    }

    public final Iterator<String> categoriesIterator() {
        return this.mCategories != null ? this.mCategories.iterator() : null;
    }

    public final String matchCategories(Set<String> set) {
        if (set == null) {
            return null;
        }
        Iterator<String> iterator = set.iterator();
        if (this.mCategories == null) {
            return iterator.hasNext() ? iterator.next() : null;
        }
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (this.mCategories.contains(string2)) continue;
            return string2;
        }
        return null;
    }

    public final int match(ContentResolver contentResolver, Intent intent, boolean bl, String string2) {
        String string3 = bl ? intent.resolveType(contentResolver) : intent.getType();
        return this.match(intent.getAction(), string3, intent.getScheme(), intent.getData(), intent.getCategories(), string2);
    }

    public final int match(String string2, String string3, String string4, Uri uri, Set<String> set, String string5) {
        if (string2 != null && !this.matchAction(string2)) {
            return -3;
        }
        int n = this.matchData(string3, string4, uri);
        if (n < 0) {
            return n;
        }
        String string6 = this.matchCategories(set);
        if (string6 != null) {
            return -4;
        }
        return n;
    }

    public void writeToXml(XmlSerializer xmlSerializer) throws IOException {
        Object object;
        int n;
        int n2 = this.countActions();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, ACTION_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mActions.get(n));
            xmlSerializer.endTag(null, ACTION_STR);
        }
        n2 = this.countCategories();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, CAT_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mCategories.get(n));
            xmlSerializer.endTag(null, CAT_STR);
        }
        n2 = this.countDataTypes();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, TYPE_STR);
            object = this.mDataTypes.get(n);
            if (((String)object).indexOf(47) < 0) {
                object = (String)object + "/*";
            }
            xmlSerializer.attribute(null, NAME_STR, (String)object);
            xmlSerializer.endTag(null, TYPE_STR);
        }
        n2 = this.countDataSchemes();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, SCHEME_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mDataSchemes.get(n));
            xmlSerializer.endTag(null, SCHEME_STR);
        }
        n2 = this.countDataAuthorities();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, AUTH_STR);
            object = this.mDataAuthorities.get(n);
            xmlSerializer.attribute(null, HOST_STR, ((AuthorityEntry)object).getHost());
            if (((AuthorityEntry)object).getPort() >= 0) {
                xmlSerializer.attribute(null, PORT_STR, Integer.toString(((AuthorityEntry)object).getPort()));
            }
            xmlSerializer.endTag(null, AUTH_STR);
        }
        n2 = this.countDataPaths();
        for (n = 0; n < n2; ++n) {
            xmlSerializer.startTag(null, PATH_STR);
            object = this.mDataPaths.get(n);
            switch (((PatternMatcher)object).getType()) {
                case 0: {
                    xmlSerializer.attribute(null, LITERAL_STR, ((PatternMatcher)object).getPath());
                    break;
                }
                case 1: {
                    xmlSerializer.attribute(null, PREFIX_STR, ((PatternMatcher)object).getPath());
                    break;
                }
                case 2: {
                    xmlSerializer.attribute(null, SGLOB_STR, ((PatternMatcher)object).getPath());
                }
            }
            xmlSerializer.endTag(null, PATH_STR);
        }
    }

    public void readFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
    }

    public void dump(Printer printer, String string2) {
        Iterator<Object> iterator;
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            iterator = this.mActions.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Action: \"");
                stringBuilder.append((String)iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mCategories != null) {
            iterator = this.mCategories.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Category: \"");
                stringBuilder.append((String)iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataSchemes != null) {
            iterator = this.mDataSchemes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Scheme: \"");
                stringBuilder.append((String)iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry object : this.mDataAuthorities) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Authority: \"");
                stringBuilder.append(object.mHost);
                stringBuilder.append("\": ");
                stringBuilder.append(object.mPort);
                if (object.mWild) {
                    stringBuilder.append(" WILD");
                }
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher patternMatcher : this.mDataPaths) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Path: \"");
                stringBuilder.append(patternMatcher);
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataTypes != null) {
            iterator = this.mDataTypes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Type: \"");
                stringBuilder.append((String)iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mPriority != 0 || this.mHasPartialTypes) {
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mPriority=");
            stringBuilder.append(this.mPriority);
            stringBuilder.append(", mHasPartialTypes=");
            stringBuilder.append(this.mHasPartialTypes);
            printer.println(stringBuilder.toString());
        }
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        int n2;
        int n3;
        parcel.writeStringList(this.mActions);
        if (this.mCategories != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mCategories);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mDataSchemes);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataTypes != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mDataTypes);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            n3 = this.mDataAuthorities.size();
            parcel.writeInt(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.mDataAuthorities.get(n2).writeToParcel(parcel);
            }
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataPaths != null) {
            n3 = this.mDataPaths.size();
            parcel.writeInt(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.mDataPaths.get(n2).writeToParcel(parcel, 0);
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mPriority);
        parcel.writeInt(this.mHasPartialTypes ? 1 : 0);
    }

    public boolean debugCheck() {
        return true;
    }

    private IntentFilter(Parcel parcel) {
        int n;
        int n2;
        this.mActions = new ArrayList();
        parcel.readStringList(this.mActions);
        if (parcel.readInt() != 0) {
            this.mCategories = new ArrayList();
            parcel.readStringList(this.mCategories);
        }
        if (parcel.readInt() != 0) {
            this.mDataSchemes = new ArrayList();
            parcel.readStringList(this.mDataSchemes);
        }
        if (parcel.readInt() != 0) {
            this.mDataTypes = new ArrayList();
            parcel.readStringList(this.mDataTypes);
        }
        if ((n2 = parcel.readInt()) > 0) {
            this.mDataAuthorities = new ArrayList();
            for (n = 0; n < n2; ++n) {
                this.mDataAuthorities.add(new AuthorityEntry(parcel));
            }
        }
        if ((n2 = parcel.readInt()) > 0) {
            this.mDataPaths = new ArrayList();
            for (n = 0; n < n2; ++n) {
                this.mDataPaths.add(new PatternMatcher(parcel));
            }
        }
        this.mPriority = parcel.readInt();
        this.mHasPartialTypes = parcel.readInt() > 0;
    }

    private final boolean findMimeType(String string2) {
        ArrayList<String> arrayList = this.mDataTypes;
        if (string2 == null) {
            return false;
        }
        if (arrayList.contains(string2)) {
            return true;
        }
        int n = string2.length();
        if (n == 3 && string2.equals("*/*")) {
            return !arrayList.isEmpty();
        }
        if (this.mHasPartialTypes && arrayList.contains("*")) {
            return true;
        }
        int n2 = string2.indexOf(47);
        if (n2 > 0) {
            if (this.mHasPartialTypes && arrayList.contains(string2.substring(0, n2))) {
                return true;
            }
            if (n == n2 + 2 && string2.charAt(n2 + 1) == '*') {
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    String string3 = arrayList.get(i);
                    if (!string2.regionMatches(0, string3, 0, n2 + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final class AuthorityEntry {
        private final String mOrigHost;
        private final String mHost;
        private final boolean mWild;
        private final int mPort;

        public AuthorityEntry(String string2, String string3) {
            this.mOrigHost = string2;
            this.mWild = string2.length() > 0 && string2.charAt(0) == '*';
            this.mHost = this.mWild ? string2.substring(1).intern() : string2;
            this.mPort = string3 != null ? Integer.parseInt(string3) : -1;
        }

        AuthorityEntry(Parcel parcel) {
            this.mOrigHost = parcel.readString();
            this.mHost = parcel.readString();
            this.mWild = parcel.readInt() != 0;
            this.mPort = parcel.readInt();
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mOrigHost);
            parcel.writeString(this.mHost);
            parcel.writeInt(this.mWild ? 1 : 0);
            parcel.writeInt(this.mPort);
        }

        public String getHost() {
            return this.mOrigHost;
        }

        public int getPort() {
            return this.mPort;
        }

        public int match(Uri uri) {
            String string2 = uri.getHost();
            if (string2 == null) {
                return -2;
            }
            if (this.mWild) {
                if (string2.length() < this.mHost.length()) {
                    return -2;
                }
                string2 = string2.substring(string2.length() - this.mHost.length());
            }
            if (string2.compareToIgnoreCase(this.mHost) != 0) {
                return -2;
            }
            if (this.mPort >= 0) {
                if (this.mPort != uri.getPort()) {
                    return -2;
                }
                return 0x400000;
            }
            return 0x300000;
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException {
        public MalformedMimeTypeException() {
        }

        public MalformedMimeTypeException(String string2) {
            super(string2);
        }
    }
}

