/*
 * Decompiled with CFR 0.152.
 */
package heros;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.EdgeFunction;
import heros.EdgeFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeFunctionCache<N, D, M, V>
implements EdgeFunctions<N, D, M, V> {
    protected final EdgeFunctions<N, D, M, V> delegate;
    protected final LoadingCache<NDNDKey, EdgeFunction<V>> normalCache;
    protected final LoadingCache<CallKey, EdgeFunction<V>> callCache;
    protected final LoadingCache<ReturnKey, EdgeFunction<V>> returnCache;
    protected final LoadingCache<NDNDKey, EdgeFunction<V>> callToReturnCache;

    public EdgeFunctionCache(final EdgeFunctions<N, D, M, V> delegate, CacheBuilder builder) {
        this.delegate = delegate;
        this.normalCache = builder.build(new CacheLoader<NDNDKey, EdgeFunction<V>>(){

            @Override
            public EdgeFunction<V> load(NDNDKey key) throws Exception {
                return delegate.getNormalEdgeFunction(key.getN1(), key.getD1(), key.getN2(), key.getD2());
            }
        });
        this.callCache = builder.build(new CacheLoader<CallKey, EdgeFunction<V>>(){

            @Override
            public EdgeFunction<V> load(CallKey key) throws Exception {
                return delegate.getCallEdgeFunction(key.getCallSite(), key.getD1(), key.getCalleeMethod(), key.getD2());
            }
        });
        this.returnCache = builder.build(new CacheLoader<ReturnKey, EdgeFunction<V>>(){

            @Override
            public EdgeFunction<V> load(ReturnKey key) throws Exception {
                return delegate.getReturnEdgeFunction(key.getCallSite(), key.getCalleeMethod(), key.getExitStmt(), key.getD1(), key.getReturnSite(), key.getD2());
            }
        });
        this.callToReturnCache = builder.build(new CacheLoader<NDNDKey, EdgeFunction<V>>(){

            @Override
            public EdgeFunction<V> load(NDNDKey key) throws Exception {
                return delegate.getCallToReturnEdgeFunction(key.getN1(), key.getD1(), key.getN2(), key.getD2());
            }
        });
    }

    @Override
    public EdgeFunction<V> getNormalEdgeFunction(N curr, D currNode, N succ, D succNode) {
        return this.normalCache.getUnchecked(new NDNDKey(curr, currNode, succ, succNode));
    }

    @Override
    public EdgeFunction<V> getCallEdgeFunction(N callStmt, D srcNode, M destinationMethod, D destNode) {
        return this.callCache.getUnchecked(new CallKey(callStmt, srcNode, destinationMethod, destNode));
    }

    @Override
    public EdgeFunction<V> getReturnEdgeFunction(N callSite, M calleeMethod, N exitStmt, D exitNode, N returnSite, D retNode) {
        return this.returnCache.getUnchecked(new ReturnKey(callSite, calleeMethod, exitStmt, exitNode, returnSite, retNode));
    }

    @Override
    public EdgeFunction<V> getCallToReturnEdgeFunction(N callSite, D callNode, N returnSite, D returnSideNode) {
        return this.callToReturnCache.getUnchecked(new NDNDKey(callSite, callNode, returnSite, returnSideNode));
    }

    public void printStats() {
        System.err.println("Stats for edge-function cache:");
        System.err.print("Normal:         ");
        System.err.println(this.normalCache.stats());
        System.err.print("Call:           ");
        System.err.println(this.callCache.stats());
        System.err.print("Return:         ");
        System.err.println(this.returnCache.stats());
        System.err.print("Call-to-return: ");
        System.err.println(this.callToReturnCache.stats());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReturnKey
    extends CallKey {
        private final N exitStmt;
        private final N returnSite;

        public ReturnKey(N callSite, M calleeMethod, N exitStmt, D exitNode, N returnSite, D retNode) {
            super(callSite, exitNode, calleeMethod, retNode);
            this.exitStmt = exitStmt;
            this.returnSite = returnSite;
        }

        public N getExitStmt() {
            return this.exitStmt;
        }

        public N getReturnSite() {
            return this.returnSite;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.exitStmt == null ? 0 : this.exitStmt.hashCode());
            result = 31 * result + (this.returnSite == null ? 0 : this.returnSite.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnKey other = (ReturnKey)obj;
            if (this.exitStmt == null ? other.exitStmt != null : !this.exitStmt.equals(other.exitStmt)) {
                return false;
            }
            return !(this.returnSite == null ? other.returnSite != null : !this.returnSite.equals(other.returnSite));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallKey {
        private final N callSite;
        private final M calleeMethod;
        private final D d1;
        private final D d2;

        public CallKey(N callSite, D d1, M calleeMethod, D d2) {
            this.callSite = callSite;
            this.calleeMethod = calleeMethod;
            this.d1 = d1;
            this.d2 = d2;
        }

        public N getCallSite() {
            return this.callSite;
        }

        public D getD1() {
            return this.d1;
        }

        public M getCalleeMethod() {
            return this.calleeMethod;
        }

        public D getD2() {
            return this.d2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.d1 == null ? 0 : this.d1.hashCode());
            result = 31 * result + (this.d2 == null ? 0 : this.d2.hashCode());
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.calleeMethod == null ? 0 : this.calleeMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallKey other = (CallKey)obj;
            if (this.d1 == null ? other.d1 != null : !this.d1.equals(other.d1)) {
                return false;
            }
            if (this.d2 == null ? other.d2 != null : !this.d2.equals(other.d2)) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            return !(this.calleeMethod == null ? other.calleeMethod != null : !this.calleeMethod.equals(other.calleeMethod));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NDNDKey {
        private final N n1;
        private final N n2;
        private final D d1;
        private final D d2;

        public NDNDKey(N n1, D d1, N n2, D d2) {
            this.n1 = n1;
            this.n2 = n2;
            this.d1 = d1;
            this.d2 = d2;
        }

        public N getN1() {
            return this.n1;
        }

        public D getD1() {
            return this.d1;
        }

        public N getN2() {
            return this.n2;
        }

        public D getD2() {
            return this.d2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.d1 == null ? 0 : this.d1.hashCode());
            result = 31 * result + (this.d2 == null ? 0 : this.d2.hashCode());
            result = 31 * result + (this.n1 == null ? 0 : this.n1.hashCode());
            result = 31 * result + (this.n2 == null ? 0 : this.n2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NDNDKey other = (NDNDKey)obj;
            if (this.d1 == null ? other.d1 != null : !this.d1.equals(other.d1)) {
                return false;
            }
            if (this.d2 == null ? other.d2 != null : !this.d2.equals(other.d2)) {
                return false;
            }
            if (this.n1 == null ? other.n1 != null : !this.n1.equals(other.n1)) {
                return false;
            }
            return !(this.n2 == null ? other.n2 != null : !this.n2.equals(other.n2));
        }
    }
}

