/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import heros.solver.CountLatch;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingThreadPoolExecutor
extends ThreadPoolExecutor {
    protected final CountLatch numRunningTasks = new CountLatch(0);

    public CountingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    @Override
    public void execute(Runnable command) {
        this.numRunningTasks.increment();
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.numRunningTasks.decrement();
        super.afterExecute(r, t);
    }

    public void awaitCompletion() throws InterruptedException {
        this.numRunningTasks.awaitZero();
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        this.numRunningTasks.awaitZero(timeout, unit);
    }
}

