/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import heros.DontSynchronize;
import heros.EdgeFunction;
import heros.EdgeFunctionCache;
import heros.EdgeFunctions;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IDETabulationProblem;
import heros.InterproceduralCFG;
import heros.JoinLattice;
import heros.SynchronizedBy;
import heros.ZeroedFlowFunctions;
import heros.edgefunc.EdgeIdentity;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.JumpFunctions;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDESolver<N, D, M, V, I extends InterproceduralCFG<N, M>> {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    public static final boolean DEBUG = !System.getProperty("HEROS_DEBUG", "false").equals("false");
    @DontSynchronize(value="only used by single thread")
    protected CountingThreadPoolExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected final JumpFunctions<N, D, V> jumpFn;
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final Table<N, D, Table<N, D, EdgeFunction<V>>> endSummary = HashBasedTable.create();
    @SynchronizedBy(value="consistent lock on field")
    protected final Table<N, D, Map<N, Set<D>>> incoming = HashBasedTable.create();
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<N, D, M> flowFunctions;
    @DontSynchronize(value="stateless")
    protected final EdgeFunctions<N, D, M, V> edgeFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Set<N> initialSeeds;
    @DontSynchronize(value="stateless")
    protected final JoinLattice<V> valueLattice;
    @DontSynchronize(value="stateless")
    protected final EdgeFunction<V> allTop;
    @DontSynchronize(value="only used by single thread - phase II not parallelized (yet)")
    protected final Table<N, D, V> val = HashBasedTable.create();
    @DontSynchronize(value="benign races")
    public long flowFunctionApplicationCount;
    @DontSynchronize(value="benign races")
    public long flowFunctionConstructionCount;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="benign races")
    public long durationFlowFunctionConstruction;
    @DontSynchronize(value="benign races")
    public long durationFlowFunctionApplication;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<N, D, M> ffCache;
    @DontSynchronize(value="readOnly")
    protected final EdgeFunctionCache<N, D, M, V> efCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    protected final boolean computeValues;

    public IDESolver(IDETabulationProblem<N, D, M, V, I> tabulationProblem) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER, DEFAULT_CACHE_BUILDER);
    }

    public IDESolver(IDETabulationProblem<N, D, M, V, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder, CacheBuilder edgeFunctionCacheBuilder) {
        if (DEBUG) {
            flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
            edgeFunctionCacheBuilder = edgeFunctionCacheBuilder.recordStats();
        }
        this.zeroValue = tabulationProblem.zeroValue();
        this.icfg = tabulationProblem.interproceduralCFG();
        FlowFunctions flowFunctions = tabulationProblem.autoAddZero() ? new ZeroedFlowFunctions(tabulationProblem.flowFunctions(), tabulationProblem.zeroValue()) : tabulationProblem.flowFunctions();
        EdgeFunctions<N, D, M, V> edgeFunctions = tabulationProblem.edgeFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache(flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        if (edgeFunctionCacheBuilder != null) {
            this.efCache = new EdgeFunctionCache<N, D, M, V>(edgeFunctions, edgeFunctionCacheBuilder);
            edgeFunctions = this.efCache;
        } else {
            this.efCache = null;
        }
        this.flowFunctions = flowFunctions;
        this.edgeFunctions = edgeFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.valueLattice = tabulationProblem.joinLattice();
        this.allTop = tabulationProblem.allTopFunction();
        this.jumpFn = new JumpFunctions(this.allTop);
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.computeValues = tabulationProblem.computeValues();
        this.executor = this.getExecutor();
    }

    public void solve() {
        for (N startPoint : this.initialSeeds) {
            this.propagate(this.zeroValue, startPoint, this.zeroValue, this.allTop);
            this.scheduleEdgeProcessing(new PathEdge(this.zeroValue, startPoint, this.zeroValue));
            this.jumpFn.addFunction(this.zeroValue, startPoint, this.zeroValue, EdgeIdentity.v());
        }
        this.awaitCompletionComputeValuesAndShutdown();
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        long before = System.currentTimeMillis();
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.durationFlowFunctionConstruction = System.currentTimeMillis() - before;
        if (this.computeValues) {
            before = System.currentTimeMillis();
            this.computeValues();
            this.durationFlowFunctionApplication = System.currentTimeMillis() - before;
        }
        if (DEBUG) {
            this.printStats();
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void scheduleEdgeProcessing(PathEdge<N, D, M> edge) {
        this.executor.execute(new PathEdgeProcessingTask(edge));
        ++this.propagationCount;
    }

    private void scheduleValueProcessing(ValuePropagationTask vpt) {
        this.executor.execute(vpt);
    }

    private void scheduleValueComputationTask(ValueComputationTask task) {
        this.executor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCall(PathEdge<N, D, M> edge) {
        D d1 = edge.factAtSource();
        N n = edge.getTarget();
        D d2 = edge.factAtTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        List<N> returnSiteNs = this.icfg.getReturnSitesOfCallAt(n);
        Set callees = this.icfg.getCalleesOfCallAt(n);
        for (Object sCalledProcN : callees) {
            FlowFunction<D> function = this.flowFunctions.getCallFlowFunction(n, sCalledProcN);
            ++this.flowFunctionConstructionCount;
            Set<D> res = function.computeTargets(d2);
            for (Object sP : this.icfg.getStartPointsOf(sCalledProcN)) {
                for (D d3 : res) {
                    HashSet endSumm;
                    this.propagate(d3, sP, d3, EdgeIdentity.v());
                    Table<N, D, Map<N, Set<D>>> table = this.incoming;
                    synchronized (table) {
                        this.addIncoming(sP, d3, n, d2);
                        endSumm = new HashSet(this.endSummary(sP, d3));
                    }
                    for (Table.Cell cell : endSumm) {
                        Object eP = cell.getRowKey();
                        Object d4 = cell.getColumnKey();
                        EdgeFunction fCalleeSummary = (EdgeFunction)cell.getValue();
                        for (N retSiteN : returnSiteNs) {
                            FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction(n, sCalledProcN, eP, retSiteN);
                            ++this.flowFunctionConstructionCount;
                            for (D d5 : retFunction.computeTargets(d4)) {
                                EdgeFunction<V> f4 = this.edgeFunctions.getCallEdgeFunction(n, d2, sCalledProcN, d3);
                                EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(n, sCalledProcN, eP, d4, retSiteN, d5);
                                EdgeFunction<V> fPrime = f4.composeWith(fCalleeSummary).composeWith(f5);
                                this.propagate(d1, retSiteN, d5, f.composeWith(fPrime));
                            }
                        }
                    }
                }
            }
        }
        for (Object returnSiteN : returnSiteNs) {
            FlowFunction<D> callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction(n, returnSiteN);
            ++this.flowFunctionConstructionCount;
            for (D d3 : callToReturnFlowFunction.computeTargets(d2)) {
                EdgeFunction<V> edgeFnE = this.edgeFunctions.getCallToReturnEdgeFunction(n, d2, returnSiteN, d3);
                this.propagate(d1, returnSiteN, d3, f.composeWith(edgeFnE));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExit(PathEdge<N, D, M> edge) {
        N n = edge.getTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        Object methodThatNeedsSummary = this.icfg.getMethodOf(n);
        D d1 = edge.factAtSource();
        D d2 = edge.factAtTarget();
        for (Object sP : this.icfg.getStartPointsOf(methodThatNeedsSummary)) {
            Set<D> targets;
            FlowFunction<D> retFunction;
            HashSet inc;
            Table<N, D, Map<N, Set<D>>> table = this.incoming;
            synchronized (table) {
                this.addEndSummary(sP, d1, n, d2, f);
                inc = new HashSet(this.incoming(d1, sP));
            }
            for (Map.Entry entry : inc) {
                Object c = entry.getKey();
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    ++this.flowFunctionConstructionCount;
                    targets = retFunction.computeTargets(d2);
                    for (Object d4 : (Set)entry.getValue()) {
                        for (D d5 : targets) {
                            EdgeFunction<V> f4 = this.edgeFunctions.getCallEdgeFunction(c, d4, this.icfg.getMethodOf(n), d1);
                            EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(c, this.icfg.getMethodOf(n), n, d2, retSiteC, d5);
                            EdgeFunction<V> fPrime = f4.composeWith(f).composeWith(f5);
                            for (Map.Entry<D, EdgeFunction<V>> valAndFunc : this.jumpFn.reverseLookup(c, d4).entrySet()) {
                                EdgeFunction<V> f3 = valAndFunc.getValue();
                                if (f3.equalTo(this.allTop)) continue;
                                D d3 = valAndFunc.getKey();
                                this.propagate(d3, retSiteC, d5, f3.composeWith(fPrime));
                            }
                        }
                    }
                }
            }
            if (!inc.isEmpty() || !this.followReturnsPastSeeds) continue;
            Set callers = this.icfg.getCallersOf(methodThatNeedsSummary);
            for (Object c : callers) {
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    ++this.flowFunctionConstructionCount;
                    targets = retFunction.computeTargets(d2);
                    for (Object d5 : targets) {
                        EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(c, this.icfg.getMethodOf(n), n, d2, retSiteC, d5);
                        this.propagate(d2, retSiteC, d5, f.composeWith(f5));
                    }
                }
            }
            if (!callers.isEmpty()) continue;
            FlowFunction<D> flowFunction = this.flowFunctions.getNormalFlowFunction(n, n);
            ++this.flowFunctionConstructionCount;
            flowFunction.computeTargets(d2);
        }
    }

    private void processNormalFlow(PathEdge<N, D, M> edge) {
        D d1 = edge.factAtSource();
        N n = edge.getTarget();
        D d2 = edge.factAtTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        for (N m : this.icfg.getSuccsOf(n)) {
            FlowFunction<D> flowFunction = this.flowFunctions.getNormalFlowFunction(n, m);
            ++this.flowFunctionConstructionCount;
            Set<D> res = flowFunction.computeTargets(d2);
            for (D d3 : res) {
                EdgeFunction<V> fprime = f.composeWith(this.edgeFunctions.getNormalEdgeFunction(n, d2, m, d3));
                this.propagate(d1, m, d3, fprime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagate(D sourceVal, N target, D targetVal, EdgeFunction<V> f) {
        EdgeFunction<V> fPrime;
        boolean newFunction;
        JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
        synchronized (jumpFunctions) {
            EdgeFunction<V> jumpFnE = this.jumpFn.reverseLookup(target, targetVal).get(sourceVal);
            if (jumpFnE == null) {
                jumpFnE = this.allTop;
            }
            boolean bl = newFunction = !(fPrime = jumpFnE.joinWith(f)).equalTo(jumpFnE);
            if (newFunction) {
                this.jumpFn.addFunction(sourceVal, target, targetVal, fPrime);
            }
        }
        if (newFunction) {
            PathEdge edge = new PathEdge(sourceVal, target, targetVal);
            this.scheduleEdgeProcessing(edge);
            if (DEBUG && targetVal != this.zeroValue) {
                StringBuilder result = new StringBuilder();
                result.append("EDGE:  <");
                result.append(this.icfg.getMethodOf(target));
                result.append(",");
                result.append(sourceVal);
                result.append("> -> <");
                result.append(target);
                result.append(",");
                result.append(targetVal);
                result.append("> - ");
                result.append(fPrime);
                System.err.println(result.toString());
            }
        }
    }

    private void computeValues() {
        for (N startPoint : this.initialSeeds) {
            this.setVal(startPoint, this.zeroValue, this.valueLattice.bottomElement());
            Pair<N, D> superGraphNode = new Pair<N, D>(startPoint, this.zeroValue);
            this.scheduleValueProcessing(new ValuePropagationTask(superGraphNode));
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Set allNonCallStartNodes = this.icfg.allNonCallStartNodes();
        Object[] nonCallStartNodesArray = new Object[allNonCallStartNodes.size()];
        int i = 0;
        for (Object n : allNonCallStartNodes) {
            nonCallStartNodesArray[i] = n;
            ++i;
        }
        for (int t = 0; t < this.numThreads; ++t) {
            ValueComputationTask task = new ValueComputationTask(nonCallStartNodesArray, t);
            this.scheduleValueComputationTask(task);
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateValueAtStart(Pair<N, D> nAndD, N n) {
        D d = nAndD.getO2();
        Object p = this.icfg.getMethodOf(n);
        for (Object c : this.icfg.getCallsFromWithin(p)) {
            JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
            synchronized (jumpFunctions) {
                Set<Map.Entry<D, EdgeFunction<V>>> entries = this.jumpFn.forwardLookup(d, c).entrySet();
                for (Map.Entry<D, EdgeFunction<V>> dPAndFP : entries) {
                    D dPrime = dPAndFP.getKey();
                    EdgeFunction<V> fPrime = dPAndFP.getValue();
                    N sP = n;
                    this.propagateValue(c, dPrime, fPrime.computeTarget(this.val(sP, d)));
                    ++this.flowFunctionApplicationCount;
                }
            }
        }
    }

    private void propagateValueAtCall(Pair<N, D> nAndD, N n) {
        D d = nAndD.getO2();
        for (Object q : this.icfg.getCalleesOfCallAt(n)) {
            FlowFunction<D> callFlowFunction = this.flowFunctions.getCallFlowFunction(n, q);
            ++this.flowFunctionConstructionCount;
            for (D dPrime : callFlowFunction.computeTargets(d)) {
                EdgeFunction<V> edgeFn = this.edgeFunctions.getCallEdgeFunction(n, d, q, dPrime);
                for (Object startPoint : this.icfg.getStartPointsOf(q)) {
                    this.propagateValue(startPoint, dPrime, edgeFn.computeTarget(this.val(n, d)));
                    ++this.flowFunctionApplicationCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateValue(N nHashN, D nHashD, V v) {
        Table<N, D, V> table = this.val;
        synchronized (table) {
            V valNHash = this.val(nHashN, nHashD);
            V vPrime = this.valueLattice.join(valNHash, v);
            if (!vPrime.equals(valNHash)) {
                this.setVal(nHashN, nHashD, vPrime);
                this.scheduleValueProcessing(new ValuePropagationTask(new Pair<N, D>(nHashN, nHashD)));
            }
        }
    }

    private V val(N nHashN, D nHashD) {
        V l = this.val.get(nHashN, nHashD);
        if (l == null) {
            return this.valueLattice.topElement();
        }
        return l;
    }

    private void setVal(N nHashN, D nHashD, V l) {
        this.val.put(nHashN, nHashD, l);
        if (DEBUG) {
            System.err.println("VALUE: " + this.icfg.getMethodOf(nHashN) + " " + nHashN + " " + nHashD + " " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdgeFunction<V> jumpFunction(PathEdge<N, D, M> edge) {
        JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
        synchronized (jumpFunctions) {
            EdgeFunction<V> function = this.jumpFn.forwardLookup(edge.factAtSource(), edge.getTarget()).get(edge.factAtTarget());
            if (function == null) {
                return this.allTop;
            }
            return function;
        }
    }

    private Set<Table.Cell<N, D, EdgeFunction<V>>> endSummary(N sP, D d3) {
        Table<N, D, EdgeFunction<V>> map = this.endSummary.get(sP, d3);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.cellSet();
    }

    private void addEndSummary(N sP, D d1, N eP, D d2, EdgeFunction<V> f) {
        Table<N, D, EdgeFunction<EdgeFunction<V>>> summaries = this.endSummary.get(sP, d1);
        if (summaries == null) {
            summaries = HashBasedTable.create();
            this.endSummary.put(sP, d1, summaries);
        }
        summaries.put(eP, d2, f);
    }

    private Set<Map.Entry<N, Set<D>>> incoming(D d1, N sP) {
        Map<N, Set<D>> map = this.incoming.get(sP, d1);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.entrySet();
    }

    private void addIncoming(N sP, D d3, N n, D d2) {
        Set<D> set;
        Map<N, Set<D>> summaries = this.incoming.get(sP, d3);
        if (summaries == null) {
            summaries = new HashMap<N, Set<D>>();
            this.incoming.put(sP, d3, summaries);
        }
        if ((set = summaries.get(n)) == null) {
            set = new HashSet<D>();
            summaries.put(n, set);
        }
        set.add(d2);
    }

    public V resultAt(N stmt, D value) {
        return this.val.get(stmt, value);
    }

    public Map<D, V> resultsAt(N stmt) {
        return Maps.filterKeys(this.val.row(stmt), new Predicate<D>(){

            @Override
            public boolean apply(D val) {
                return val != IDESolver.this.zeroValue;
            }
        });
    }

    protected CountingThreadPoolExecutor getExecutor() {
        return new CountingThreadPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void printStats() {
        if (DEBUG) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
            if (this.efCache != null) {
                this.efCache.printStats();
            }
        } else {
            System.err.println("No statistics were collected, as DEBUG is disabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueComputationTask
    implements Runnable {
        private final N[] values;
        final int num;

        public ValueComputationTask(N[] values, int num) {
            this.values = values;
            this.num = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int sectionSize = (int)Math.floor(this.values.length / IDESolver.this.numThreads) + IDESolver.this.numThreads;
            for (int i = sectionSize * this.num; i < Math.min(sectionSize * (this.num + 1), this.values.length); ++i) {
                Object n = this.values[i];
                for (Object sP : IDESolver.this.icfg.getStartPointsOf(IDESolver.this.icfg.getMethodOf(n))) {
                    Set lookupByTarget = IDESolver.this.jumpFn.lookupByTarget(n);
                    for (Table.Cell sourceValTargetValAndFunction : lookupByTarget) {
                        Object dPrime = sourceValTargetValAndFunction.getRowKey();
                        Object d = sourceValTargetValAndFunction.getColumnKey();
                        EdgeFunction<Object> fPrime = sourceValTargetValAndFunction.getValue();
                        Table table = IDESolver.this.val;
                        synchronized (table) {
                            IDESolver.this.setVal(n, d, IDESolver.this.valueLattice.join(IDESolver.this.val(n, d), fPrime.computeTarget(IDESolver.this.val(sP, dPrime))));
                        }
                        ++IDESolver.this.flowFunctionApplicationCount;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuePropagationTask
    implements Runnable {
        private final Pair<N, D> nAndD;

        public ValuePropagationTask(Pair<N, D> nAndD) {
            this.nAndD = nAndD;
        }

        @Override
        public void run() {
            Object n = this.nAndD.getO1();
            if (IDESolver.this.icfg.isStartPoint(n) || IDESolver.this.initialSeeds.contains(n)) {
                IDESolver.this.propagateValueAtStart(this.nAndD, n);
            }
            if (IDESolver.this.icfg.isCallStmt(n)) {
                IDESolver.this.propagateValueAtCall(this.nAndD, n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<N, D, M> edge;

        public PathEdgeProcessingTask(PathEdge<N, D, M> edge) {
            this.edge = edge;
        }

        @Override
        public void run() {
            if (IDESolver.this.icfg.isCallStmt(this.edge.getTarget())) {
                IDESolver.this.processCall(this.edge);
            } else {
                if (IDESolver.this.icfg.isExitStmt(this.edge.getTarget())) {
                    IDESolver.this.processExit(this.edge);
                }
                if (!IDESolver.this.icfg.getSuccsOf(this.edge.getTarget()).isEmpty()) {
                    IDESolver.this.processNormalFlow(this.edge);
                }
            }
        }
    }
}

