/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackedSwitchMethodItem
extends InstructionMethodItem<PackedSwitchDataPseudoInstruction> {
    private final List<PackedSwitchTarget> targets;

    public PackedSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, PackedSwitchDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, instruction);
        int baseCodeAddress = methodDefinition.getPackedSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<PackedSwitchTarget>();
        Iterator<PackedSwitchDataPseudoInstruction.PackedSwitchTarget> iterator = instruction.iterateKeysAndTargets();
        if (baseCodeAddress >= 0) {
            while (iterator.hasNext()) {
                PackedSwitchDataPseudoInstruction.PackedSwitchTarget target = iterator.next();
                PackedSwitchLabelTarget packedSwitchLabelTarget = new PackedSwitchLabelTarget();
                LabelMethodItem label = new LabelMethodItem(baseCodeAddress + target.targetAddressOffset, "pswitch_");
                packedSwitchLabelTarget.Target = label = methodDefinition.getLabelCache().internLabel(label);
                this.targets.add(packedSwitchLabelTarget);
            }
        } else {
            while (iterator.hasNext()) {
                PackedSwitchDataPseudoInstruction.PackedSwitchTarget target = iterator.next();
                PackedSwitchOffsetTarget packedSwitchOffsetTarget = new PackedSwitchOffsetTarget();
                packedSwitchOffsetTarget.Target = target.targetAddressOffset;
                this.targets.add(packedSwitchOffsetTarget);
            }
        }
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".packed-switch ");
        IntegerRenderer.writeTo(writer, ((PackedSwitchDataPseudoInstruction)this.instruction).getFirstKey());
        writer.indent(4);
        writer.write(10);
        for (PackedSwitchTarget target : this.targets) {
            target.writeTargetTo(writer);
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end packed-switch");
        return true;
    }

    private static class PackedSwitchOffsetTarget
    extends PackedSwitchTarget {
        public int Target;

        private PackedSwitchOffsetTarget() {
        }

        public void writeTargetTo(IndentingWriter writer) throws IOException {
            if (this.Target >= 0) {
                writer.write(43);
            }
            writer.printSignedIntAsDec(this.Target);
        }
    }

    private static class PackedSwitchLabelTarget
    extends PackedSwitchTarget {
        public LabelMethodItem Target;

        private PackedSwitchLabelTarget() {
        }

        public void writeTargetTo(IndentingWriter writer) throws IOException {
            this.Target.writeTo(writer);
        }
    }

    private static abstract class PackedSwitchTarget {
        private PackedSwitchTarget() {
        }

        public abstract void writeTargetTo(IndentingWriter var1) throws IOException;
    }
}

