/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.baksmali.baksmali;
import org.jf.baksmali.dump;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.util.ConsoleUtil;
import org.jf.util.smaliHelpFormatter;

public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;
    public static final int ALL = 1;
    public static final int ALLPRE = 2;
    public static final int ALLPOST = 4;
    public static final int ARGS = 8;
    public static final int DEST = 16;
    public static final int MERGE = 32;
    public static final int FULLMERGE = 64;

    private main() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser2 = new PosixParser();
        try {
            commandLine = parser2.parse(options, args);
        }
        catch (ParseException ex) {
            main.usage();
            return;
        }
        boolean disassemble = true;
        boolean doDump = false;
        boolean write = false;
        boolean sort = false;
        boolean fixRegisters = false;
        boolean noParameterRegisters = false;
        boolean useLocalsDirective = false;
        boolean useSequentialLabels = false;
        boolean outputDebugInfo = true;
        boolean addCodeOffsets = false;
        boolean noAccessorComments = false;
        boolean deodex = false;
        boolean verify = false;
        boolean ignoreErrors = false;
        int apiLevel = 14;
        int registerInfo = 0;
        String outputDirectory = "out";
        String dumpFileName = null;
        String outputDexFileName = null;
        String inputDexFileName = null;
        String bootClassPath = null;
        StringBuffer extraBootClassPathEntries = new StringBuffer();
        ArrayList<String> bootClassPathDirs = new ArrayList<String>();
        bootClassPathDirs.add(".");
        String inlineTable = null;
        String[] remainingArgs = commandLine.getArgs();
        Option[] options = commandLine.getOptions();
        block31: for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < options.length) {
                        if (options[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    outputDirectory = commandLine.getOptionValue("o");
                    continue block31;
                }
                case 'p': {
                    noParameterRegisters = true;
                    continue block31;
                }
                case 'l': {
                    useLocalsDirective = true;
                    continue block31;
                }
                case 's': {
                    useSequentialLabels = true;
                    continue block31;
                }
                case 'b': {
                    outputDebugInfo = false;
                    continue block31;
                }
                case 'd': {
                    bootClassPathDirs.add(option.getValue());
                    continue block31;
                }
                case 'f': {
                    addCodeOffsets = true;
                    continue block31;
                }
                case 'r': {
                    String[] values = commandLine.getOptionValues('r');
                    if (values == null || values.length == 0) {
                        registerInfo = 24;
                        continue block31;
                    }
                    for (String value : values) {
                        if (value.equalsIgnoreCase("ALL")) {
                            registerInfo |= 1;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ALLPRE")) {
                            registerInfo |= 2;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ALLPOST")) {
                            registerInfo |= 4;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ARGS")) {
                            registerInfo |= 8;
                            continue;
                        }
                        if (value.equalsIgnoreCase("DEST")) {
                            registerInfo |= 0x10;
                            continue;
                        }
                        if (value.equalsIgnoreCase("MERGE")) {
                            registerInfo |= 0x20;
                            continue;
                        }
                        if (value.equalsIgnoreCase("FULLMERGE")) {
                            registerInfo |= 0x40;
                            continue;
                        }
                        main.usage();
                        return;
                    }
                    if ((registerInfo & 0x40) == 0) continue block31;
                    registerInfo &= 0xFFFFFFDF;
                    continue block31;
                }
                case 'c': {
                    String bcp = commandLine.getOptionValue("c");
                    if (bcp != null && bcp.charAt(0) == ':') {
                        extraBootClassPathEntries.append(bcp);
                        continue block31;
                    }
                    bootClassPath = bcp;
                    continue block31;
                }
                case 'x': {
                    deodex = true;
                    continue block31;
                }
                case 'm': {
                    noAccessorComments = true;
                    continue block31;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    continue block31;
                }
                case 'N': {
                    disassemble = false;
                    continue block31;
                }
                case 'D': {
                    doDump = true;
                    dumpFileName = commandLine.getOptionValue("D", inputDexFileName + ".dump");
                    continue block31;
                }
                case 'I': {
                    ignoreErrors = true;
                    continue block31;
                }
                case 'W': {
                    write = true;
                    outputDexFileName = commandLine.getOptionValue("W");
                    continue block31;
                }
                case 'S': {
                    sort = true;
                    continue block31;
                }
                case 'F': {
                    fixRegisters = true;
                    continue block31;
                }
                case 'V': {
                    verify = true;
                    continue block31;
                }
                case 'T': {
                    inlineTable = commandLine.getOptionValue("T");
                    continue block31;
                }
                default: {
                    assert (false);
                    continue block31;
                }
            }
        }
        if (remainingArgs.length != 1) {
            main.usage();
            return;
        }
        inputDexFileName = remainingArgs[0];
        try {
            File dexFileFile = new File(inputDexFileName);
            if (!dexFileFile.exists()) {
                System.err.println("Can't find the file " + inputDexFileName);
                System.exit(1);
            }
            Opcode.updateMapsForApiLevel(apiLevel);
            DexFile dexFile = new DexFile(dexFileFile, !fixRegisters, false);
            if (dexFile.isOdex()) {
                if (doDump) {
                    System.err.println("-D cannot be used with on odex file. Ignoring -D");
                }
                if (write) {
                    System.err.println("-W cannot be used with an odex file. Ignoring -W");
                }
                if (!deodex) {
                    System.err.println("Warning: You are disassembling an odex file without deodexing it. You");
                    System.err.println("won't be able to re-assemble the results unless you deodex it with the -x");
                    System.err.println("option");
                }
            } else {
                deodex = false;
                if (bootClassPath == null) {
                    bootClassPath = "core.jar:ext.jar:framework.jar:android.policy.jar:services.jar";
                }
            }
            if (disassemble) {
                String[] bootClassPathDirsArray = new String[bootClassPathDirs.size()];
                for (int i = 0; i < bootClassPathDirsArray.length; ++i) {
                    bootClassPathDirsArray[i] = (String)bootClassPathDirs.get(i);
                }
                baksmali.disassembleDexFile(dexFileFile.getPath(), dexFile, deodex, outputDirectory, bootClassPathDirsArray, bootClassPath, extraBootClassPathEntries.toString(), noParameterRegisters, useLocalsDirective, useSequentialLabels, outputDebugInfo, addCodeOffsets, noAccessorComments, registerInfo, verify, ignoreErrors, inlineTable);
            }
            if ((doDump || write) && !dexFile.isOdex()) {
                try {
                    dump.dump(dexFile, dumpFileName, outputDexFileName, sort);
                }
                catch (IOException ex) {
                    System.err.println("Error occured while writing dump file");
                    ex.printStackTrace();
                }
            }
        }
        catch (RuntimeException ex) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Throwable ex) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL ERROR:");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage(boolean printDebugOptions) {
        smaliHelpFormatter formatter = new smaliHelpFormatter();
        formatter.setWidth(ConsoleUtil.getConsoleWidth());
        formatter.printHelp("java -jar baksmali.jar [options] <dex-file>", "disassembles and/or dumps a dex file", basicOptions, "");
        if (printDebugOptions) {
            System.out.println();
            System.out.println("Debug Options:");
            StringBuffer sb = new StringBuffer();
            formatter.renderOptions(sb, debugOptions);
            System.out.println(sb.toString());
        }
    }

    private static void usage() {
        main.usage(false);
    }

    protected static void version() {
        System.out.println("baksmali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("prints the version then exits");
        Option versionOption = OptionBuilder.create("v");
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("prints the help message then exits. Specify twice for debug options");
        Option helpOption = OptionBuilder.create("?");
        OptionBuilder.withLongOpt("output");
        OptionBuilder.withDescription("the directory where the disassembled files will be placed. The default is out");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option outputDirOption = OptionBuilder.create("o");
        OptionBuilder.withLongOpt("no-parameter-registers");
        OptionBuilder.withDescription("use the v<n> syntax instead of the p<n> syntax for registers mapped to method parameters");
        Option noParameterRegistersOption = OptionBuilder.create("p");
        OptionBuilder.withLongOpt("deodex");
        OptionBuilder.withDescription("deodex the given odex file. This option is ignored if the input file is not an odex file");
        Option deodexerantOption = OptionBuilder.create("x");
        OptionBuilder.withLongOpt("use-locals");
        OptionBuilder.withDescription("output the .locals directive with the number of non-parameter registers, rather than the .register directive with the total number of register");
        Option useLocalsOption = OptionBuilder.create("l");
        OptionBuilder.withLongOpt("sequential-labels");
        OptionBuilder.withDescription("create label names using a sequential numbering scheme per label type, rather than using the bytecode address");
        Option sequentialLabelsOption = OptionBuilder.create("s");
        OptionBuilder.withLongOpt("no-debug-info");
        OptionBuilder.withDescription("don't write out debug info (.local, .param, .line, etc.)");
        Option noDebugInfoOption = OptionBuilder.create("b");
        OptionBuilder.withLongOpt("register-info");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName("REGISTER_INFO_TYPES");
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withDescription("print the specificed type(s) of register information for each instruction. \"ARGS,DEST\" is the default if no types are specified.\nValid values are:\nALL: all pre- and post-instruction registers.\nALLPRE: all pre-instruction registers\nALLPOST: all post-instruction registers\nARGS: any pre-instruction registers used as arguments to the instruction\nDEST: the post-instruction destination register, if any\nMERGE: Any pre-instruction register has been merged from more than 1 different post-instruction register from its predecessors\nFULLMERGE: For each register that would be printed by MERGE, also show the incoming register types that were merged");
        Option registerInfoOption = OptionBuilder.create("r");
        OptionBuilder.withLongOpt("bootclasspath");
        OptionBuilder.withDescription("the bootclasspath jars to use, for analysis. Defaults to core.jar:ext.jar:framework.jar:android.policy.jar:services.jar. If the value begins with a :, it will be appended to the default bootclasspath instead of replacing it");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("BOOTCLASSPATH");
        Option classPathOption = OptionBuilder.create("c");
        OptionBuilder.withLongOpt("bootclasspath-dir");
        OptionBuilder.withDescription("the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option classPathDirOption = OptionBuilder.create("d");
        OptionBuilder.withLongOpt("code-offsets");
        OptionBuilder.withDescription("add comments to the disassembly containing the code offset for each address");
        Option codeOffsetOption = OptionBuilder.create("f");
        OptionBuilder.withLongOpt("no-accessor-comments");
        OptionBuilder.withDescription("don't output helper comments for synthetic accessors");
        Option noAccessorCommentsOption = OptionBuilder.create("m");
        OptionBuilder.withLongOpt("api-level");
        OptionBuilder.withDescription("The numeric api-level of the file being disassembled. If not specified, it defaults to 14 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("API_LEVEL");
        Option apiLevelOption = OptionBuilder.create("a");
        OptionBuilder.withLongOpt("dump-to");
        OptionBuilder.withDescription("dumps the given dex file into a single annotated dump file named FILE (<dexfile>.dump by default), along with the normal disassembly");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("FILE");
        Option dumpOption = OptionBuilder.create("D");
        OptionBuilder.withLongOpt("ignore-errors");
        OptionBuilder.withDescription("ignores any non-fatal errors that occur while disassembling/deodexing, ignoring the class if needed, and continuing with the next class. The default behavior is to stop disassembling and exit once an error is encountered");
        Option ignoreErrorsOption = OptionBuilder.create("I");
        OptionBuilder.withLongOpt("no-disassembly");
        OptionBuilder.withDescription("suppresses the output of the disassembly");
        Option noDisassemblyOption = OptionBuilder.create("N");
        OptionBuilder.withLongOpt("write-dex");
        OptionBuilder.withDescription("additionally rewrites the input dex file to FILE");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FILE");
        Option writeDexOption = OptionBuilder.create("W");
        OptionBuilder.withLongOpt("sort");
        OptionBuilder.withDescription("sort the items in the dex file into a canonical order before dumping/writing");
        Option sortOption = OptionBuilder.create("S");
        OptionBuilder.withLongOpt("fix-signed-registers");
        OptionBuilder.withDescription("when dumping or rewriting, fix any registers in the debug info that are encoded as a signed value");
        Option fixSignedRegisterOption = OptionBuilder.create("F");
        OptionBuilder.withLongOpt("verify");
        OptionBuilder.withDescription("perform bytecode verification");
        Option verifyDexOption = OptionBuilder.create("V");
        OptionBuilder.withLongOpt("inline-table");
        OptionBuilder.withDescription("specify a file containing a custom inline method table to use for deodexing");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FILE");
        Option inlineTableOption = OptionBuilder.create("T");
        basicOptions.addOption(versionOption);
        basicOptions.addOption(helpOption);
        basicOptions.addOption(outputDirOption);
        basicOptions.addOption(noParameterRegistersOption);
        basicOptions.addOption(deodexerantOption);
        basicOptions.addOption(useLocalsOption);
        basicOptions.addOption(sequentialLabelsOption);
        basicOptions.addOption(noDebugInfoOption);
        basicOptions.addOption(registerInfoOption);
        basicOptions.addOption(classPathOption);
        basicOptions.addOption(classPathDirOption);
        basicOptions.addOption(codeOffsetOption);
        basicOptions.addOption(noAccessorCommentsOption);
        basicOptions.addOption(apiLevelOption);
        debugOptions.addOption(dumpOption);
        debugOptions.addOption(ignoreErrorsOption);
        debugOptions.addOption(noDisassemblyOption);
        debugOptions.addOption(writeDexOption);
        debugOptions.addOption(sortOption);
        debugOptions.addOption(fixSignedRegisterOption);
        debugOptions.addOption(verifyDexOption);
        debugOptions.addOption(inlineTableOption);
        for (Object option : basicOptions.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : debugOptions.getOptions()) {
            options.addOption((Option)option);
        }
    }

    static {
        options = new Options();
        basicOptions = new Options();
        debugOptions = new Options();
        main.buildOptions();
        InputStream templateStream = baksmali.class.getClassLoader().getResourceAsStream("baksmali.properties");
        Properties properties = new Properties();
        String version2 = "(unknown)";
        try {
            properties.load(templateStream);
            version2 = properties.getProperty("application.version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = version2;
    }
}

