/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Collections;
import java.util.List;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDataItem
extends Item<ClassDataItem> {
    private EncodedField[] staticFields;
    private EncodedField[] instanceFields;
    private EncodedMethod[] directMethods;
    private EncodedMethod[] virtualMethods;
    private ClassDefItem parent = null;

    public ClassDataItem(DexFile dexFile) {
        super(dexFile);
    }

    private ClassDataItem(DexFile dexFile, EncodedField[] staticFields, EncodedField[] instanceFields, EncodedMethod[] directMethods, EncodedMethod[] virtualMethods) {
        super(dexFile);
        this.staticFields = staticFields == null ? new EncodedField[]{} : staticFields;
        this.instanceFields = instanceFields == null ? new EncodedField[]{} : instanceFields;
        this.directMethods = directMethods == null ? new EncodedMethod[]{} : directMethods;
        this.virtualMethods = virtualMethods == null ? new EncodedMethod[]{} : virtualMethods;
    }

    public static ClassDataItem internClassDataItem(DexFile dexFile, List<EncodedField> staticFields, List<EncodedField> instanceFields, List<EncodedMethod> directMethods, List<EncodedMethod> virtualMethods) {
        EncodedField[] staticFieldsArray = null;
        EncodedField[] instanceFieldsArray = null;
        EncodedMethod[] directMethodsArray = null;
        EncodedMethod[] virtualMethodsArray = null;
        if (staticFields != null && staticFields.size() > 0) {
            Collections.sort(staticFields);
            staticFieldsArray = new EncodedField[staticFields.size()];
            staticFields.toArray(staticFieldsArray);
        }
        if (instanceFields != null && instanceFields.size() > 0) {
            Collections.sort(instanceFields);
            instanceFieldsArray = new EncodedField[instanceFields.size()];
            instanceFields.toArray(instanceFieldsArray);
        }
        if (directMethods != null && directMethods.size() > 0) {
            Collections.sort(directMethods);
            directMethodsArray = new EncodedMethod[directMethods.size()];
            directMethods.toArray(directMethodsArray);
        }
        if (virtualMethods != null && virtualMethods.size() > 0) {
            Collections.sort(virtualMethods);
            virtualMethodsArray = new EncodedMethod[virtualMethods.size()];
            virtualMethods.toArray(virtualMethodsArray);
        }
        ClassDataItem classDataItem = new ClassDataItem(dexFile, staticFieldsArray, instanceFieldsArray, directMethodsArray, virtualMethodsArray);
        return dexFile.ClassDataSection.intern(classDataItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int i;
        int i2;
        this.staticFields = new EncodedField[in.readUnsignedLeb128()];
        this.instanceFields = new EncodedField[in.readUnsignedLeb128()];
        this.directMethods = new EncodedMethod[in.readUnsignedLeb128()];
        this.virtualMethods = new EncodedMethod[in.readUnsignedLeb128()];
        EncodedField previousEncodedField = null;
        for (i2 = 0; i2 < this.staticFields.length; ++i2) {
            try {
                this.staticFields[i2] = previousEncodedField = new EncodedField(this.dexFile, in, previousEncodedField);
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error while reading static field at index " + i2);
            }
        }
        previousEncodedField = null;
        for (i2 = 0; i2 < this.instanceFields.length; ++i2) {
            try {
                this.instanceFields[i2] = previousEncodedField = new EncodedField(this.dexFile, in, previousEncodedField);
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error while reading instance field at index " + i2);
            }
        }
        EncodedMethod previousEncodedMethod = null;
        for (i = 0; i < this.directMethods.length; ++i) {
            try {
                this.directMethods[i] = previousEncodedMethod = new EncodedMethod(this.dexFile, readContext, in, previousEncodedMethod);
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error while reading direct method at index " + i);
            }
        }
        previousEncodedMethod = null;
        for (i = 0; i < this.virtualMethods.length; ++i) {
            try {
                this.virtualMethods[i] = previousEncodedMethod = new EncodedMethod(this.dexFile, readContext, in, previousEncodedMethod);
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error while reading virtual method at index " + i);
            }
        }
    }

    @Override
    protected int placeItem(int offset) {
        offset += Leb128Utils.unsignedLeb128Size(this.staticFields.length);
        offset += Leb128Utils.unsignedLeb128Size(this.instanceFields.length);
        offset += Leb128Utils.unsignedLeb128Size(this.directMethods.length);
        offset += Leb128Utils.unsignedLeb128Size(this.virtualMethods.length);
        EncodedField previousEncodedField = null;
        for (EncodedField encodedField : this.staticFields) {
            offset = encodedField.place(offset, previousEncodedField);
            previousEncodedField = encodedField;
        }
        previousEncodedField = null;
        for (EncodedField encodedField : this.instanceFields) {
            offset = encodedField.place(offset, previousEncodedField);
            previousEncodedField = encodedField;
        }
        EncodedMethod previousEncodedMethod = null;
        for (EncodedMethod encodedMethod : this.directMethods) {
            offset = encodedMethod.place(offset, previousEncodedMethod);
            previousEncodedMethod = encodedMethod;
        }
        previousEncodedMethod = null;
        for (EncodedMethod encodedMethod : this.virtualMethods) {
            offset = encodedMethod.place(offset, previousEncodedMethod);
            previousEncodedMethod = encodedMethod;
        }
        return offset;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate("static_fields_size: 0x" + Integer.toHexString(this.staticFields.length) + " (" + this.staticFields.length + ")");
            out.writeUnsignedLeb128(this.staticFields.length);
            out.annotate("instance_fields_size: 0x" + Integer.toHexString(this.instanceFields.length) + " (" + this.instanceFields.length + ")");
            out.writeUnsignedLeb128(this.instanceFields.length);
            out.annotate("direct_methods_size: 0x" + Integer.toHexString(this.directMethods.length) + " (" + this.directMethods.length + ")");
            out.writeUnsignedLeb128(this.directMethods.length);
            out.annotate("virtual_methods_size: 0x" + Integer.toHexString(this.virtualMethods.length) + " (" + this.virtualMethods.length + ")");
            out.writeUnsignedLeb128(this.virtualMethods.length);
            int index = 0;
            EncodedField previousEncodedField = null;
            for (EncodedField encodedField : this.staticFields) {
                out.annotate("[" + index++ + "] static_field");
                out.indent();
                encodedField.writeTo(out, previousEncodedField);
                out.deindent();
                previousEncodedField = encodedField;
            }
            index = 0;
            previousEncodedField = null;
            for (EncodedField encodedField : this.instanceFields) {
                out.annotate("[" + index++ + "] instance_field");
                out.indent();
                encodedField.writeTo(out, previousEncodedField);
                out.deindent();
                previousEncodedField = encodedField;
            }
            index = 0;
            EncodedMethod previousEncodedMethod = null;
            for (EncodedMethod encodedMethod : this.directMethods) {
                out.annotate("[" + index++ + "] direct_method");
                out.indent();
                encodedMethod.writeTo(out, previousEncodedMethod);
                out.deindent();
                previousEncodedMethod = encodedMethod;
            }
            index = 0;
            previousEncodedMethod = null;
            for (EncodedMethod encodedMethod : this.virtualMethods) {
                out.annotate("[" + index++ + "] virtual_method");
                out.indent();
                encodedMethod.writeTo(out, previousEncodedMethod);
                out.deindent();
                previousEncodedMethod = encodedMethod;
            }
        } else {
            out.writeUnsignedLeb128(this.staticFields.length);
            out.writeUnsignedLeb128(this.instanceFields.length);
            out.writeUnsignedLeb128(this.directMethods.length);
            out.writeUnsignedLeb128(this.virtualMethods.length);
            EncodedField previousEncodedField = null;
            for (EncodedField encodedField : this.staticFields) {
                encodedField.writeTo(out, previousEncodedField);
                previousEncodedField = encodedField;
            }
            previousEncodedField = null;
            for (EncodedField encodedField : this.instanceFields) {
                encodedField.writeTo(out, previousEncodedField);
                previousEncodedField = encodedField;
            }
            EncodedMethod previousEncodedMethod = null;
            for (EncodedMethod encodedMethod : this.directMethods) {
                encodedMethod.writeTo(out, previousEncodedMethod);
                previousEncodedMethod = encodedMethod;
            }
            previousEncodedMethod = null;
            for (EncodedMethod encodedMethod : this.virtualMethods) {
                encodedMethod.writeTo(out, previousEncodedMethod);
                previousEncodedMethod = encodedMethod;
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CLASS_DATA_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "class_data_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "class_data_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.getClassType() + ")";
    }

    @Override
    public int compareTo(ClassDataItem other) {
        if (this.parent == null) {
            if (other.parent == null) {
                return 0;
            }
            return -1;
        }
        if (other.parent == null) {
            return 1;
        }
        return this.parent.compareTo(other.parent);
    }

    protected void setParent(ClassDefItem classDefItem) {
        this.parent = classDefItem;
    }

    public EncodedField[] getStaticFields() {
        return this.staticFields;
    }

    public EncodedField[] getInstanceFields() {
        return this.instanceFields;
    }

    public EncodedMethod[] getDirectMethods() {
        return this.directMethods;
    }

    public EncodedMethod[] getVirtualMethods() {
        return this.virtualMethods;
    }

    public EncodedMethod findDirectMethodByMethodId(MethodIdItem methodIdItem) {
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.directMethods);
    }

    public EncodedMethod findVirtualMethodByMethodId(MethodIdItem methodIdItem) {
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.virtualMethods);
    }

    public EncodedMethod findMethodByMethodId(MethodIdItem methodIdItem) {
        EncodedMethod encodedMethod = ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.directMethods);
        if (encodedMethod != null) {
            return encodedMethod;
        }
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.virtualMethods);
    }

    private static EncodedMethod findMethodByMethodIdInternal(int methodIdItemIndex, EncodedMethod[] encodedMethods) {
        int min = 0;
        int max = encodedMethods.length;
        while (min < max) {
            int index = min + max >> 1;
            EncodedMethod encodedMethod = encodedMethods[index];
            int encodedMethodIndex = encodedMethod.method.getIndex();
            if (encodedMethodIndex == methodIdItemIndex) {
                return encodedMethod;
            }
            if (encodedMethodIndex < methodIdItemIndex) {
                if (min == index) break;
                min = index;
                continue;
            }
            if (max == index) break;
            max = index;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncodedMethod
    implements Comparable<EncodedMethod> {
        public final MethodIdItem method;
        public final int accessFlags;
        public final CodeItem codeItem;

        public EncodedMethod(MethodIdItem method, int accessFlags, CodeItem codeItem) {
            this.method = method;
            this.accessFlags = accessFlags;
            this.codeItem = codeItem;
            if (codeItem != null) {
                codeItem.setParent(this);
            }
        }

        public EncodedMethod(DexFile dexFile, ReadContext readContext, Input in, EncodedMethod previousEncodedMethod) {
            int previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            this.method = dexFile.MethodIdsSection.getItemByIndex(in.readUnsignedLeb128() + previousIndex);
            this.accessFlags = in.readUnsignedLeb128();
            if (dexFile.skipInstructions()) {
                in.readUnsignedLeb128();
                this.codeItem = null;
            } else {
                this.codeItem = (CodeItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_CODE_ITEM, in.readUnsignedLeb128());
            }
            if (this.codeItem != null) {
                this.codeItem.setParent(this);
            }
        }

        private void writeTo(AnnotatedOutput out, EncodedMethod previousEncodedMethod) {
            int previousIndex;
            int n = previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            if (out.annotates()) {
                out.annotate("method: " + this.method.getMethodString());
                out.writeUnsignedLeb128(this.method.getIndex() - previousIndex);
                out.annotate("access_flags: " + AccessFlags.formatAccessFlagsForMethod(this.accessFlags));
                out.writeUnsignedLeb128(this.accessFlags);
                if (this.codeItem != null) {
                    out.annotate("code_off: 0x" + Integer.toHexString(this.codeItem.getOffset()));
                    out.writeUnsignedLeb128(this.codeItem.getOffset());
                } else {
                    out.annotate("code_off: 0x0");
                    out.writeUnsignedLeb128(0);
                }
            } else {
                out.writeUnsignedLeb128(this.method.getIndex() - previousIndex);
                out.writeUnsignedLeb128(this.accessFlags);
                out.writeUnsignedLeb128(this.codeItem == null ? 0 : this.codeItem.getOffset());
            }
        }

        private int place(int offset, EncodedMethod previousEncodedMethod) {
            int previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            offset += Leb128Utils.unsignedLeb128Size(this.method.getIndex() - previousIndex);
            offset += Leb128Utils.unsignedLeb128Size(this.accessFlags);
            return offset += this.codeItem == null ? 1 : Leb128Utils.unsignedLeb128Size(this.codeItem.getOffset());
        }

        @Override
        public int compareTo(EncodedMethod other) {
            return this.method.compareTo(other.method);
        }

        public boolean isDirect() {
            return (this.accessFlags & (AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue())) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncodedField
    implements Comparable<EncodedField> {
        public final FieldIdItem field;
        public final int accessFlags;

        public EncodedField(FieldIdItem field, int accessFlags) {
            this.field = field;
            this.accessFlags = accessFlags;
        }

        private EncodedField(DexFile dexFile, Input in, EncodedField previousEncodedField) {
            int previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            this.field = dexFile.FieldIdsSection.getItemByIndex(in.readUnsignedLeb128() + previousIndex);
            this.accessFlags = in.readUnsignedLeb128();
        }

        private void writeTo(AnnotatedOutput out, EncodedField previousEncodedField) {
            int previousIndex;
            int n = previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            if (out.annotates()) {
                out.annotate("field: " + this.field.getFieldString());
                out.writeUnsignedLeb128(this.field.getIndex() - previousIndex);
                out.annotate("access_flags: " + AccessFlags.formatAccessFlagsForField(this.accessFlags));
                out.writeUnsignedLeb128(this.accessFlags);
            } else {
                out.writeUnsignedLeb128(this.field.getIndex() - previousIndex);
                out.writeUnsignedLeb128(this.accessFlags);
            }
        }

        private int place(int offset, EncodedField previousEncodedField) {
            int previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            offset += Leb128Utils.unsignedLeb128Size(this.field.getIndex() - previousIndex);
            return offset += Leb128Utils.unsignedLeb128Size(this.accessFlags);
        }

        @Override
        public int compareTo(EncodedField other) {
            return this.field.compareTo(other.field);
        }

        public boolean isStatic() {
            return (this.accessFlags & AccessFlags.STATIC.getValue()) != 0;
        }
    }
}

