/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.OdexedInvokeInline;

public abstract class InlineMethodResolver {
    public static InlineMethodResolver createInlineMethodResolver(DeodexUtil deodexUtil, int odexVersion) {
        if (odexVersion == 35) {
            return new InlineMethodResolver_version35(deodexUtil);
        }
        if (odexVersion == 36) {
            return new InlineMethodResolver_version36(deodexUtil);
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    protected InlineMethodResolver() {
    }

    public abstract DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction var1);

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final DeodexUtil.InlineMethod[] inlineMethods;
        private final DeodexUtil.InlineMethod indexOfIMethod = new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "indexOf", "I", "I");
        private final DeodexUtil.InlineMethod indexOfIIMethod = new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "indexOf", "II", "I");
        private final DeodexUtil.InlineMethod fastIndexOfMethod = new DeodexUtil.InlineMethod(1, "Ljava/lang/String;", "fastIndexOf", "II", "I");
        private final DeodexUtil.InlineMethod isEmptyMethod = new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "isEmpty", "", "Z");

        public InlineMethodResolver_version36(DeodexUtil deodexUtil) {
            this.inlineMethods = new DeodexUtil.InlineMethod[]{new DeodexUtil.InlineMethod(2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "charAt", "I", "C"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), null, null, new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "length", "", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "I", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "J", "J"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "F", "F"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "min", "II", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "max", "II", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "sqrt", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "cos", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "sin", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Float;", "floatToIntBits", "F", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Float;", "intBitsToFloat", "I", "F"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Double;", "doubleToLongBits", "D", "J"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Double;", "longBitsToDouble", "J", "D")};
        }

        public DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            assert (analyzedInstruction.instruction instanceof OdexedInvokeInline);
            OdexedInvokeInline instruction = (OdexedInvokeInline)((Object)analyzedInstruction.instruction);
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + inlineIndex);
            }
            if (inlineIndex == 4) {
                int parameterCount = this.getParameterCount(instruction);
                if (parameterCount == 2) {
                    return this.indexOfIMethod;
                }
                if (parameterCount == 3) {
                    return this.fastIndexOfMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (inlineIndex == 5) {
                int parameterCount = this.getParameterCount(instruction);
                if (parameterCount == 3) {
                    return this.indexOfIIMethod;
                }
                if (parameterCount == 1) {
                    return this.isEmptyMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            return this.inlineMethods[inlineIndex];
        }

        private int getParameterCount(OdexedInvokeInline instruction) {
            return instruction.getRegCount();
        }
    }

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final DeodexUtil.InlineMethod[] inlineMethods = new DeodexUtil.InlineMethod[]{new DeodexUtil.InlineMethod(2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "charAt", "I", "C"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), new DeodexUtil.InlineMethod(0, "Ljava/lang/String;", "length", "", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "I", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "J", "J"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "F", "F"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "abs", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "min", "II", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "max", "II", "I"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "sqrt", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "cos", "D", "D"), new DeodexUtil.InlineMethod(2, "Ljava/lang/Math;", "sin", "D", "D")};

        public InlineMethodResolver_version35(DeodexUtil deodexUtil) {
        }

        public DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            assert (analyzedInstruction.instruction instanceof OdexedInvokeInline);
            OdexedInvokeInline instruction = (OdexedInvokeInline)((Object)analyzedInstruction.instruction);
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid inline index: " + inlineIndex);
            }
            return this.inlineMethods[inlineIndex];
        }
    }
}

