/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.HashMap;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.DexFileClassMap;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.Util.AccessFlags;

public class SyntheticAccessorResolver {
    public static final int METHOD = 0;
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    private final DexFileClassMap classMap;
    private final HashMap<MethodIdItem, AccessedMember> resolvedAccessors = new HashMap();

    public SyntheticAccessorResolver(DexFile dexFile) {
        this.classMap = new DexFileClassMap(dexFile);
    }

    public static boolean looksLikeSyntheticAccessor(MethodIdItem methodIdItem) {
        return methodIdItem.getMethodName().getStringValue().startsWith("access$");
    }

    public AccessedMember getAccessedMember(MethodIdItem methodIdItem) {
        AccessedMember accessedMember = this.resolvedAccessors.get(methodIdItem);
        if (accessedMember != null) {
            return accessedMember;
        }
        ClassDefItem classDefItem = this.classMap.getClassDefByType(methodIdItem.getContainingClass());
        if (classDefItem == null) {
            return null;
        }
        ClassDataItem.EncodedMethod encodedMethod = classDefItem.getClassData().findDirectMethodByMethodId(methodIdItem);
        if (encodedMethod == null) {
            return null;
        }
        if ((encodedMethod.accessFlags & AccessFlags.SYNTHETIC.getValue()) == 0) {
            return null;
        }
        Instruction[] instructions = encodedMethod.codeItem.getInstructions();
        switch (instructions[0].opcode.format) {
            case Format35c: 
            case Format3rc: {
                if (instructions.length < 2 || instructions.length > 3) {
                    return null;
                }
                InstructionWithReference instruction = (InstructionWithReference)instructions[0];
                MethodIdItem referencedMethodIdItem = (MethodIdItem)instruction.getReferencedItem();
                accessedMember = new AccessedMember(0, referencedMethodIdItem);
                this.resolvedAccessors.put(methodIdItem, accessedMember);
                return accessedMember;
            }
            case Format22c: {
                if (instructions.length != 2) {
                    return null;
                }
                Instruction22c instruction = (Instruction22c)instructions[0];
                FieldIdItem referencedFieldIdItem = (FieldIdItem)instruction.getReferencedItem();
                accessedMember = instruction.opcode.setsRegister() || instruction.opcode.setsWideRegister() ? new AccessedMember(1, referencedFieldIdItem) : new AccessedMember(2, referencedFieldIdItem);
                this.resolvedAccessors.put(methodIdItem, accessedMember);
                return accessedMember;
            }
        }
        return null;
    }

    public static class AccessedMember {
        private final int accessedMemberType;
        private final Item accessedMember;

        public AccessedMember(int accessedMemberType, Item accessedMember) {
            this.accessedMemberType = accessedMemberType;
            this.accessedMember = accessedMember;
        }

        public int getAccessedMemberType() {
            return this.accessedMemberType;
        }

        public Item getAccessedMember() {
            return this.accessedMember;
        }
    }
}

