/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.ReferenceType;
import org.jf.dexlib.Code.VerificationErrorType;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction20bc
extends InstructionWithReference {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private VerificationErrorType validationErrorType;

    public Instruction20bc(Opcode opcode, VerificationErrorType validationErrorType, Item referencedItem) {
        super(opcode, referencedItem, Instruction20bc.getReferenceType(referencedItem));
        this.validationErrorType = validationErrorType;
    }

    private static ReferenceType getReferenceType(Item item) {
        if (item instanceof TypeIdItem) {
            return ReferenceType.type;
        }
        if (item instanceof FieldIdItem) {
            return ReferenceType.field;
        }
        if (item instanceof MethodIdItem) {
            return ReferenceType.method;
        }
        return null;
    }

    private Instruction20bc(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        short val = NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
        this.validationErrorType = VerificationErrorType.getValidationErrorType(val & 0x3F);
    }

    protected ReferenceType readReferenceType(Opcode opcode, byte[] buffer, int bufferIndex) {
        short val = NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
        short referenceType = (short)(val >> 6);
        return ReferenceType.fromValidationErrorReferenceType(referenceType);
    }

    public Format getFormat() {
        return Format.Format20bc;
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.opcode == Opcode.CONST_STRING && this.getReferencedItem().getIndex() > 65535) {
            throw new RuntimeException("String offset is too large for const-string. Use string-const/jumbo instead.");
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.getReferenceType().getValidationErrorReferenceType() << 6 & this.validationErrorType.getValue());
        out.writeShort(this.getReferencedItem().getIndex());
    }

    public VerificationErrorType getValidationErrorType() {
        return this.validationErrorType;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction20bc(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

