/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22t
extends Instruction
implements OffsetInstruction,
TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private short targetAddressOffset;

    public Instruction22t(Opcode opcode, byte regA, byte regB, short offC) {
        super(opcode);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (offC == 0) {
            throw new RuntimeException("The address offset cannot be 0.");
        }
        this.regA = regA;
        this.regB = regB;
        this.targetAddressOffset = offC;
    }

    private Instruction22t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        assert (buffer[bufferIndex] == opcode.value);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.targetAddressOffset = NumberUtils.decodeShort(buffer, bufferIndex + 2);
        assert (this.targetAddressOffset != 0);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
        out.writeShort(this.targetAddressOffset);
    }

    public void updateTargetAddressOffset(int targetAddressOffset) {
        if (targetAddressOffset < Short.MIN_VALUE || targetAddressOffset > Short.MAX_VALUE) {
            throw new RuntimeException("The address offset " + targetAddressOffset + " is out of range. It must be in [-32768, 32767]");
        }
        if (targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0");
        }
        this.targetAddressOffset = (short)targetAddressOffset;
    }

    public Format getFormat() {
        return Format.Format22t;
    }

    public int getRegisterA() {
        return this.regA;
    }

    public int getRegisterB() {
        return this.regB;
    }

    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22t(opcode, buffer, bufferIndex);
        }
    }
}

