/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Utf8Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderItem
extends Item<HeaderItem> {
    public static final byte[][] MAGIC_VALUES = new byte[][]{{100, 101, 120, 10, 48, 51, 53, 0}, {100, 101, 120, 10, 48, 51, 54, 0}};
    private static final int HEADER_SIZE = 112;
    private static final int LITTLE_ENDIAN = 305419896;
    private static final int BIG_ENDIAN = 2018910994;
    private int magic_index = 0;

    protected HeaderItem(DexFile dexFile) {
        super(dexFile);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        byte[] readMagic = in.readBytes(8);
        boolean success = false;
        for (int i = 0; i < MAGIC_VALUES.length; ++i) {
            byte[] magic_value = MAGIC_VALUES[i];
            boolean matched = true;
            for (int j = 0; j < 8; ++j) {
                if (magic_value[j] == readMagic[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            success = true;
            this.magic_index = i;
            break;
        }
        if (!success) {
            throw new RuntimeException("Unrecognized dex magic value");
        }
        in.readBytes(20);
        in.readInt();
        in.readInt();
        if (in.readInt() != 112) {
            throw new RuntimeException("The header size is not the expected value (0x70)");
        }
        int endianTag = in.readInt();
        if (endianTag == 2018910994) {
            throw new RuntimeException("This dex file is big endian. Only little endian is currently supported.");
        }
        if (endianTag != 305419896) {
            throw new RuntimeException("The endian tag is not 0x12345678 or 0x78563412");
        }
        if ((in.readInt() | in.readInt()) != 0) {
            System.err.println("This dex file has a link section, which is not supported. Ignoring.");
        }
        int sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_MAP_LIST, 1, sectionOffset);
        int sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_STRING_ID_ITEM, sectionSize, sectionOffset);
        sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_TYPE_ID_ITEM, sectionSize, sectionOffset);
        sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_PROTO_ID_ITEM, sectionSize, sectionOffset);
        sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_FIELD_ID_ITEM, sectionSize, sectionOffset);
        sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_METHOD_ID_ITEM, sectionSize, sectionOffset);
        sectionSize = in.readInt();
        sectionOffset = in.readInt();
        readContext.addSection(ItemType.TYPE_CLASS_DEF_ITEM, sectionSize, sectionOffset);
        in.readInt();
        in.readInt();
    }

    public void setVersion(int version2) {
        if (version2 == 35) {
            this.magic_index = 0;
            return;
        }
        if (version2 == 36) {
            this.magic_index = 1;
            return;
        }
        throw new RuntimeException("Invalid dex version number passed to setVersion");
    }

    @Override
    protected int placeItem(int offset) {
        return 112;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        StringBuilder magicBuilder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            magicBuilder.append((char)MAGIC_VALUES[this.magic_index][i]);
        }
        out.annotate("magic: " + Utf8Utils.escapeString(magicBuilder.toString()));
        out.write(MAGIC_VALUES[this.magic_index]);
        out.annotate("checksum");
        out.writeInt(0);
        out.annotate("signature");
        out.write(new byte[20]);
        out.annotate("file_size: 0x" + Integer.toHexString(this.dexFile.getFileSize()) + " (" + this.dexFile.getFileSize() + " bytes)");
        out.writeInt(this.dexFile.getFileSize());
        out.annotate("header_size: 0x" + Integer.toHexString(112));
        out.writeInt(112);
        out.annotate("endian_tag: 0x" + Integer.toHexString(305419896));
        out.writeInt(305419896);
        out.annotate("link_size: 0");
        out.writeInt(0);
        out.annotate("link_off: 0");
        out.writeInt(0);
        out.annotate("map_off: 0x" + Integer.toHexString(this.dexFile.MapItem.getOffset()));
        out.writeInt(this.dexFile.MapItem.getOffset());
        out.annotate("string_ids_size: " + this.dexFile.StringIdsSection.getItems().size());
        out.writeInt(this.dexFile.StringIdsSection.getItems().size());
        out.annotate("string_ids_off: 0x" + Integer.toHexString(this.dexFile.StringIdsSection.getOffset()));
        out.writeInt(this.dexFile.StringIdsSection.getOffset());
        out.annotate("type_ids_size: " + this.dexFile.TypeIdsSection.getItems().size());
        out.writeInt(this.dexFile.TypeIdsSection.getItems().size());
        out.annotate("type_ids_off: 0x" + Integer.toHexString(this.dexFile.TypeIdsSection.getOffset()));
        out.writeInt(this.dexFile.TypeIdsSection.getOffset());
        out.annotate("proto_ids_size: " + this.dexFile.ProtoIdsSection.getItems().size());
        out.writeInt(this.dexFile.ProtoIdsSection.getItems().size());
        out.annotate("proto_ids_off: 0x" + Integer.toHexString(this.dexFile.ProtoIdsSection.getOffset()));
        out.writeInt(this.dexFile.ProtoIdsSection.getOffset());
        out.annotate("field_ids_size: " + this.dexFile.FieldIdsSection.getItems().size());
        out.writeInt(this.dexFile.FieldIdsSection.getItems().size());
        out.annotate("field_ids_off: 0x" + Integer.toHexString(this.dexFile.FieldIdsSection.getOffset()));
        out.writeInt(this.dexFile.FieldIdsSection.getOffset());
        out.annotate("method_ids_size: " + this.dexFile.MethodIdsSection.getItems().size());
        out.writeInt(this.dexFile.MethodIdsSection.getItems().size());
        out.annotate("method_ids_off: 0x" + Integer.toHexString(this.dexFile.MethodIdsSection.getOffset()));
        out.writeInt(this.dexFile.MethodIdsSection.getOffset());
        out.annotate("class_defs_size: " + this.dexFile.ClassDefsSection.getItems().size());
        out.writeInt(this.dexFile.ClassDefsSection.getItems().size());
        out.annotate("class_defs_off: 0x" + Integer.toHexString(this.dexFile.ClassDefsSection.getOffset()));
        out.writeInt(this.dexFile.ClassDefsSection.getOffset());
        out.annotate("data_size: 0x" + Integer.toHexString(this.dexFile.getDataSize()) + " (" + this.dexFile.getDataSize() + " bytes)");
        out.writeInt(this.dexFile.getDataSize());
        out.annotate("data_off: 0x" + Integer.toHexString(this.dexFile.getDataOffset()));
        out.writeInt(this.dexFile.getDataOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_HEADER_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "header_item";
    }

    @Override
    public int compareTo(HeaderItem o) {
        return 0;
    }
}

