/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClass {
    private final Class<?> fClass;
    private Map<Class<?>, List<FrameworkMethod>> fMethodsForAnnotations = new HashMap();

    public TestClass(Class<?> klass) {
        this.fClass = klass;
        if (klass != null && klass.getConstructors().length > 1) {
            throw new IllegalArgumentException("Test class can only have one constructor");
        }
        for (Class<?> eachClass : this.getSuperClasses(this.fClass)) {
            for (Method eachMethod : eachClass.getDeclaredMethods()) {
                this.addToAnnotationLists(new FrameworkMethod(eachMethod));
            }
        }
    }

    private void addToAnnotationLists(FrameworkMethod testMethod) {
        for (Annotation each : this.computeAnnotations(testMethod)) {
            this.addToAnnotationList(each.annotationType(), testMethod);
        }
    }

    protected Annotation[] computeAnnotations(FrameworkMethod testMethod) {
        return testMethod.getAnnotations();
    }

    private void addToAnnotationList(Class<? extends Annotation> annotation2, FrameworkMethod testMethod) {
        List<FrameworkMethod> methods = this.getAnnotatedMethods(annotation2);
        if (testMethod.isShadowedBy(methods)) {
            return;
        }
        if (this.runsTopToBottom(annotation2)) {
            methods.add(0, testMethod);
        } else {
            methods.add(testMethod);
        }
    }

    private void ensureKey(Class<? extends Annotation> annotation2) {
        if (!this.fMethodsForAnnotations.containsKey(annotation2)) {
            this.fMethodsForAnnotations.put(annotation2, new ArrayList());
        }
    }

    public List<FrameworkMethod> getAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        this.ensureKey(annotationClass);
        return this.fMethodsForAnnotations.get(annotationClass);
    }

    private boolean runsTopToBottom(Class<? extends Annotation> annotation2) {
        return annotation2.equals(Before.class) || annotation2.equals(BeforeClass.class);
    }

    private List<Class<?>> getSuperClasses(Class<?> testClass) {
        ArrayList results = new ArrayList();
        for (Class<?> current = testClass; current != null; current = current.getSuperclass()) {
            results.add(current);
        }
        return results;
    }

    public Class<?> getJavaClass() {
        return this.fClass;
    }

    public String getName() {
        if (this.fClass == null) {
            return "null";
        }
        return this.fClass.getName();
    }

    public Constructor<?> getOnlyConstructor() {
        Constructor<?>[] constructors = this.fClass.getConstructors();
        Assert.assertEquals(1L, constructors.length);
        return constructors[0];
    }

    public Annotation[] getAnnotations() {
        if (this.fClass == null) {
            return new Annotation[0];
        }
        return this.fClass.getAnnotations();
    }
}

