/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.PrimType;
import soot.Printer;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.InitAnalysis;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.Chain;
import soot.util.EscapedWriter;
import soot.util.HashChain;

public abstract class Body
extends AbstractHost
implements Serializable {
    protected transient SootMethod method = null;
    protected Chain<Local> localChain = new HashChain<Local>();
    protected Chain<Trap> trapChain = new HashChain<Trap>();
    protected PatchingChain<Unit> unitChain = new PatchingChain(new HashChain());

    public abstract Object clone();

    protected Body(SootMethod m) {
        this.method = m;
    }

    protected Body() {
    }

    public SootMethod getMethod() {
        if (this.method == null) {
            throw new RuntimeException("no method associated w/ body");
        }
        return this.method;
    }

    public void setMethod(SootMethod method) {
        this.method = method;
    }

    public int getLocalCount() {
        return this.localChain.size();
    }

    public Map<Object, Object> importBodyContentsFrom(Body b) {
        Object copy;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        for (Unit unit : b.getUnits()) {
            copy = (Unit)unit.clone();
            copy.addAllTagsOf(unit);
            this.unitChain.addLast((Unit)copy);
            bindings.put(unit, copy);
        }
        for (Trap trap : b.getTraps()) {
            copy = (Trap)trap.clone();
            this.trapChain.addLast((Trap)copy);
            bindings.put(trap, copy);
        }
        for (Local local : b.getLocals()) {
            copy = (Local)local.clone();
            this.localChain.addLast((Local)copy);
            bindings.put(local, copy);
        }
        for (UnitBox unitBox : this.getAllUnitBoxes()) {
            Unit oldObject = unitBox.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            unitBox.setUnit(newObject);
        }
        for (ValueBox valueBox : this.getUseBoxes()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            valueBox.setValue((Value)bindings.get(valueBox.getValue()));
        }
        for (ValueBox valueBox : this.getDefBoxes()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            valueBox.setValue((Value)bindings.get(valueBox.getValue()));
        }
        return bindings;
    }

    public void validate() {
        this.validateLocals();
        this.validateTraps();
        this.validateUnitBoxes();
        if (Options.v().debug() || Options.v().validate()) {
            this.validateUses();
            this.validateValueBoxes();
            this.checkInit();
            this.checkTypes();
            this.checkLocals();
        }
    }

    public void validateValueBoxes() {
        List<ValueBox> l = this.getUseAndDefBoxes();
        for (int i = 0; i < l.size(); ++i) {
            for (int j = 0; j < l.size(); ++j) {
                if (i == j || l.get(i) != l.get(j)) continue;
                System.err.println("Aliased value box : " + l.get(i) + " in " + this.getMethod());
                for (Unit u : this.getUnits()) {
                    System.err.println("" + u);
                }
                throw new RuntimeException("Aliased value box : " + l.get(i) + " in " + this.getMethod());
            }
        }
    }

    public void validateLocals() {
        Iterator<ValueBox> it = this.getUseBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal(it.next());
        }
        it = this.getDefBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal(it.next());
        }
    }

    private void validateLocal(ValueBox vb) {
        Value value = vb.getValue();
        if (value instanceof Local && !this.localChain.contains(value)) {
            throw new RuntimeException("Local not in chain : " + value + " in " + this.getMethod());
        }
    }

    public void validateTraps() {
        for (Trap t : this.getTraps()) {
            if (!this.unitChain.contains(t.getBeginUnit())) {
                throw new RuntimeException("begin not in chain in " + this.getMethod());
            }
            if (!this.unitChain.contains(t.getEndUnit())) {
                throw new RuntimeException("end not in chain in " + this.getMethod());
            }
            if (this.unitChain.contains(t.getHandlerUnit())) continue;
            throw new RuntimeException("handler not in chain in " + this.getMethod());
        }
    }

    public void validateUnitBoxes() {
        for (UnitBox ub : this.getAllUnitBoxes()) {
            if (this.unitChain.contains(ub.getUnit())) continue;
            throw new RuntimeException("Unitbox points outside unitChain! to unit : " + ub.getUnit() + " in " + this.getMethod());
        }
    }

    public void validateUses() {
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(this);
        SmartLocalDefs ld = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        for (Unit u : this.getUnits()) {
            Iterator<ValueBox> useBoxIt = u.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                List<Unit> l;
                Value v = useBoxIt.next().getValue();
                if (!(v instanceof Local) || (l = ld.getDefsOfAt((Local)v, u)).size() != 0 || !this.findMissingDef(u, (Local)v, g)) continue;
                for (Unit uu : this.getUnits()) {
                    System.err.println("" + uu);
                }
                throw new RuntimeException("no defs for value: " + v + "!" + " in " + this.getMethod());
            }
        }
    }

    public Chain<Local> getLocals() {
        return this.localChain;
    }

    public Chain<Trap> getTraps() {
        return this.trapChain;
    }

    public Local getThisLocal() {
        for (Unit s : this.getUnits()) {
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ThisRef)) continue;
            return (Local)((IdentityStmt)s).getLeftOp();
        }
        throw new RuntimeException("couldn't find identityref! in " + this.getMethod());
    }

    public Local getParameterLocal(int i) {
        for (Unit s : this.getUnits()) {
            IdentityStmt is;
            ParameterRef pr;
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ParameterRef) || (pr = (ParameterRef)(is = (IdentityStmt)s).getRightOp()).getIndex() != i) continue;
            return (Local)is.getLeftOp();
        }
        throw new RuntimeException("couldn't find parameterref! in " + this.getMethod());
    }

    public PatchingChain<Unit> getUnits() {
        return this.unitChain;
    }

    public List<UnitBox> getAllUnitBoxes() {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<UnitBox> getUnitBoxes(boolean branchTarget) {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            if (branchTarget) {
                if (!unit.branches()) continue;
                unitBoxList.addAll(unit.getUnitBoxes());
                continue;
            }
            if (unit.branches()) continue;
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> useBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useBoxList.addAll(item.getUseBoxes());
        }
        return useBoxList;
    }

    public List<ValueBox> getDefBoxes() {
        ArrayList<ValueBox> defBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            defBoxList.addAll(item.getDefBoxes());
        }
        return defBoxList;
    }

    public List<ValueBox> getUseAndDefBoxes() {
        ArrayList<ValueBox> useAndDefBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useAndDefBoxList.addAll(item.getUseBoxes());
            useAndDefBoxList.addAll(item.getDefBoxes());
        }
        return useAndDefBoxList;
    }

    private void checkLocals() {
        Chain<Local> locals = this.getLocals();
        for (Local l : locals) {
            if (!(l.getType() instanceof VoidType)) continue;
            throw new RuntimeException("Local " + l + " in " + this.method + " defined with void type");
        }
    }

    private void checkTypes() {
        PatchingChain<Unit> units = this.getUnits();
        for (Unit stmt : units) {
            DefinitionStmt astmt;
            InvokeExpr iexpr = null;
            String errorSuffix = " at " + stmt + " in " + this.getMethod();
            if (stmt instanceof DefinitionStmt && !((astmt = (DefinitionStmt)stmt).getRightOp() instanceof CaughtExceptionRef)) {
                Type leftType = Type.toMachineType(astmt.getLeftOp().getType());
                Type rightType = Type.toMachineType(astmt.getRightOp().getType());
                this.checkCopy(leftType, rightType, errorSuffix);
                if (astmt.getRightOp() instanceof InvokeExpr) {
                    iexpr = (InvokeExpr)astmt.getRightOp();
                }
            }
            if (stmt instanceof InvokeStmt) {
                iexpr = ((InvokeStmt)stmt).getInvokeExpr();
            }
            if (iexpr == null) continue;
            SootMethodRef called = iexpr.getMethodRef();
            if (iexpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
                this.checkCopy(called.declaringClass().getType(), iiexpr.getBase().getType(), " in receiver of call" + errorSuffix);
            }
            if (called.parameterTypes().size() != iexpr.getArgCount()) {
                throw new RuntimeException("Warning: Argument count doesn't match up with signature in call" + errorSuffix + " in " + this.getMethod());
            }
            for (int i = 0; i < iexpr.getArgCount(); ++i) {
                this.checkCopy(Type.toMachineType(called.parameterType(i)), Type.toMachineType(iexpr.getArg(i).getType()), " in argument " + i + " of call" + errorSuffix);
            }
        }
    }

    private void checkCopy(Type leftType, Type rightType, String errorSuffix) {
        if (leftType instanceof PrimType || rightType instanceof PrimType) {
            if (leftType instanceof IntType && rightType instanceof IntType) {
                return;
            }
            if (leftType instanceof LongType && rightType instanceof LongType) {
                return;
            }
            if (leftType instanceof FloatType && rightType instanceof FloatType) {
                return;
            }
            if (leftType instanceof DoubleType && rightType instanceof DoubleType) {
                return;
            }
            throw new RuntimeException("Warning: Bad use of primitive type" + errorSuffix + " in " + this.getMethod());
        }
        if (rightType instanceof NullType) {
            return;
        }
        if (leftType instanceof RefType && ((RefType)leftType).getClassName().equals("java.lang.Object")) {
            return;
        }
        if (leftType instanceof ArrayType || rightType instanceof ArrayType) {
            if (leftType instanceof ArrayType && rightType instanceof ArrayType) {
                return;
            }
            if (rightType instanceof ArrayType && (leftType.equals(RefType.v("java.io.Serializable")) || leftType.equals(RefType.v("java.lang.Cloneable")) || leftType.equals(RefType.v("java.lang.Object")))) {
                return;
            }
            throw new RuntimeException("Warning: Bad use of array type" + errorSuffix + " in " + this.getMethod());
        }
        if (leftType instanceof RefType && rightType instanceof RefType) {
            SootClass leftClass = ((RefType)leftType).getSootClass();
            SootClass rightClass = ((RefType)rightType).getSootClass();
            if (leftClass.isPhantom() || rightClass.isPhantom()) {
                return;
            }
            if (leftClass.isInterface()) {
                if (rightClass.isInterface() && !leftClass.getName().equals(rightClass.getName()) && !Scene.v().getActiveHierarchy().isInterfaceSubinterfaceOf(rightClass, leftClass)) {
                    throw new RuntimeException("Warning: Bad use of interface type" + errorSuffix + " in " + this.getMethod());
                }
            } else {
                if (rightClass.isInterface()) {
                    throw new RuntimeException("Warning: trying to use interface type where non-Object class expected" + errorSuffix + " in " + this.getMethod());
                }
                if (!Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(rightClass, leftClass)) {
                    throw new RuntimeException("Warning: Bad use of class type" + errorSuffix + " in " + this.getMethod() + " : " + rightClass + " - " + leftClass);
                }
            }
            return;
        }
    }

    public void checkInit() {
        PatchingChain<Unit> units = this.getUnits();
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(this, PedanticThrowAnalysis.v(), false);
        InitAnalysis analysis = new InitAnalysis(g);
        for (Unit s : units) {
            FlowSet init = (FlowSet)analysis.getFlowBefore(s);
            List<ValueBox> uses = s.getUseBoxes();
            Iterator<ValueBox> usesIt = uses.iterator();
            while (usesIt.hasNext()) {
                Local l;
                Value v = usesIt.next().getValue();
                if (!(v instanceof Local) || init.contains(l = (Local)v) || !this.findMissingDef(s, l, g)) continue;
                throw new RuntimeException("Warning: Local variable " + l + " not definitely defined at " + s + " in " + this.method);
            }
        }
    }

    private boolean findMissingDef(Unit start, Local local, UnitGraph graph) {
        HashSet<Unit> visitedUnits = new HashSet<Unit>();
        Stack<Pair<Unit, List<Unit>>> stack = new Stack<Pair<Unit, List<Unit>>>();
        stack.push(new Pair<Unit, List<Unit>>(start, Collections.singletonList(start)));
        boolean found = false;
        while (!stack.empty()) {
            Pair current = (Pair)stack.pop();
            Unit currentUnit = (Unit)current.getO1();
            if (visitedUnits.contains(currentUnit)) continue;
            visitedUnits.add(currentUnit);
            List currentPath = (List)current.getO2();
            if (currentUnit instanceof DefinitionStmt) {
                Local leftLocal;
                DefinitionStmt definitionStmt = (DefinitionStmt)currentUnit;
                if (!(definitionStmt.getLeftOp() instanceof Local) || (leftLocal = (Local)definitionStmt.getLeftOp()).equivTo(local) || !leftLocal.getName().equals(local.getName()) || !definitionStmt.getRightOp().getType().equals(NullType.v())) continue;
                continue;
            }
            List<Unit> predecessors = graph.getPredsOf(currentUnit);
            if (predecessors == null || predecessors.isEmpty()) {
                found = true;
                continue;
            }
            for (Unit predecessor : predecessors) {
                ArrayList<Unit> newPath = new ArrayList<Unit>(currentPath);
                newPath.add(predecessor);
                stack.add(new Pair(predecessor, newPath));
            }
        }
        return found;
    }

    public String toString() {
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        PrintWriter writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
        try {
            Printer.v().printTo(this, writerOut);
        }
        catch (RuntimeException e) {
            e.printStackTrace(writerOut);
        }
        writerOut.flush();
        writerOut.close();
        return streamOut.toString();
    }
}

