/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.DexFile;
import soot.ClassProvider;
import soot.ClassSource;
import soot.DexClassSource;
import soot.G;
import soot.SourceLocator;
import soot.dexpler.Util;

public class DexClassProvider
implements ClassProvider {
    @Override
    public ClassSource find(String className) {
        File file;
        Map<String, File> index = SourceLocator.v().dexClassIndex();
        if (index == null) {
            index = new HashMap<String, File>();
            this.buildDexIndex(index, SourceLocator.v().classPath());
            SourceLocator.v().setDexClassIndex(index);
        }
        if ((file = index.get(className)) == null) {
            return null;
        }
        return new DexClassSource(className, file);
    }

    private void buildDexIndex(Map<String, File> index, List<String> classPath) {
        for (String path : classPath) {
            File dir = new File(path);
            File[] dexs = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".dex");
                }
            });
            if (dexs != null) {
                for (File dex : dexs) {
                    this.readDexFile(index, dex);
                }
            }
            if (!path.endsWith(".dex") && !path.endsWith(".apk")) continue;
            this.readDexFile(index, dir);
        }
    }

    private void readDexFile(Map<String, File> index, File dex) {
        try {
            for (String className : DexClassProvider.classesOfDex(dex)) {
                index.put(className, dex);
            }
        }
        catch (IOException e) {
            G.v().out.println("Warning: IO error while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
        catch (Exception e) {
            G.v().out.println("Warning: exception while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
    }

    public static Set<String> classesOfDex(File file) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        DexFile d = new DexFile(file, true, false);
        for (ClassDefItem c : d.ClassDefsSection.getItems()) {
            String name = c.getClassType().getTypeDescriptor();
            name = Util.dottedClassName(name);
            classes.add(name);
        }
        return classes;
    }
}

