/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.List;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.util.NumberedString;

public class EntryPoints {
    final NumberedString sigMain = Scene.v().getSubSigNumberer().findOrAdd("void main(java.lang.String[])");
    final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    final NumberedString sigExit = Scene.v().getSubSigNumberer().findOrAdd("void exit()");
    final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");

    public EntryPoints(Singletons.Global g) {
    }

    public static EntryPoints v() {
        return G.v().soot_EntryPoints();
    }

    private final void addMethod(List<SootMethod> set, SootClass cls, NumberedString methodSubSig) {
        if (cls.declaresMethod(methodSubSig)) {
            set.add(cls.getMethod(methodSubSig));
        }
    }

    private final void addMethod(List<SootMethod> set, String methodSig) {
        if (Scene.v().containsMethod(methodSig)) {
            set.add(Scene.v().getMethod(methodSig));
        }
    }

    public List<SootMethod> application() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        if (Scene.v().hasMainClass()) {
            this.addMethod(ret, Scene.v().getMainClass(), this.sigMain);
            for (SootMethod clinit : this.clinitsOf(Scene.v().getMainClass())) {
                ret.add(clinit);
            }
        }
        return ret;
    }

    public List<SootMethod> implicit() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        this.addMethod(ret, "<java.lang.System: void initializeSystemClass()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void <init>()>");
        this.addMethod(ret, "<java.lang.Thread: void exit()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void uncaughtException(java.lang.Thread,java.lang.Throwable)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void <init>()>");
        this.addMethod(ret, "<java.lang.ClassLoader: java.lang.Class loadClassInternal(java.lang.String)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void checkPackageAccess(java.lang.Class,java.security.ProtectionDomain)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void addClass(java.lang.Class)>");
        this.addMethod(ret, "<java.lang.ClassLoader: long findNative(java.lang.ClassLoader,java.lang.String)>");
        this.addMethod(ret, "<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>");
        this.addMethod(ret, "<java.lang.ref.Finalizer: void runFinalizer()>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.Runnable)>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>");
        return ret;
    }

    public List<SootMethod> all() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        ret.addAll(this.application());
        ret.addAll(this.implicit());
        return ret;
    }

    public List<SootMethod> clinits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigClinit);
        }
        return ret;
    }

    public List<SootMethod> inits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigInit);
        }
        return ret;
    }

    public List<SootMethod> allInits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            for (SootMethod m : cl.getMethods()) {
                if (!m.getName().equals("<init>")) continue;
                ret.add(m);
            }
        }
        return ret;
    }

    public List<SootMethod> methodsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            for (SootMethod m : cl.getMethods()) {
                if (!m.isConcrete()) continue;
                ret.add(m);
            }
        }
        return ret;
    }

    public List<SootMethod> mainsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            SootMethod m;
            if (!cl.declaresMethod("void main(java.lang.String[])") || !(m = cl.getMethod("void main(java.lang.String[])")).isConcrete()) continue;
            ret.add(m);
        }
        return ret;
    }

    public List<SootMethod> clinitsOf(SootClass cl) {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        while (true) {
            this.addMethod(ret, cl, this.sigClinit);
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        return ret;
    }
}

