/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import soot.ArrayType;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ArraySet;
import soot.util.Chain;

public class Hierarchy {
    HashMap<SootClass, List<SootClass>> classToSubclasses;
    HashMap<SootClass, List<SootClass>> interfaceToSubinterfaces;
    HashMap<SootClass, List> classToDirSubclasses;
    HashMap<SootClass, List> interfaceToDirSubinterfaces;
    HashMap<SootClass, List> interfaceToDirImplementers;
    int state;
    Scene sc = Scene.v();

    public Hierarchy() {
        this.state = this.sc.getState();
        Chain<SootClass> allClasses = this.sc.getClasses();
        this.classToSubclasses = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToSubinterfaces = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.classToDirSubclasses = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirSubinterfaces = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirImplementers = new HashMap(allClasses.size() * 2 + 1, 0.7f);
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1) continue;
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, new ArrayList());
                this.interfaceToDirImplementers.put(c, new ArrayList());
                continue;
            }
            this.classToDirSubclasses.put(c, new ArrayList());
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1 || !c.hasSuperclass()) continue;
            if (c.isInterface()) {
                for (SootClass i : c.getInterfaces()) {
                    List l;
                    if (c.resolvingLevel() < 1 || (l = this.interfaceToDirSubinterfaces.get(i)) == null) continue;
                    l.add(c);
                }
                continue;
            }
            List l = this.classToDirSubclasses.get(c.getSuperclass());
            l.add(c);
            for (SootClass i : c.getInterfaces()) {
                if (c.resolvingLevel() < 1 || (l = this.interfaceToDirImplementers.get(i)) == null) continue;
                l.add(c);
            }
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1 || !c.isInterface()) continue;
            List imp = this.interfaceToDirImplementers.get(c);
            ArraySet<SootClass> s = new ArraySet<SootClass>();
            for (SootClass c0 : imp) {
                if (c.resolvingLevel() < 1) continue;
                s.addAll(this.getSubclassesOfIncluding(c0));
            }
            imp.clear();
            imp.addAll(s);
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1) continue;
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, Collections.unmodifiableList(this.interfaceToDirSubinterfaces.get(c)));
                this.interfaceToDirImplementers.put(c, Collections.unmodifiableList(this.interfaceToDirImplementers.get(c)));
                continue;
            }
            this.classToDirSubclasses.put(c, Collections.unmodifiableList(this.classToDirSubclasses.get(c)));
        }
    }

    private void checkState() {
        if (this.state != this.sc.getState()) {
            throw new ConcurrentModificationException("Scene changed for Hierarchy!");
        }
    }

    public List<SootClass> getSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubclassesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        if (this.classToSubclasses.get(c) != null) {
            return this.classToSubclasses.get(c);
        }
        ArrayList<SootClass> l = new ArrayList();
        ListIterator it = this.classToDirSubclasses.get(c).listIterator();
        while (it.hasNext()) {
            SootClass cls = (SootClass)it.next();
            if (cls.resolvingLevel() < 1) continue;
            l.addAll(this.getSubclassesOfIncluding(cls));
        }
        l = Collections.unmodifiableList(l);
        this.classToSubclasses.put(c, l);
        return l;
    }

    public List<SootClass> getSuperclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        List<SootClass> l = this.getSuperclassesOf(c);
        ArrayList<SootClass> al = new ArrayList<SootClass>();
        al.add(c);
        al.addAll(l);
        return Collections.unmodifiableList(al);
    }

    public List<SootClass> getSuperclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        SootClass cl = c;
        while (cl.hasSuperclass()) {
            l.add(cl.getSuperclass());
            cl = cl.getSuperclass();
        }
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubinterfacesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        if (this.interfaceToSubinterfaces.get(c) != null) {
            return this.interfaceToSubinterfaces.get(c);
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        ListIterator it = this.interfaceToDirSubinterfaces.get(c).listIterator();
        while (it.hasNext()) {
            l.addAll(this.getSubinterfacesOfIncluding((SootClass)it.next()));
        }
        this.interfaceToSubinterfaces.put(c, Collections.unmodifiableList(l));
        return Collections.unmodifiableList(l);
    }

    public List getSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSuperclassesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        return Collections.unmodifiableList(this.classToDirSubclasses.get(c));
    }

    public List<SootClass> getDirectSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.classToDirSubclasses.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getDirectSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getDirectSubinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        return this.interfaceToDirSubinterfaces.get(c);
    }

    public List<SootClass> getDirectSubinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.interfaceToDirSubinterfaces.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List getDirectImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        return Collections.unmodifiableList(this.interfaceToDirImplementers.get(i));
    }

    public List<SootClass> getImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        Iterator<SootClass> it = this.getSubinterfacesOfIncluding(i).iterator();
        ArraySet set = new ArraySet();
        while (it.hasNext()) {
            SootClass c = it.next();
            set.addAll(this.getDirectImplementersOf(c));
        }
        ArrayList l = new ArrayList();
        l.addAll(set);
        return Collections.unmodifiableList(l);
    }

    public boolean isClassSubclassOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getSuperclassesOf(child).contains(possibleParent);
    }

    public boolean isClassSubclassOfIncluding(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getSuperclassesOfIncluding(child).contains(possibleParent);
    }

    public boolean isClassDirectSubclassOf(SootClass c, SootClass c2) {
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isClassSuperclassOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOf(parent).contains(possibleChild);
    }

    public boolean isClassSuperclassOfIncluding(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOfIncluding(parent).contains(possibleChild);
    }

    public boolean isInterfaceSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceDirectSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getDirectSubinterfacesOf(possibleParent).contains(child);
    }

    public SootClass getLeastCommonSuperclassOf(SootClass c1, SootClass c2) {
        c1.checkLevel(1);
        c2.checkLevel(1);
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isVisible(SootClass from, SootMethod m) {
        from.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.isClassSubclassOfIncluding(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        concreteType.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        if (concreteType.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        Iterator<SootClass> it = this.getSuperclassesOfIncluding(concreteType).iterator();
        String methodSig = m.getSubSignature();
        while (it.hasNext()) {
            SootClass c = it.next();
            if (!c.declaresMethod(methodSig) || !this.isVisible(c, m)) continue;
            return c.getMethod(methodSig);
        }
        throw new RuntimeException("could not resolve concrete dispatch!\nType: " + concreteType + "\nMethod: " + m);
    }

    public List resolveConcreteDispatch(List classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (Object cls : classes) {
            if (cls instanceof RefType) {
                s.add(this.resolveConcreteDispatch(((RefType)cls).getSootClass(), m));
                continue;
            }
            if (cls instanceof ArrayType) {
                s.add(this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m));
                continue;
            }
            throw new RuntimeException("Unable to resolve concrete dispatch of type " + cls);
        }
        ArrayList<SootMethod> l = new ArrayList<SootMethod>();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public List resolveAbstractDispatch(SootClass c, SootMethod m) {
        c.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        Iterator<SootClass> classesIt = null;
        if (c.isInterface()) {
            classesIt = this.getImplementersOf(c).iterator();
            HashSet<SootClass> classes = new HashSet<SootClass>();
            while (classesIt.hasNext()) {
                classes.addAll(this.getSubclassesOfIncluding(classesIt.next()));
            }
            classesIt = classes.iterator();
        } else {
            classesIt = this.getSubclassesOfIncluding(c).iterator();
        }
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        while (classesIt.hasNext()) {
            SootClass cl = classesIt.next();
            if (Modifier.isAbstract(cl.getModifiers())) continue;
            s.add(this.resolveConcreteDispatch(cl, m));
        }
        ArrayList<SootMethod> l = new ArrayList<SootMethod>();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public List resolveAbstractDispatch(List classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        ArraySet s = new ArraySet();
        Iterator classesIt = classes.iterator();
        while (classesIt.hasNext()) {
            s.addAll(this.resolveAbstractDispatch((SootClass)classesIt.next(), m));
        }
        ArrayList l = new ArrayList();
        l.addAll(s);
        return Collections.unmodifiableList(l);
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        container2.getDeclaringClass().checkLevel(1);
        SootMethod target = ie.getMethod();
        target.getDeclaringClass().checkLevel(1);
        if (target.getName().equals("<init>") || target.isPrivate()) {
            return target;
        }
        if (this.isClassSubclassOf(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }
}

