/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.ClassInstanceExpr;
import soot.JastAddJ.Constraints;
import soot.JastAddJ.GenericClassDecl;
import soot.JastAddJ.GenericMethodDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.ParClassDecl;
import soot.JastAddJ.PlaceholderMethodDecl;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;
import soot.JastAddJ.VariableArityParameterDeclaration;

public class DiamondAccess
extends Access
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected Map typeArguments_MethodDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.typeArguments_MethodDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public DiamondAccess clone() throws CloneNotSupportedException {
        DiamondAccess node = (DiamondAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.typeArguments_MethodDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DiamondAccess copy() {
        try {
            DiamondAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public DiamondAccess fullCopy() {
        try {
            DiamondAccess tree = this.clone();
            tree.setParent(null);
            if (this.children != null) {
                tree.children = new ASTNode[this.children.length];
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) {
                        tree.children[i] = null;
                        continue;
                    }
                    tree.children[i] = this.children[i].fullCopy();
                    tree.children[i].setParent(tree);
                }
            }
            return tree;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    protected static SimpleSet mostSpecific(SimpleSet maxSpecific, MethodDecl decl) {
        if (maxSpecific.isEmpty()) {
            maxSpecific = maxSpecific.add(decl);
        } else if (decl.moreSpecificThan((MethodDecl)maxSpecific.iterator().next())) {
            maxSpecific = SimpleSet.emptySet.add(decl);
        } else if (!((MethodDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) {
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    protected SimpleSet chooseConstructor() {
        ClassInstanceExpr instanceExpr = this.getClassInstanceExpr();
        TypeDecl type = this.getTypeAccess().type();
        assert (instanceExpr != null);
        assert (type instanceof ParClassDecl);
        GenericClassDecl genericType = (GenericClassDecl)((ParClassDecl)type).genericDecl();
        List<PlaceholderMethodDecl> placeholderMethods = genericType.getPlaceholderMethodList();
        SimpleSet maxSpecific = SimpleSet.emptySet;
        Collection<MethodDecl> potentiallyApplicable = this.potentiallyApplicable(placeholderMethods);
        for (MethodDecl candidate : potentiallyApplicable) {
            if (!this.applicableBySubtyping(instanceExpr, candidate) && !this.applicableByMethodInvocationConversion(instanceExpr, candidate) && !this.applicableByVariableArity(instanceExpr, candidate)) continue;
            maxSpecific = DiamondAccess.mostSpecific(maxSpecific, candidate);
        }
        return maxSpecific;
    }

    protected Collection<MethodDecl> potentiallyApplicable(List<PlaceholderMethodDecl> candidates) {
        LinkedList<MethodDecl> potentiallyApplicable = new LinkedList<MethodDecl>();
        for (GenericMethodDecl genericMethodDecl : candidates) {
            if (!this.potentiallyApplicable(genericMethodDecl)) continue;
            MethodDecl decl = genericMethodDecl.lookupParMethodDecl(this.typeArguments(genericMethodDecl));
            potentiallyApplicable.add(decl);
        }
        return potentiallyApplicable;
    }

    protected boolean potentiallyApplicable(GenericMethodDecl candidate) {
        if (candidate.isVariableArity() && this.getClassInstanceExpr().arity() < candidate.arity() - 1) {
            return false;
        }
        if (!candidate.isVariableArity() && this.getClassInstanceExpr().arity() != candidate.arity()) {
            return false;
        }
        java.util.List<TypeDecl> typeArgs = this.typeArguments(candidate);
        if (typeArgs.size() != 0) {
            if (candidate.getNumTypeParameter() != typeArgs.size()) {
                return false;
            }
            for (int i = 0; i < candidate.getNumTypeParameter(); ++i) {
                if (typeArgs.get(i).subtype(candidate.original().getTypeParameter(i))) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<TypeDecl> computeConstraints(GenericMethodDecl decl) {
        Constraints c = new Constraints();
        for (int i = 0; i < decl.original().getNumTypeParameter(); ++i) {
            c.addTypeVariable(decl.original().getTypeParameter(i));
        }
        ClassInstanceExpr instanceExpr = this.getClassInstanceExpr();
        for (int i = 0; i < instanceExpr.getNumArg(); ++i) {
            TypeDecl A = instanceExpr.getArg(i).type();
            int index = i >= decl.getNumParameter() ? decl.getNumParameter() - 1 : i;
            TypeDecl F = decl.getParameter(index).type();
            if (decl.getParameter(index) instanceof VariableArityParameterDeclaration && (instanceExpr.getNumArg() != decl.getNumParameter() || !A.isArrayDecl())) {
                F = F.componentType();
            }
            c.convertibleTo(A, F);
        }
        if (c.rawAccess) {
            return new ArrayList<TypeDecl>();
        }
        c.resolveEqualityConstraints();
        c.resolveSupertypeConstraints();
        if (c.unresolvedTypeArguments()) {
            TypeDecl R;
            TypeDecl S = this.assignConvertedType();
            if (S.isUnboxedPrimitive()) {
                S = S.boxed();
            }
            if ((R = decl.type()).isVoid()) {
                R = this.typeObject();
            }
            c.convertibleFrom(S, R);
            c.resolveEqualityConstraints();
            c.resolveSupertypeConstraints();
            c.resolveSubtypeConstraints();
        }
        return c.typeArguments();
    }

    protected boolean applicableBySubtyping(ClassInstanceExpr expr, MethodDecl method) {
        if (method.getNumParameter() != expr.getNumArg()) {
            return false;
        }
        for (int i = 0; i < method.getNumParameter(); ++i) {
            if (expr.getArg(i).type().instanceOf(method.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    protected boolean applicableByMethodInvocationConversion(ClassInstanceExpr expr, MethodDecl method) {
        if (method.getNumParameter() != expr.getNumArg()) {
            return false;
        }
        for (int i = 0; i < method.getNumParameter(); ++i) {
            if (expr.getArg(i).type().methodInvocationConversionTo(method.getParameter(i).type())) continue;
            return false;
        }
        return true;
    }

    protected boolean applicableByVariableArity(ClassInstanceExpr expr, MethodDecl method) {
        int i;
        for (i = 0; i < method.getNumParameter() - 1; ++i) {
            if (expr.getArg(i).type().methodInvocationConversionTo(method.getParameter(i).type())) continue;
            return false;
        }
        for (i = method.getNumParameter() - 1; i < expr.getNumArg(); ++i) {
            if (expr.getArg(i).type().methodInvocationConversionTo(method.lastParameter().type().componentType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void typeCheck() {
        if (this.isAnonymousDecl()) {
            this.error("the diamond operator can not be used with anonymous classes");
        }
        if (this.isExplicitGenericConstructorAccess()) {
            this.error("the diamond operator may not be used with generic constructors with explicit type parameters");
        }
        if (this.getClassInstanceExpr() == null) {
            this.error("the diamond operator can only be used in class instance expressions");
        }
        if (!(this.getTypeAccess().type() instanceof ParClassDecl)) {
            this.error("the diamond operator can only be used to instantiate generic classes");
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        this.getTypeAccess().toString(sb);
        sb.append("<>");
    }

    public DiamondAccess() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public DiamondAccess(Access p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        TypeDecl accessType = this.getTypeAccess().type();
        if (this.isAnonymousDecl()) {
            return accessType;
        }
        if (this.getClassInstanceExpr() == null) {
            return accessType;
        }
        if (!(accessType instanceof ParClassDecl)) {
            return accessType;
        }
        SimpleSet maxSpecific = this.chooseConstructor();
        if (maxSpecific.isEmpty()) {
            return this.getTypeAccess().type();
        }
        MethodDecl constructor = (MethodDecl)maxSpecific.iterator().next();
        return constructor.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDiamond() {
        ASTNode$State state = this.state();
        boolean bl = true;
        return bl;
    }

    public java.util.List<TypeDecl> typeArguments(MethodDecl decl) {
        MethodDecl _parameters = decl;
        if (this.typeArguments_MethodDecl_values == null) {
            this.typeArguments_MethodDecl_values = new HashMap(4);
        }
        if (this.typeArguments_MethodDecl_values.containsKey(_parameters)) {
            return (java.util.List)this.typeArguments_MethodDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        java.util.List<TypeDecl> typeArguments_MethodDecl_value = this.typeArguments_compute(decl);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeArguments_MethodDecl_values.put(_parameters, typeArguments_MethodDecl_value);
        }
        return typeArguments_MethodDecl_value;
    }

    private java.util.List<TypeDecl> typeArguments_compute(MethodDecl decl) {
        LinkedList<TypeDecl> typeArguments = new LinkedList<TypeDecl>();
        if (decl instanceof GenericMethodDecl) {
            GenericMethodDecl method = (GenericMethodDecl)decl;
            Collection<TypeDecl> arguments = this.computeConstraints(method);
            if (arguments.isEmpty()) {
                return typeArguments;
            }
            int i = 0;
            for (TypeDecl argument : arguments) {
                if (argument == null) {
                    TypeVariable v = method.original().getTypeParameter(i);
                    argument = v.getNumTypeBound() == 0 ? this.typeObject() : (v.getNumTypeBound() == 1 ? v.getTypeBound(0).type() : v.lubType());
                }
                typeArguments.add(argument);
                ++i;
            }
        }
        return typeArguments;
    }

    public ClassInstanceExpr getClassInstanceExpr() {
        ASTNode$State state = this.state();
        ClassInstanceExpr getClassInstanceExpr_value = this.getParent().Define_ClassInstanceExpr_getClassInstanceExpr(this, null);
        return getClassInstanceExpr_value;
    }

    public TypeDecl typeObject() {
        ASTNode$State state = this.state();
        TypeDecl typeObject_value = this.getParent().Define_TypeDecl_typeObject(this, null);
        return typeObject_value;
    }

    public boolean isAnonymousDecl() {
        ASTNode$State state = this.state();
        boolean isAnonymousDecl_value = this.getParent().Define_boolean_isAnonymousDecl(this, null);
        return isAnonymousDecl_value;
    }

    public boolean isExplicitGenericConstructorAccess() {
        ASTNode$State state = this.state();
        boolean isExplicitGenericConstructorAccess_value = this.getParent().Define_boolean_isExplicitGenericConstructorAccess(this, null);
        return isExplicitGenericConstructorAccess_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

