/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.NumericLiteral;
import soot.JastAddJ.TypeDecl;
import soot.Value;
import soot.jimple.DoubleConstant;

public class DoubleLiteral
extends NumericLiteral
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean isZero_computed = false;
    protected boolean isZero_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.isZero_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public DoubleLiteral clone() throws CloneNotSupportedException {
        DoubleLiteral node = (DoubleLiteral)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.isZero_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public DoubleLiteral copy() {
        try {
            DoubleLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    @Override
    public DoubleLiteral fullCopy() {
        try {
            DoubleLiteral tree = this.clone();
            tree.setParent(null);
            if (this.children != null) {
                tree.children = new ASTNode[this.children.length];
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) {
                        tree.children[i] = null;
                        continue;
                    }
                    tree.children[i] = this.children[i].fullCopy();
                    tree.children[i].setParent(tree);
                }
            }
            return tree;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public void typeCheck() {
        if (!this.isZero() && this.constant().doubleValue() == 0.0) {
            this.error("It is an error for nonzero floating-point " + this.getLITERAL() + " to round to zero");
        }
        if (this.constant().doubleValue() == Double.NEGATIVE_INFINITY || this.constant().doubleValue() == Double.POSITIVE_INFINITY) {
            this.error("It is an error for floating-point " + this.getLITERAL() + " to round to an infinity");
        }
    }

    @Override
    public Value eval(Body b) {
        return DoubleConstant.v(this.constant().doubleValue());
    }

    public DoubleLiteral() {
    }

    @Override
    public void init$Children() {
    }

    public DoubleLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public DoubleLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol2.value;
        this.LITERALstart = symbol2.getStart();
        this.LITERALend = symbol2.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    @Override
    public void toString(StringBuffer s) {
        super.toString(s);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeDouble();
    }

    public boolean isZero() {
        if (this.isZero_computed) {
            return this.isZero_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isZero_value = this.isZero_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isZero_computed = true;
        }
        return this.isZero_value;
    }

    private boolean isZero_compute() {
        char c;
        for (int i = 0; i < this.digits.length() && (c = this.digits.charAt(i)) != 'e' && c != 'p'; ++i) {
            if (c == '0' || c == '.') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        try {
            Constant constant = Constant.create(Double.parseDouble(this.getDigits()));
            return constant;
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0.0);
            c.error = true;
            Constant constant = c;
            return constant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsRewrite() {
        ASTNode$State state = this.state();
        boolean bl = false;
        return bl;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

