/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.ClassInstanceExpr;
import soot.JastAddJ.EnumConstant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.List;
import soot.JastAddJ.Literal;
import soot.JastAddJ.Opt;
import soot.JastAddJ.TypeDecl;

public class EnumInstanceExpr
extends ClassInstanceExpr
implements Cloneable {
    protected boolean getAccess_computed = false;
    protected Access getAccess_value;
    protected boolean getArgList_computed = false;
    protected List<Expr> getArgList_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getAccess_computed = false;
        this.getAccess_value = null;
        this.getArgList_computed = false;
        this.getArgList_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public EnumInstanceExpr clone() throws CloneNotSupportedException {
        EnumInstanceExpr node = (EnumInstanceExpr)super.clone();
        node.getAccess_computed = false;
        node.getAccess_value = null;
        node.getArgList_computed = false;
        node.getArgList_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public EnumInstanceExpr copy() {
        try {
            EnumInstanceExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    @Override
    public EnumInstanceExpr fullCopy() {
        try {
            EnumInstanceExpr tree = this.clone();
            tree.setParent(null);
            if (this.children != null) {
                tree.children = new ASTNode[this.children.length];
                block6: for (int i = 0; i < this.children.length; ++i) {
                    switch (i) {
                        case 1: {
                            tree.children[i] = null;
                            continue block6;
                        }
                        case 2: {
                            tree.children[i] = new List();
                            continue block6;
                        }
                        default: {
                            if (this.children[i] == null) {
                                tree.children[i] = null;
                                continue block6;
                            }
                            tree.children[i] = this.children[i].fullCopy();
                            tree.children[i].setParent(tree);
                        }
                    }
                }
            }
            return tree;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public EnumInstanceExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[3];
        this.setChild(new Opt(), 0);
        this.setChild(new List(), 2);
    }

    public EnumInstanceExpr(Opt<TypeDecl> p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setTypeDeclOpt(Opt<TypeDecl> opt) {
        this.setChild(opt, 0);
    }

    @Override
    public boolean hasTypeDecl() {
        return this.getTypeDeclOpt().getNumChild() != 0;
    }

    @Override
    public TypeDecl getTypeDecl() {
        return (TypeDecl)this.getTypeDeclOpt().getChild(0);
    }

    @Override
    public void setTypeDecl(TypeDecl node) {
        this.getTypeDeclOpt().setChild(node, 0);
    }

    @Override
    public Opt<TypeDecl> getTypeDeclOpt() {
        return (Opt)this.getChild(0);
    }

    @Override
    public Opt<TypeDecl> getTypeDeclOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    @Override
    public void setAccess(Access node) {
        this.setChild(node, 1);
    }

    @Override
    public Access getAccessNoTransform() {
        return (Access)this.getChildNoTransform(1);
    }

    protected int getAccessChildPosition() {
        return 1;
    }

    @Override
    public void setArgList(List<Expr> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumArg() {
        return this.getArgList().getNumChild();
    }

    @Override
    public int getNumArgNoTransform() {
        return this.getArgListNoTransform().getNumChildNoTransform();
    }

    @Override
    public Expr getArg(int i) {
        return (Expr)this.getArgList().getChild(i);
    }

    @Override
    public void addArg(Expr node) {
        List<Expr> list = this.parent == null || state == null ? this.getArgListNoTransform() : this.getArgList();
        list.addChild(node);
    }

    @Override
    public void addArgNoTransform(Expr node) {
        List<Expr> list = this.getArgListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setArg(Expr node, int i) {
        List<Expr> list = this.getArgList();
        list.setChild(node, i);
    }

    @Override
    public List<Expr> getArgs() {
        return this.getArgList();
    }

    @Override
    public List<Expr> getArgsNoTransform() {
        return this.getArgListNoTransform();
    }

    @Override
    public List<Expr> getArgListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    protected int getArgListChildPosition() {
        return 2;
    }

    @Override
    public Access getAccess() {
        if (this.getAccess_computed) {
            return (Access)ASTNode.getChild(this, this.getAccessChildPosition());
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.getAccess_value = this.getAccess_compute();
        this.setAccess(this.getAccess_value);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.getAccess_computed = true;
        }
        return (Access)ASTNode.getChild(this, this.getAccessChildPosition());
    }

    private Access getAccess_compute() {
        return this.hostType().createQualifiedAccess();
    }

    @Override
    public List<Expr> getArgList() {
        if (this.getArgList_computed) {
            return (List)ASTNode.getChild(this, this.getArgListChildPosition());
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.getArgList_value = this.getArgList_compute();
        this.setArgList(this.getArgList_value);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.getArgList_computed = true;
        }
        return (List)ASTNode.getChild(this, this.getArgListChildPosition());
    }

    private List<Expr> getArgList_compute() {
        EnumConstant ec = (EnumConstant)this.getParent().getParent();
        List ecs = (List)ec.getParent();
        int idx = ecs.getIndexOfChild(ec);
        if (idx == -1) {
            throw new Error("internal: cannot determine numeric value of enum constant");
        }
        List<Expr> argList = new List<Expr>();
        argList.add(Literal.buildStringLiteral(ec.name()));
        argList.add(Literal.buildIntegerLiteral(idx));
        for (Expr arg : ec.getArgs()) {
            argList.add((Expr)arg.fullCopy());
        }
        return argList;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

