/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.AbstractDot;
import soot.JastAddJ.Access;
import soot.JastAddJ.GenericTypeDecl;
import soot.JastAddJ.ImportDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.ParTypeAccess;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;

public class TypeAccess
extends Access
implements Cloneable {
    protected String tokenString_Package;
    public int Packagestart;
    public int Packageend;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;
    protected boolean decl_computed = false;
    protected TypeDecl decl_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decls_computed = false;
        this.decls_value = null;
        this.decl_computed = false;
        this.decl_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public TypeAccess clone() throws CloneNotSupportedException {
        TypeAccess node = (TypeAccess)super.clone();
        node.decls_computed = false;
        node.decls_value = null;
        node.decl_computed = false;
        node.decl_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public TypeAccess copy() {
        try {
            TypeAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public TypeAccess fullCopy() {
        try {
            TypeAccess tree = this.clone();
            tree.setParent(null);
            if (this.children != null) {
                tree.children = new ASTNode[this.children.length];
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) {
                        tree.children[i] = null;
                        continue;
                    }
                    tree.children[i] = this.children[i].fullCopy();
                    tree.children[i].setParent(tree);
                }
            }
            return tree;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public void accessControl() {
        super.accessControl();
        TypeDecl hostType = this.hostType();
        if (hostType != null && !hostType.isUnknown() && !this.type().accessibleFrom(hostType)) {
            this.error("" + this + " in " + this.hostType().fullName() + " can not access type " + this.type().fullName());
        } else if ((hostType == null || hostType.isUnknown()) && !this.type().accessibleFromPackage(this.hostPackage())) {
            this.error("" + this + " can not access type " + this.type().fullName());
        }
    }

    @Override
    public void nameCheck() {
        if (this.isQualified() && !this.qualifier().isTypeAccess() && !this.qualifier().isPackageAccess()) {
            this.error("can not access the type named " + this.decl().typeName() + " in this context");
        }
        if (this.decls().isEmpty()) {
            this.error("no visible type named " + this.typeName());
        }
        if (this.decls().size() > 1) {
            StringBuffer s = new StringBuffer();
            s.append("several types named " + this.name() + ":");
            Iterator iter = this.decls().iterator();
            while (iter.hasNext()) {
                TypeDecl t = (TypeDecl)iter.next();
                s.append(" " + t.typeName());
            }
            this.error(s.toString());
        }
    }

    public TypeAccess(String name, int start, int end) {
        this(name);
        this.start = this.IDstart = start;
        this.end = this.IDend = end;
    }

    public TypeAccess(String typeName) {
        this("", typeName);
    }

    @Override
    public void toString(StringBuffer s) {
        if (this.decl().isReferenceType()) {
            s.append(this.nameWithPackage());
        } else {
            s.append(this.decl().name());
        }
    }

    @Override
    public void checkModifiers() {
        if (!(!this.decl().isDeprecated() || this.withinDeprecatedAnnotation() || this.hostType() != null && this.hostType().topLevelType() == this.decl().topLevelType() || this.withinSuppressWarnings("deprecation"))) {
            this.warning(this.decl().typeName() + " has been deprecated");
        }
    }

    public boolean isRaw() {
        ASTNode parent = this.getParent();
        while (parent instanceof AbstractDot) {
            parent = parent.getParent();
        }
        if (parent instanceof ParTypeAccess) {
            return false;
        }
        return !(parent instanceof ImportDecl);
    }

    @Override
    public void typeCheck() {
        TypeDecl type = this.type();
        if (type.isRawType() && type.isNestedType() && type.enclosingType().isParameterizedType() && !type.enclosingType().isRawType()) {
            this.error("Can not access a member type of a paramterized type as a raw type");
        }
    }

    @Override
    public void transformation() {
        super.transformation();
        if (this.type().elementType().isNestedType() && this.hostType() != null) {
            this.hostType().addUsedNestedType(this.type().elementType());
        }
    }

    public TypeAccess() {
    }

    @Override
    public void init$Children() {
    }

    public TypeAccess(String p0, String p1) {
        this.setPackage(p0);
        this.setID(p1);
    }

    public TypeAccess(Symbol p0, Symbol p1) {
        this.setPackage(p0);
        this.setID(p1);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPackage(String value) {
        this.tokenString_Package = value;
    }

    public void setPackage(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setPackage is only valid for String lexemes");
        }
        this.tokenString_Package = (String)symbol2.value;
        this.Packagestart = symbol2.getStart();
        this.Packageend = symbol2.getEnd();
    }

    public String getPackage() {
        return this.tokenString_Package != null ? this.tokenString_Package : "";
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    private TypeDecl refined_TypeScopePropagation_TypeAccess_decl() {
        SimpleSet decls = this.decls();
        if (decls.size() == 1) {
            return (TypeDecl)decls.iterator().next();
        }
        return this.unknownType();
    }

    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        if (this.packageName().equals("")) {
            return this.lookupType(this.name());
        }
        TypeDecl typeDecl = this.lookupType(this.packageName(), this.name());
        if (typeDecl != null) {
            return SimpleSet.emptySet.add(typeDecl);
        }
        return SimpleSet.emptySet;
    }

    public TypeDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private TypeDecl decl_compute() {
        TypeDecl decl = this.refined_TypeScopePropagation_TypeAccess_decl();
        if (decl instanceof GenericTypeDecl && this.isRaw()) {
            return ((GenericTypeDecl)((Object)decl)).lookupParTypeDecl(new ArrayList());
        }
        return decl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSet qualifiedLookupVariable(String name) {
        block4: {
            ASTNode$State state = this.state();
            if (!this.type().accessibleFrom(this.hostType())) break block4;
            SimpleSet c = this.type().memberFields(name);
            c = this.keepAccessibleFields(c);
            if (this.type().isClassDecl() && c.size() == 1) {
                c = this.removeInstanceVariables(c);
            }
            SimpleSet simpleSet = c;
            return simpleSet;
        }
        SimpleSet simpleSet = SimpleSet.emptySet;
        return simpleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        String string = this.getClass().getName() + " [" + this.getPackage() + ", " + this.getID() + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        ASTNode$State state = this.state();
        String string = this.getID();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String packageName() {
        ASTNode$State state = this.state();
        String string = this.getPackage();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nameWithPackage() {
        ASTNode$State state = this.state();
        String string = this.getPackage().equals("") ? this.name() : this.getPackage() + "." + this.name();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String typeName() {
        ASTNode$State state = this.state();
        String string = this.isQualified() ? this.qualifier().typeName() + "." + this.name() : this.nameWithPackage();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTypeAccess() {
        ASTNode$State state = this.state();
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType nameType = NameType.PACKAGE_OR_TYPE_NAME;
        return nameType;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.decl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesTypeVariable() {
        ASTNode$State state = this.state();
        boolean bl = this.decl().usesTypeVariable() || super.usesTypeVariable();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Access substituted(Collection<TypeVariable> original, List<TypeVariable> substitution) {
        ASTNode$State state = this.state();
        TypeDecl decl = this.decl();
        int i = 0;
        Iterator<TypeVariable> i$ = original.iterator();
        while (true) {
            if (!i$.hasNext()) {
                return super.substituted(original, substitution);
            }
            TypeVariable typeVar = i$.next();
            if (typeVar == decl) {
                return new TypeAccess(((TypeVariable)substitution.getChild(i)).getID());
            }
            ++i;
        }
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

