/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StringConstant;
import soot.options.Options;
import soot.util.NumberedString;

class SootMethodRefImpl
implements SootMethodRef {
    private final SootClass declaringClass;
    private final String name;
    private final List parameterTypes;
    private final Type returnType;
    private final boolean isStatic;
    private NumberedString subsig;

    public SootMethodRefImpl(SootClass declaringClass, String name, List parameterTypes, Type returnType, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.name = name;
        ArrayList l = new ArrayList();
        l.addAll(parameterTypes);
        this.parameterTypes = Collections.unmodifiableList(l);
        this.returnType = returnType;
        this.isStatic = isStatic;
        if (declaringClass == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null class");
        }
        if (name == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null name");
        }
        if (parameterTypes == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null parameterTypes");
        }
        if (returnType == null) {
            throw new RuntimeException("Attempt to create SootMethodRef with null returnType");
        }
    }

    @Override
    public SootClass declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type returnType() {
        return this.returnType;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public NumberedString getSubSignature() {
        if (this.subsig == null) {
            this.subsig = Scene.v().getSubSigNumberer().findOrAdd(SootMethod.getSubSignature(this.name, this.parameterTypes, this.returnType));
        }
        return this.subsig;
    }

    @Override
    public String getSignature() {
        return SootMethod.getSignature(this.declaringClass, this.name, this.parameterTypes, this.returnType);
    }

    @Override
    public Type parameterType(int i) {
        return (Type)this.parameterTypes.get(i);
    }

    @Override
    public SootMethod resolve() {
        return this.resolve(null);
    }

    private SootMethod checkStatic(SootMethod ret) {
        if (ret.isStatic() != this.isStatic()) {
            throw new ResolutionFailedException("Resolved " + this + " to " + ret + " which has wrong static-ness");
        }
        return ret;
    }

    private SootMethod resolve(StringBuffer trace) {
        if (this.declaringClass.getName().equals("java.dyn.InvokeDynamic")) {
            throw new IllegalStateException("Cannot resolve invokedynamic method references at compile time!");
        }
        SootClass cl = this.declaringClass;
        while (true) {
            if (trace != null) {
                trace.append("Looking in " + cl + " which has methods " + cl.getMethods() + "\n");
            }
            if (cl.declaresMethod(this.getSubSignature())) {
                return this.checkStatic(cl.getMethod(this.getSubSignature()));
            }
            if (Scene.v().allowsPhantomRefs() && (cl.isPhantom() || Options.v().ignore_resolution_errors())) {
                SootMethod m = new SootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
                m.setPhantom(true);
                cl.addMethod(m);
                return this.checkStatic(m);
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        cl = this.declaringClass;
        while (true) {
            LinkedList<SootClass> queue = new LinkedList<SootClass>();
            queue.addAll(cl.getInterfaces());
            while (!queue.isEmpty()) {
                SootClass iface = (SootClass)queue.removeFirst();
                if (trace != null) {
                    trace.append("Looking in " + iface + " which has methods " + iface.getMethods() + "\n");
                }
                if (iface.declaresMethod(this.getSubSignature())) {
                    return this.checkStatic(iface.getMethod(this.getSubSignature()));
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        if (Options.v().allow_phantom_refs()) {
            SootMethod m = new SootMethod(this.name, this.parameterTypes, this.returnType, this.isStatic() ? 8 : 0);
            JimpleBody body = Jimple.v().newBody(m);
            m.setActiveBody(body);
            RefType runtimeExceptionType = RefType.v("java.lang.Error");
            NewExpr newExpr = Jimple.v().newNewExpr(runtimeExceptionType);
            LocalGenerator lg = new LocalGenerator(body);
            Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(exceptionLocal, newExpr);
            body.getUnits().add(assignStmt);
            SootMethodRef cref = runtimeExceptionType.getSootClass().getMethod("<init>", Collections.singletonList(RefType.v("java.lang.String"))).makeRef();
            SpecialInvokeExpr constructorInvokeExpr = Jimple.v().newSpecialInvokeExpr(exceptionLocal, cref, StringConstant.v("Unresolved compilation error: Method " + this.getSignature() + " does not exist!"));
            InvokeStmt initStmt = Jimple.v().newInvokeStmt(constructorInvokeExpr);
            body.getUnits().insertAfter(initStmt, (Unit)assignStmt);
            body.getUnits().insertAfter(Jimple.v().newThrowStmt(exceptionLocal), (Unit)initStmt);
            this.declaringClass.addMethod(m);
            return m;
        }
        if (trace == null) {
            ClassResolutionFailedException e = new ClassResolutionFailedException();
            if (Options.v().ignore_resolution_errors()) {
                G.v().out.println(e.getMessage());
            } else {
                throw e;
            }
        }
        return null;
    }

    public String toString() {
        return this.getSignature();
    }

    public class ClassResolutionFailedException
    extends ResolutionFailedException {
        public ClassResolutionFailedException() {
            super("Class " + SootMethodRefImpl.this.declaringClass + " doesn't have method " + SootMethodRefImpl.this.name + "(" + SootMethodRefImpl.this.parameterTypes + ")" + " : " + SootMethodRefImpl.this.returnType + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(super.toString());
            SootMethodRefImpl.this.resolve(ret);
            return ret.toString();
        }
    }
}

