/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CoffiClassProvider;
import soot.CoffiClassSource;
import soot.CompilationDeathException;
import soot.DexClassProvider;
import soot.G;
import soot.JavaClassProvider;
import soot.JimpleClassProvider;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.options.Options;

public class SourceLocator {
    protected Set<ClassLoader> additionalClassLoaders = new HashSet<ClassLoader>();
    protected Set<String> classesToLoad;
    private List<ClassProvider> classProviders;
    private List<String> classPath;
    private List<String> sourcePath;
    private HashMap<String, String> sourceToClassMap;
    private Map<String, File> dexClassIndex;

    public SourceLocator(Singletons.Global g) {
    }

    public static SourceLocator v() {
        return G.v().soot_SourceLocator();
    }

    public ClassSource getClassSource(String className) {
        ClassSource ret;
        if (this.classesToLoad == null) {
            this.classesToLoad = new HashSet<String>();
            this.classesToLoad.addAll(Scene.v().getBasicClasses());
            for (SootClass c : Scene.v().getApplicationClasses()) {
                this.classesToLoad.add(c.getName());
            }
        }
        if (this.classPath == null) {
            this.classPath = this.explodeClassPath(Scene.v().getSootClassPath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        for (ClassProvider cp : this.classProviders) {
            try {
                ret = cp.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        for (final ClassLoader cl : this.additionalClassLoaders) {
            try {
                ret = new ClassProvider(){

                    @Override
                    public ClassSource find(String className) {
                        String fileName = className.replace('.', '/') + ".class";
                        InputStream stream = cl.getResourceAsStream(fileName);
                        if (stream == null) {
                            return null;
                        }
                        return new CoffiClassSource(className, stream);
                    }
                }.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        if (className.startsWith("soot.rtlib.tamiflex.")) {
            String fileName = className.replace('.', '/') + ".class";
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (stream != null) {
                return new CoffiClassSource(className, stream);
            }
        }
        return null;
    }

    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    private void setupClassProviders() {
        this.classProviders = new LinkedList<ClassProvider>();
        switch (Options.v().src_prec()) {
            case 1: {
                this.classProviders.add(new CoffiClassProvider());
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 2: {
                this.classProviders.add(new CoffiClassProvider());
                break;
            }
            case 4: {
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(new CoffiClassProvider());
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            case 3: {
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(new CoffiClassProvider());
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 5: {
                this.classProviders.add(new DexClassProvider());
                this.classProviders.add(new CoffiClassProvider());
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            default: {
                throw new RuntimeException("Other source precedences are not currently supported.");
            }
        }
    }

    public void setClassProviders(List<ClassProvider> classProviders) {
        this.classProviders = classProviders;
    }

    public List<String> classPath() {
        return this.classPath;
    }

    public void invalidateClassPath() {
        this.classPath = null;
    }

    public List<String> sourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new ArrayList<String>();
            for (String dir : this.classPath) {
                if (this.isArchive(dir)) continue;
                this.sourcePath.add(dir);
            }
        }
        return this.sourcePath;
    }

    private boolean isArchive(String path) {
        File f = new File(path);
        if (f.isFile() && f.canRead()) {
            if (path.endsWith(".zip") || path.endsWith(".jar") || path.endsWith(".apk")) {
                return true;
            }
            G.v().out.println("Warning: the following soot-classpath entry is not a supported archive file (must be .zip, .jar or .apk): " + path);
        }
        return false;
    }

    public List<String> getClassesUnder(String aPath) {
        ArrayList<String> classes = new ArrayList<String>();
        if (this.isArchive(aPath)) {
            ArrayList<String> inputExtensions = new ArrayList<String>(2);
            inputExtensions.add(".class");
            inputExtensions.add(".jimple");
            inputExtensions.add(".java");
            try {
                String entryName;
                ZipEntry entry;
                ZipFile archive = new ZipFile(aPath);
                boolean hasClassesDotDex = false;
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    entryName = entry.getName();
                    if (!entryName.equals("classes.dex")) continue;
                    hasClassesDotDex = true;
                    classes.addAll(DexClassProvider.classesOfDex(new File(aPath)));
                }
                entries = archive.entries();
                while (entries.hasMoreElements()) {
                    String entryExtension;
                    entry = entries.nextElement();
                    entryName = entry.getName();
                    int extensionIndex = entryName.lastIndexOf(46);
                    if (extensionIndex < 0 || !inputExtensions.contains(entryExtension = entryName.substring(extensionIndex))) continue;
                    entryName = entryName.substring(0, extensionIndex);
                    entryName = entryName.replace('/', '.');
                    if (!hasClassesDotDex) {
                        classes.add(entryName);
                        continue;
                    }
                    G.v().out.println("Warning: Since archive contains 'classes.dex', the following entry is not loaded: " + entry.getName());
                }
            }
            catch (IOException e) {
                G.v().out.println("Error reading " + aPath + ": " + e.toString());
                throw new CompilationDeathException(0);
            }
        }
        File file = new File(aPath);
        File[] files = file.listFiles();
        if (files == null) {
            files = new File[]{file};
        }
        for (File element : files) {
            if (element.isDirectory()) {
                List<String> l = this.getClassesUnder(aPath + File.separatorChar + element.getName());
                for (String s : l) {
                    classes.add(element.getName() + "." + s);
                }
                continue;
            }
            String fileName = element.getName();
            if (fileName.endsWith(".class")) {
                int index = fileName.lastIndexOf(".class");
                classes.add(fileName.substring(0, index));
            }
            if (fileName.endsWith(".jimple")) {
                int index = fileName.lastIndexOf(".jimple");
                classes.add(fileName.substring(0, index));
            }
            if (fileName.endsWith(".java")) {
                int index = fileName.lastIndexOf(".java");
                classes.add(fileName.substring(0, index));
            }
            if (!fileName.endsWith(".dex")) continue;
            try {
                classes.addAll(DexClassProvider.classesOfDex(element));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return classes;
    }

    public String getFileNameFor(SootClass c, int rep) {
        if (rep == 11) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if (!Options.v().output_jar()) {
            b.append(this.getOutputDir());
        }
        if (b.length() > 0 && b.charAt(b.length() - 1) != File.separatorChar) {
            b.append(File.separatorChar);
        }
        if (rep != 14) {
            if (rep == 13) {
                b.append(c.getName().replace('.', File.separatorChar));
            } else if (rep == 15) {
                b.append(c.getName().replace('.', '_'));
                b.append("_Maker");
            } else {
                b.append(c.getName());
            }
            b.append(this.getExtensionFor(rep));
            return b.toString();
        }
        return this.getDavaFilenameFor(c, b);
    }

    private String getDavaFilenameFor(SootClass c, StringBuffer b) {
        String path;
        File dir;
        b.append("dava");
        b.append(File.separatorChar);
        String classPath = b.toString() + "classes";
        File dir2 = new File(classPath);
        if (!dir2.exists()) {
            try {
                dir2.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + classPath);
                throw new CompilationDeathException(0);
            }
        }
        b.append("src");
        b.append(File.separatorChar);
        String fixedPackageName = c.getJavaPackageName();
        if (!fixedPackageName.equals("")) {
            b.append(fixedPackageName.replace('.', File.separatorChar));
            b.append(File.separatorChar);
        }
        if (!(dir = new File(path = b.toString())).exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + path);
                throw new CompilationDeathException(0);
            }
        }
        b.append(c.getShortJavaStyleName());
        b.append(".java");
        return b.toString();
    }

    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(Scene.v().getSootClassPath(), String.valueOf(File.pathSeparatorChar));
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            List<String> l = this.getClassesUnder(path);
            for (String filename : l) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            path = path + File.pathSeparatorChar;
            StringTokenizer tokenizer = new StringTokenizer(str, ".");
            while (tokenizer.hasMoreTokens()) {
                path = path + tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                path = path + File.pathSeparatorChar;
            }
            l = this.getClassesUnder(path);
            for (String string : l) {
                set.add(str + "." + string);
            }
        }
        return set;
    }

    public String getExtensionFor(int rep) {
        switch (rep) {
            case 5: {
                return ".baf";
            }
            case 6: {
                return ".b";
            }
            case 1: {
                return ".jimple";
            }
            case 2: {
                return ".jimp";
            }
            case 3: {
                return ".shimple";
            }
            case 4: {
                return ".shimp";
            }
            case 8: {
                return ".grimp";
            }
            case 7: {
                return ".grimple";
            }
            case 13: {
                return ".class";
            }
            case 14: {
                return ".java";
            }
            case 12: {
                return ".jasmin";
            }
            case 9: {
                return ".xml";
            }
            case 15: {
                return ".java";
            }
        }
        throw new RuntimeException();
    }

    public String getOutputDir() {
        File dir;
        String ret = Options.v().output_dir();
        if (ret.length() == 0) {
            ret = "sootOutput";
        }
        if (!(dir = new File(ret)).exists()) {
            try {
                if (!Options.v().output_jar()) {
                    dir.mkdirs();
                }
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + ret);
                throw new CompilationDeathException(0);
            }
        }
        return ret;
    }

    protected List<String> explodeClassPath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String originalDir = tokenizer.nextToken();
            try {
                String canonicalDir = new File(originalDir).getCanonicalPath();
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return ret;
    }

    private static InputStream doJDKBugWorkaround(InputStream is, long size) throws IOException {
        int sz;
        byte[] buf = new byte[sz];
        int N = 1024;
        int ln = 0;
        int count = 0;
        for (sz = (int)size; sz > 0 && (ln = is.read(buf, count, Math.min(1024, sz))) != -1; sz -= ln) {
            count += ln;
        }
        return new ByteArrayInputStream(buf);
    }

    public FoundFile lookupInClassPath(String fileName) {
        for (String dir : this.classPath) {
            FoundFile ret = this.isArchive(dir) ? this.lookupInArchive(dir, fileName) : this.lookupInDir(dir, fileName);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private FoundFile lookupInDir(String dir, String fileName) {
        File f = new File(dir + File.separatorChar + fileName);
        if (f.canRead()) {
            return new FoundFile(f);
        }
        return null;
    }

    private FoundFile lookupInArchive(String archivePath, String fileName) {
        try {
            ZipFile archive = new ZipFile(archivePath);
            ZipEntry entry = archive.getEntry(fileName);
            if (entry == null) {
                return null;
            }
            return new FoundFile(archive, entry);
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException " + e + " looking in archive file " + archivePath + " for file " + fileName);
        }
    }

    public HashMap<String, String> getSourceToClassMap() {
        return this.sourceToClassMap;
    }

    public void setSourceToClassMap(HashMap<String, String> map) {
        this.sourceToClassMap = map;
    }

    public void addToSourceToClassMap(String key, String val) {
        this.sourceToClassMap.put(key, val);
    }

    public String getSourceForClass(String className) {
        String javaClassName = className;
        if (className.indexOf("$") != -1) {
            javaClassName = className.substring(0, className.indexOf("$"));
        }
        if (this.sourceToClassMap != null && this.sourceToClassMap.get(javaClassName) != null) {
            javaClassName = this.sourceToClassMap.get(javaClassName);
        }
        return javaClassName;
    }

    public Map<String, File> dexClassIndex() {
        return this.dexClassIndex;
    }

    public void setDexClassIndex(Map<String, File> index) {
        this.dexClassIndex = index;
    }

    public static class FoundFile {
        public File file;
        public ZipFile zipFile;
        public ZipEntry entry;

        FoundFile(ZipFile zipFile, ZipEntry entry) {
            this.zipFile = zipFile;
            this.entry = entry;
        }

        FoundFile(File file) {
            this.file = file;
        }

        public InputStream inputStream() {
            try {
                if (this.file != null) {
                    return new FileInputStream(this.file);
                }
                return SourceLocator.doJDKBugWorkaround(this.zipFile.getInputStream(this.entry), this.entry.getSize());
            }
            catch (IOException e) {
                throw new RuntimeException("Caught IOException " + e);
            }
        }
    }
}

