/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.HasPhaseOptions;
import soot.PhaseOptions;
import soot.SceneTransformer;
import soot.Transformer;
import soot.options.Options;
import soot.util.PhaseDumper;

public class Transform
implements HasPhaseOptions {
    private final boolean DEBUG = true;
    String phaseName;
    Transformer t;
    private String declaredOpts;
    private String defaultOpts;

    public Transform(String phaseName, Transformer t) {
        this.phaseName = phaseName;
        this.t = t;
    }

    @Override
    public String getPhaseName() {
        return this.phaseName;
    }

    public Transformer getTransformer() {
        return this.t;
    }

    @Override
    public String getDeclaredOptions() {
        if (this.declaredOpts != null) {
            return this.declaredOpts;
        }
        return Options.getDeclaredOptionsForPhase(this.phaseName);
    }

    @Override
    public String getDefaultOptions() {
        if (this.defaultOpts != null) {
            return this.defaultOpts;
        }
        return Options.getDefaultOptionsForPhase(this.phaseName);
    }

    public void setDeclaredOptions(String options) {
        this.declaredOpts = options;
    }

    public void setDefaultOptions(String options) {
        this.defaultOpts = options;
    }

    public void apply() {
        Map options = PhaseOptions.v().getPhaseOptions(this.phaseName);
        if (PhaseOptions.getBoolean(options, "enabled") && Options.v().verbose()) {
            G.v().out.println("Applying phase " + this.phaseName + " to the scene.");
        }
        PhaseDumper.v().dumpBefore(this.getPhaseName());
        ((SceneTransformer)this.t).transform(this.phaseName, options);
        PhaseDumper.v().dumpAfter(this.getPhaseName());
    }

    public void apply(Body b) {
        Map options = PhaseOptions.v().getPhaseOptions(this.phaseName);
        if (PhaseOptions.getBoolean(options, "enabled") && Options.v().verbose()) {
            G.v().out.println("Applying phase " + this.phaseName + " to " + b.getMethod() + ".");
        }
        PhaseDumper.v().dumpBefore(b, this.getPhaseName());
        ((BodyTransformer)this.t).transform(b, this.phaseName, options);
        PhaseDumper.v().dumpAfter(b, this.getPhaseName());
    }
}

