/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.Util;
import soot.coffi.attribute_info;
import soot.coffi.cp_info;
import soot.coffi.local_variable_table_entry;

class LocalVariableTable_attribute
extends attribute_info {
    public int local_variable_table_length;
    public local_variable_table_entry[] local_variable_table;

    LocalVariableTable_attribute() {
    }

    public String getLocalVariableName(cp_info[] constant_pool, int idx) {
        return this.getLocalVariableName(constant_pool, idx, -1);
    }

    public String getLocalVariableName(cp_info[] constant_pool, int idx, int code) {
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            local_variable_table_entry e = this.local_variable_table[i];
            if (e.index != idx || code != -1 && (code < e.start_pc || code >= e.start_pc + e.length)) continue;
            if (constant_pool[e.name_index] instanceof CONSTANT_Utf8_info) {
                String n = ((CONSTANT_Utf8_info)constant_pool[e.name_index]).convert();
                if (Util.v().isValidJimpleName(n)) {
                    return n;
                }
                return null;
            }
            throw new RuntimeException("What? A local variable table name_index isn't a UTF8 entry?");
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.local_variable_table_length; ++i) {
            buffer.append(this.local_variable_table[i].toString() + "\n");
        }
        return buffer.toString();
    }
}

