/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import soot.Local;
import soot.SootField;
import soot.Value;
import soot.dava.DavaFlowAnalysisException;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.StructuredAnalysis;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

public class MustMayInitialize
extends StructuredAnalysis {
    HashMap<Object, List> mapping = new HashMap();
    DavaFlowSet finalResult;
    public static final int MUST = 0;
    public static final int MAY = 1;
    int MUSTMAY;

    public MustMayInitialize(Object analyze, int MUSTorMAY) {
        this.MUSTMAY = MUSTorMAY;
        this.setMergeType();
        this.finalResult = (DavaFlowSet)this.process(analyze, new DavaFlowSet());
    }

    @Override
    public DavaFlowSet emptyFlowSet() {
        return new DavaFlowSet();
    }

    @Override
    public void setMergeType() {
        if (this.MUSTMAY == 0) {
            this.MERGETYPE = 2;
        } else if (this.MUSTMAY == 1) {
            this.MERGETYPE = 1;
        } else {
            throw new DavaFlowAnalysisException("Only allowed 0 or 1 for MUST or MAY values");
        }
    }

    @Override
    public Object newInitialFlow() {
        return new DavaFlowSet();
    }

    @Override
    public Object cloneFlowSet(Object flowSet) {
        if (flowSet instanceof DavaFlowSet) {
            return ((DavaFlowSet)flowSet).clone();
        }
        throw new RuntimeException("cloneFlowSet not implemented for other flowSet types");
    }

    @Override
    public Object processUnaryBinaryCondition(ASTUnaryBinaryCondition cond, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new DavaFlowAnalysisException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    @Override
    public Object processSynchronizedLocal(Local local, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    @Override
    public Object processSwitchKey(Value key, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    @Override
    public Object processStatement(Stmt s, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processStatement is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        if (inSet == this.NOPATH) {
            return inSet;
        }
        if (s instanceof DefinitionStmt) {
            DavaFlowSet toReturn = (DavaFlowSet)this.cloneFlowSet(inSet);
            Value leftOp = ((DefinitionStmt)s).getLeftOp();
            SootField field = null;
            if (leftOp instanceof Local) {
                toReturn.add(leftOp);
                List temp = this.mapping.get(leftOp);
                ArrayList<Stmt> defs = temp == null ? new ArrayList<Stmt>() : (ArrayList<Stmt>)temp;
                defs.add(s);
                this.mapping.put(leftOp, defs);
            } else if (leftOp instanceof FieldRef) {
                field = ((FieldRef)leftOp).getField();
                toReturn.add(field);
                List temp = this.mapping.get(field);
                ArrayList<Stmt> defs = temp == null ? new ArrayList<Stmt>() : (ArrayList<Stmt>)temp;
                defs.add(s);
                this.mapping.put(field, defs);
            }
            return toReturn;
        }
        return input;
    }

    public boolean isMayInitialized(SootField field) {
        if (this.MUSTMAY == 1) {
            List temp = this.mapping.get(field);
            if (temp == null) {
                return false;
            }
            List list = temp;
            return list.size() != 0;
        }
        throw new RuntimeException("Cannot invoke isMayInitialized for a MUST analysis");
    }

    public boolean isMayInitialized(Value local) {
        if (this.MUSTMAY == 1) {
            List temp = this.mapping.get(local);
            if (temp == null) {
                return false;
            }
            List list = temp;
            return list.size() != 0;
        }
        throw new RuntimeException("Cannot invoke isMayInitialized for a MUST analysis");
    }

    public boolean isMustInitialized(SootField field) {
        if (this.MUSTMAY == 0) {
            return this.finalResult.contains(field);
        }
        throw new RuntimeException("Cannot invoke isMustinitialized for a MAY analysis");
    }

    public boolean isMustInitialized(Value local) {
        if (this.MUSTMAY == 0) {
            return this.finalResult.contains(local);
        }
        throw new RuntimeException("Cannot invoke isMustinitialized for a MAY analysis");
    }

    public List getDefs(Value local) {
        List temp = this.mapping.get(local);
        if (temp == null) {
            return null;
        }
        return temp;
    }

    public List getDefs(SootField field) {
        List temp = this.mapping.get(field);
        if (temp == null) {
            return null;
        }
        return temp;
    }
}

