/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionIterator;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import soot.Body;
import soot.Local;
import soot.Modifier;
import soot.NullType;
import soot.PackManager;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.dexpler.Debug;
import soot.dexpler.DexIfTransformer;
import soot.dexpler.DexNullTransformer;
import soot.dexpler.DexNumTransformer;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.Util;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DeferableInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.InstructionFactory;
import soot.dexpler.instructions.MoveExceptionInstruction;
import soot.dexpler.instructions.PseudoInstruction;
import soot.dexpler.instructions.RetypeableInstruction;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class DexBody {
    private List<DexlibAbstractInstruction> instructions;
    private Local[] registerLocals;
    private Local storeResultLocal;
    private Map<Integer, DexlibAbstractInstruction> instructionAtAddress;
    private LocalGenerator localGenerator;
    private List<DeferableInstruction> deferredInstructions;
    private Set<RetypeableInstruction> instructionsToRetype;
    private DanglingInstruction dangling;
    private int numRegisters;
    private int numParameterRegisters;
    private List<Type> parameterTypes;
    private boolean isStatic;
    private String methodString = "";
    private JimpleBody jBody;
    private CodeItem.TryItem[] tries;
    private RefType declaringClassType;
    private static LocalSplitter splitter;
    private ArrayList<PseudoInstruction> pseudoInstructionData = new ArrayList();
    private DexFile dexFile = null;
    public IDalvikTyper dalvikTyper = null;

    PseudoInstruction isAddressInData(int a) {
        for (PseudoInstruction pi : this.pseudoInstructionData) {
            int fb = pi.getDataFirstByte();
            int lb = pi.getDataLastByte();
            if (fb > a || a > lb) continue;
            return pi;
        }
        return null;
    }

    public DexBody(DexFile dexFile, CodeItem code, RefType declaringClassType) {
        this.dexFile = dexFile;
        this.declaringClassType = declaringClassType;
        this.tries = code.getTries();
        this.methodString = code.getParent().method.toString();
        ProtoIdItem prototype = code.getParent().method.getPrototype();
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(prototype.getParameters());
        if (paramTypes != null) {
            this.parameterTypes = new ArrayList<Type>();
            for (TypeIdItem type : paramTypes) {
                this.parameterTypes.add(DexType.toSoot(type));
            }
        } else {
            this.parameterTypes = Collections.emptyList();
        }
        this.numRegisters = code.getRegisterCount();
        this.numParameterRegisters = prototype.getParameterRegisterCount();
        this.isStatic = Modifier.isStatic(code.getParent().accessFlags);
        this.instructions = new ArrayList<DexlibAbstractInstruction>();
        this.instructionAtAddress = new HashMap<Integer, DexlibAbstractInstruction>();
        this.registerLocals = new Local[this.numRegisters];
        int address = 0;
        for (Instruction instruction : code.getInstructions()) {
            DexlibAbstractInstruction dexInstruction = InstructionFactory.fromInstruction(instruction, address);
            this.instructions.add(dexInstruction);
            this.instructionAtAddress.put(address, dexInstruction);
            Debug.printDbg(" put instruction '" + dexInstruction + "' at 0x" + Integer.toHexString(address));
            address += instruction.getSize(address);
        }
        for (DexlibAbstractInstruction instruction : this.instructions) {
            if (!(instruction instanceof PseudoInstruction)) continue;
            PseudoInstruction pi = (PseudoInstruction)instruction;
            try {
                pi.computeDataOffsets(this);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while computing data offsets: ", e);
            }
            this.pseudoInstructionData.add(pi);
            Debug.printDbg("add pseudo instruction: 0x" + Integer.toHexString(pi.getDataFirstByte()) + " - 0x" + Integer.toHexString(pi.getDataLastByte()) + " : " + pi.getDataSize());
        }
        DebugInfoItem debugInfoItem = code.getDebugInfo();
        if (debugInfoItem != null) {
            DebugInstructionIterator.DecodeInstructions(debugInfoItem, this.numRegisters, new DebugInstructionIterator.ProcessDecodedDebugInstructionDelegate(){

                @Override
                public void ProcessLineEmit(int codeAddress, int line) {
                    DexBody.this.instructionAtAddress(codeAddress).setLineNumber(line);
                }
            });
        }
    }

    public Set<DexType> usedTypes() {
        HashSet<DexType> types = new HashSet<DexType>();
        for (DexlibAbstractInstruction i : this.instructions) {
            types.addAll(i.introducedTypes());
        }
        if (this.tries != null) {
            for (CodeItem.TryItem tryItem : this.tries) {
                CodeItem.EncodedCatchHandler h = tryItem.encodedCatchHandler;
                for (CodeItem.EncodedTypeAddrPair handler : h.handlers) {
                    types.add(new DexType(handler.exceptionType));
                }
            }
        }
        return types;
    }

    public void add(Unit u) {
        this.getBody().getUnits().add(u);
    }

    public void addDeferredJimplification(DeferableInstruction i) {
        this.deferredInstructions.add(i);
    }

    public void addRetype(RetypeableInstruction i) {
        this.instructionsToRetype.add(i);
    }

    public Local generateLocal(Type t) {
        return this.localGenerator.generateLocal(t);
    }

    public Body getBody() {
        if (this.jBody == null) {
            throw new RuntimeException("No jimplification happened yet, no body available.");
        }
        return this.jBody;
    }

    public Local[] getRegisterLocals() {
        return this.registerLocals;
    }

    public Local getRegisterLocal(int num) {
        return this.registerLocals[num];
    }

    public Local getStoreResultLocal() {
        return this.storeResultLocal;
    }

    public DexlibAbstractInstruction instructionAtAddress(int address) {
        DexlibAbstractInstruction i;
        PseudoInstruction pi = this.isAddressInData(address);
        if (pi != null && !pi.isLoaded()) {
            System.out.println("warning: attempting to jump to pseudo-instruction data at address 0x" + Integer.toHexString(address));
            System.out.println("pseudo instruction: " + pi);
            pi.setLoaded(true);
            this.instructions.addAll(this.decodeInstructions(pi));
            Exception e = new Exception();
            e.printStackTrace();
            System.out.println();
        }
        if ((i = this.instructionAtAddress.get(address)) == null && (i = this.instructionAtAddress.get(address - 1)) == null && (i = this.instructionAtAddress.get(address - 2)) == null) {
            throw new RuntimeException("Address 0x" + Integer.toHexString(address) + "(& -1 -2) not part of method '" + this.methodString + "'");
        }
        return i;
    }

    private ArrayList<DexlibAbstractInstruction> decodeInstructions(PseudoInstruction pi) {
        final ArrayList instructionList = new ArrayList();
        ArrayList<DexlibAbstractInstruction> dexInstructions = new ArrayList<DexlibAbstractInstruction>();
        byte[] encodedInstructions = pi.getData();
        InstructionIterator.IterateInstructions(this.dexFile, encodedInstructions, new InstructionIterator.ProcessInstructionDelegate(){

            @Override
            public void ProcessInstruction(int codeAddress, Instruction instruction) {
                instructionList.add(instruction);
            }
        });
        Instruction[] instructions = new Instruction[instructionList.size()];
        instructionList.toArray(instructions);
        System.out.println("instructionList: ");
        int address = pi.getDataFirstByte();
        for (Instruction i : instructions) {
            DexlibAbstractInstruction dexInstruction = InstructionFactory.fromInstruction(i, address);
            this.instructionAtAddress.put(address, dexInstruction);
            dexInstructions.add(dexInstruction);
            System.out.println("i = " + dexInstruction + " @ 0x" + Integer.toHexString(address));
            address += i.getSize(address);
        }
        return dexInstructions;
    }

    public Body jimplify(SootMethod m) {
        this.jBody = Jimple.v().newBody(m);
        this.localGenerator = new LocalGenerator(this.jBody);
        this.deferredInstructions = new ArrayList<DeferableInstruction>();
        this.instructionsToRetype = new HashSet<RetypeableInstruction>();
        Debug.printDbg("\n[jimplify] start for: " + this.methodString);
        LinkedList<Local> paramLocals = new LinkedList<Local>();
        if (!this.isStatic) {
            int thisRegister = this.numRegisters - this.numParameterRegisters - 1;
            Local thisLocal = Jimple.v().newLocal("$u" + thisRegister, UnknownType.v());
            this.jBody.getLocals().add(thisLocal);
            this.registerLocals[thisRegister] = thisLocal;
            JIdentityStmt idStmt = (JIdentityStmt)Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(this.declaringClassType));
            this.add(idStmt);
            paramLocals.add(thisLocal);
        }
        int i = 0;
        int parameterRegister = this.numRegisters - this.numParameterRegisters;
        for (Type t : this.parameterTypes) {
            Local gen = Jimple.v().newLocal("$u" + parameterRegister, UnknownType.v());
            this.jBody.getLocals().add(gen);
            Debug.printDbg("add local for parameter register number: " + parameterRegister);
            this.registerLocals[parameterRegister] = gen;
            JIdentityStmt idStmt = (JIdentityStmt)Jimple.v().newIdentityStmt(gen, Jimple.v().newParameterRef(t, i++));
            this.add(idStmt);
            paramLocals.add(gen);
            if (t.toString().equals("long") || t.toString().equals("double")) {
                Local g = Jimple.v().newLocal("$u" + ++parameterRegister, UnknownType.v());
                this.jBody.getLocals().add(g);
                this.registerLocals[parameterRegister] = g;
            }
            ++parameterRegister;
        }
        for (i = 0; i < this.numRegisters - this.numParameterRegisters - (this.isStatic ? 0 : 1); ++i) {
            Debug.printDbg("add local for register number: " + i);
            this.registerLocals[i] = Jimple.v().newLocal("$u" + i, UnknownType.v());
            this.jBody.getLocals().add(this.registerLocals[i]);
        }
        this.storeResultLocal = Jimple.v().newLocal("$u-1", UnknownType.v());
        this.jBody.getLocals().add(this.storeResultLocal);
        for (DexlibAbstractInstruction instruction : this.instructions) {
            if (this.dangling != null) {
                this.dangling.finalize(this, instruction);
                this.dangling = null;
            }
            instruction.jimplify(this);
        }
        for (DeferableInstruction instruction : this.deferredInstructions) {
            instruction.deferredJimplify(this);
        }
        if (this.tries != null) {
            this.addTraps();
        }
        UnreachableCodeEliminator.v().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        Debug.printDbg("\nbefore splitting");
        Debug.printDbg("" + this.jBody);
        this.splitLocals();
        Debug.printDbg("\nafter splitting");
        Debug.printDbg("" + this.jBody);
        for (RetypeableInstruction i2 : this.instructionsToRetype) {
            i2.retype();
        }
        ArrayList<DexlibAbstractInstruction> iToRemove = new ArrayList<DexlibAbstractInstruction>();
        for (DexlibAbstractInstruction i3 : this.instructions) {
            if (this.jBody.getUnits().contains(i3.getUnit())) continue;
            iToRemove.add(i3);
        }
        for (DexlibAbstractInstruction i3 : iToRemove) {
            Debug.printDbg("removing dexinstruction containing unit '" + i3.getUnit() + "'");
            this.instructions.remove(i3);
        }
        DexNumTransformer.v().transform(this.jBody);
        DexNullTransformer.v().transform(this.jBody);
        DexIfTransformer.v().transform(this.jBody);
        Debug.printDbg("\nafter Num and Null transformers");
        Debug.printDbg("" + this.jBody);
        TypeAssigner.v().transform(this.jBody);
        LocalPacker.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        LocalNameStandardizer.v().transform(this.jBody);
        Debug.printDbg("\nafter type assigner localpacker and name standardizer");
        Debug.printDbg("" + this.jBody);
        PackManager.v().getPack("jb").apply(this.jBody);
        for (Unit u : this.jBody.getUnits()) {
            CastExpr c;
            AssignStmt ass;
            if (!(u instanceof AssignStmt) || !((ass = (AssignStmt)u).getRightOp() instanceof CastExpr) || !((c = (CastExpr)ass.getRightOp()).getType() instanceof NullType)) continue;
            Debug.printDbg("replacing cast to null_type by nullConstant assignment in " + u);
            ass.setRightOp(NullConstant.v());
        }
        Debug.printDbg("\nafter jb pack");
        Debug.printDbg("" + this.jBody);
        if (m.getName().equals("<init>") || m.getName().equals("<clinit>")) {
            System.out.println("constant initSm: " + m);
            Util.addConstantTags(this.jBody);
        }
        return this.jBody;
    }

    private void splitLocals() {
        if (splitter == null) {
            splitter = new LocalSplitter(new DalvikThrowAnalysis());
        }
        splitter.transform(this.jBody);
    }

    public void setDanglingInstruction(DanglingInstruction i) {
        this.dangling = i;
    }

    public List<DexlibAbstractInstruction> instructionsAfter(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction" + instruction + "not part of this body.");
        }
        return this.instructions.subList(i + 1, this.instructions.size());
    }

    public List<DexlibAbstractInstruction> instructionsBefore(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction " + instruction + " not part of this body.");
        }
        ArrayList<DexlibAbstractInstruction> l = new ArrayList<DexlibAbstractInstruction>();
        l.addAll(this.instructions.subList(0, i));
        Collections.reverse(l);
        return l;
    }

    private void addTraps() {
        for (CodeItem.TryItem tryItem : this.tries) {
            int startAddress = tryItem.getStartCodeAddress();
            Debug.printDbg(" start : 0x" + Integer.toHexString(startAddress));
            int length = tryItem.getTryLength();
            Debug.printDbg(" length: 0x" + Integer.toHexString(length));
            Debug.printDbg(" end   : 0x" + Integer.toHexString(startAddress + length));
            int endAddress = startAddress + length;
            Unit beginStmt = this.instructionAtAddress(startAddress).getUnit();
            Unit endStmt = this.instructionAtAddress(endAddress).getUnit();
            Debug.printDbg("begin instruction (0x" + Integer.toHexString(startAddress) + "): " + this.instructionAtAddress(startAddress).getUnit() + " --- " + this.instructionAtAddress(startAddress).getUnit());
            Debug.printDbg("end instruction   (0x" + Integer.toHexString(endAddress) + "): " + this.instructionAtAddress(endAddress).getUnit() + " --- " + this.instructionAtAddress(endAddress).getUnit());
            CodeItem.EncodedCatchHandler h = tryItem.encodedCatchHandler;
            for (CodeItem.EncodedTypeAddrPair handler : h.handlers) {
                int handlerAddress = handler.getHandlerAddress();
                Debug.printDbg("handler   (0x" + Integer.toHexString(handlerAddress) + "): " + this.instructionAtAddress(handlerAddress).getUnit() + " --- " + this.instructionAtAddress(handlerAddress - 1).getUnit());
                Type t = DexType.toSoot(handler.exceptionType);
                if (!(t instanceof RefType)) continue;
                SootClass exception = ((RefType)t).getSootClass();
                DexlibAbstractInstruction instruction = this.instructionAtAddress(handler.getHandlerAddress());
                if (!(instruction instanceof MoveExceptionInstruction)) {
                    Debug.printDbg("First instruction of trap handler unit not MoveException but " + instruction.getClass());
                } else {
                    ((MoveExceptionInstruction)instruction).setRealType(this, exception.getType());
                }
                Trap trap = Jimple.v().newTrap(exception, beginStmt, endStmt, instruction.getUnit());
                this.jBody.getTraps().add(trap);
            }
            int catchAllHandlerAddress = h.getCatchAllHandlerAddress();
            if (catchAllHandlerAddress == -1) continue;
            DexlibAbstractInstruction i = this.instructionAtAddress(catchAllHandlerAddress);
            Unit catchAllHandler = i.getUnit();
            SootClass exc = SootResolver.v().makeClassRef("java.lang.Throwable");
            Trap trap = Jimple.v().newTrap(exc, beginStmt, endStmt, catchAllHandler);
            ((RetypeableInstruction)((Object)i)).setRealType(this, exc.getType());
            this.jBody.getTraps().add(trap);
        }
    }
}

