/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.BooleanEncodedValue;
import org.jf.dexlib.EncodedValue.ByteEncodedValue;
import org.jf.dexlib.EncodedValue.CharEncodedValue;
import org.jf.dexlib.EncodedValue.DoubleEncodedValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.FloatEncodedValue;
import org.jf.dexlib.EncodedValue.IntEncodedValue;
import org.jf.dexlib.EncodedValue.LongEncodedValue;
import org.jf.dexlib.EncodedValue.ShortEncodedValue;
import org.jf.dexlib.EncodedValue.StringEncodedValue;
import org.jf.dexlib.TypeIdItem;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.G;
import soot.IntType;
import soot.Modifier;
import soot.Type;
import soot.dexpler.DexField;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;

public class DexClass {
    protected String name;
    protected TypeIdItem type;
    protected String superClassName;
    protected String[] interfaceNames;
    protected AnnotationDirectoryItem annotations;
    protected Set<DexField> fields;
    protected Set<DexMethod> methods;
    protected Set<DexType> types;
    protected int accessFlags;

    public DexClass(ClassDefItem classDef) {
        this.type = classDef.getClassType();
        this.name = classDef.getClassType().getTypeDescriptor();
        this.types = new HashSet<DexType>();
        TypeIdItem superClass = classDef.getSuperclass();
        this.superClassName = superClass.getTypeDescriptor();
        this.types.add(new DexType(superClass));
        this.accessFlags = classDef.getAccessFlags();
        if (classDef.getInterfaces() == null) {
            this.interfaceNames = new String[0];
        } else {
            this.interfaceNames = new String[classDef.getInterfaces().getTypes().size()];
            int i = 0;
            for (TypeIdItem interfaceName : classDef.getInterfaces().getTypes()) {
                this.interfaceNames[i++] = interfaceName.getTypeDescriptor();
                this.types.add(new DexType(interfaceName));
            }
        }
        ClassDataItem classData = classDef.getClassData();
        if (classData == null) {
            this.methods = Collections.emptySet();
            this.fields = Collections.emptySet();
        } else {
            ClassDataItem.EncodedMethod[] methods;
            int numMethods = classData.getDirectMethods().length + classData.getVirtualMethods().length;
            int numFields = classData.getInstanceFields().length + classData.getStaticFields().length;
            this.methods = new HashSet<DexMethod>(numMethods);
            this.fields = new HashSet<DexField>(numFields);
            this.annotations = classDef.getAnnotations();
            ClassDataItem.EncodedField[] fields = Util.concat(classData.getInstanceFields(), classData.getStaticFields());
            int fieldIndex = 0;
            for (ClassDataItem.EncodedField field : fields) {
                DexField dexField = new DexField(field, this);
                if (field.isStatic()) {
                    if (Modifier.isFinal(field.accessFlags)) {
                        this.addConstantTag(classDef, dexField, fieldIndex);
                    }
                    ++fieldIndex;
                }
                this.fields.add(dexField);
            }
            for (ClassDataItem.EncodedMethod method : methods = Util.concat(classData.getDirectMethods(), classData.getVirtualMethods())) {
                DexMethod dexMethod = new DexMethod(classDef.getDexFile(), method, this);
                this.methods.add(dexMethod);
            }
        }
    }

    private void addConstantTag(ClassDefItem classDef, DexField df, int fieldIndex) {
        ConstantValueTag tag = null;
        EncodedArrayItem fieldInitsArray = classDef.getStaticFieldInitializers();
        if (null == fieldInitsArray) {
            return;
        }
        EncodedValue[] fieldInits = fieldInitsArray.getEncodedArray().values;
        if (fieldInits.length < fieldIndex + 1) {
            Type t = df.fieldType.toSoot();
            if (t instanceof IntType || t instanceof CharType || t instanceof ByteType || t instanceof BooleanType) {
                tag = new IntegerConstantValueTag(0);
            } else if (t.toString().equals("java.lang.String")) {
                G.v().out.println("warning: final static String initialized to null!");
            }
            if (tag != null) {
                df.tags.add(tag);
            }
            return;
        }
        EncodedValue ev = fieldInits[fieldIndex];
        if (ev instanceof BooleanEncodedValue) {
            tag = new IntegerConstantValueTag(((BooleanEncodedValue)ev).value ? 1 : 0);
        } else if (ev instanceof ByteEncodedValue) {
            tag = new IntegerConstantValueTag(((ByteEncodedValue)ev).value);
        } else if (ev instanceof CharEncodedValue) {
            tag = new IntegerConstantValueTag(((CharEncodedValue)ev).value);
        } else if (ev instanceof DoubleEncodedValue) {
            tag = new DoubleConstantValueTag(((DoubleEncodedValue)ev).value);
        } else if (ev instanceof FloatEncodedValue) {
            tag = new FloatConstantValueTag(((FloatEncodedValue)ev).value);
        } else if (ev instanceof IntEncodedValue) {
            tag = new IntegerConstantValueTag(((IntEncodedValue)ev).value);
        } else if (ev instanceof LongEncodedValue) {
            tag = new LongConstantValueTag(((LongEncodedValue)ev).value);
        } else if (ev instanceof ShortEncodedValue) {
            tag = new IntegerConstantValueTag(((ShortEncodedValue)ev).value);
        } else if (ev instanceof StringEncodedValue) {
            tag = new StringConstantValueTag(((StringEncodedValue)ev).value.getStringValue());
        }
        if (tag != null) {
            df.tags.add(tag);
        }
    }

    public int getModifiers() {
        return this.accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public TypeIdItem getType() {
        return this.type;
    }

    public String getSuperclass() {
        return this.superClassName;
    }

    public String[] getInterfaces() {
        return this.interfaceNames;
    }

    public Set<DexMethod> getDeclaredMethods() {
        return this.methods;
    }

    public Set<DexField> getDeclaredFields() {
        return this.fields;
    }

    public DexField getFieldByName(String fname) {
        Object f = null;
        for (DexField df : this.getDeclaredFields()) {
            if (!df.getName().equals(fname)) continue;
            return df;
        }
        throw new RuntimeException("error: no field named '" + fname + "' in class '" + this.name);
    }

    public Set<DexType> getAllTypes() {
        return this.types;
    }
}

