/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.ClassDataItem;
import soot.SootField;
import soot.dexpler.DexClass;
import soot.dexpler.DexType;
import soot.tagkit.Tag;

public class DexField {
    protected String name;
    protected int accessFlags;
    protected DexClass dexClass;
    protected DexType fieldType;
    protected List<Tag> tags = new ArrayList<Tag>();

    public DexField(ClassDataItem.EncodedField field, DexClass dexClass) {
        this.name = field.field.getFieldName().getStringValue();
        this.dexClass = dexClass;
        this.accessFlags = field.accessFlags;
        this.fieldType = new DexType(field.field.getFieldType());
        dexClass.types.add(this.fieldType);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.dexClass.getName() + "->" + this.name;
    }

    public DexClass getDexClass() {
        return this.dexClass;
    }

    public int getModifier() {
        return this.accessFlags;
    }

    public SootField toSoot() {
        SootField sf = new SootField(this.name, this.fieldType.toSoot(), this.accessFlags);
        for (Tag t : this.tags) {
            sf.addTag(t);
        }
        return sf;
    }
}

