/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.RefLikeType;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.dexpler.Debug;
import soot.dexpler.DexTransformer;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DexIfTransformer
extends DexTransformer {
    private boolean usedAsObject;
    private boolean doBreak = false;
    Local l = null;

    public static DexIfTransformer v() {
        return new DexIfTransformer();
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map options) {
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body);
        SmartLocalDefs localDefs = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        SimpleLocalUses localUses = new SimpleLocalUses(g, (LocalDefs)localDefs);
        for (IfStmt ifs : this.getNullIfCandidates(body)) {
            ArrayList<Local> twoIfLocals = new ArrayList<Local>();
            ConditionExpr ifCondition = (ConditionExpr)ifs.getCondition();
            Local lOp1 = (Local)ifCondition.getOp1();
            Local lOp2 = (Local)ifCondition.getOp2();
            twoIfLocals.add(lOp1);
            twoIfLocals.add(lOp2);
            this.usedAsObject = false;
            for (Local loc : twoIfLocals) {
                Debug.printDbg("\n[null if with two local candidate] " + loc);
                List<Unit> defs = this.collectDefinitionsWithAliases(loc, localDefs, localUses, body);
                for (Unit u : defs) {
                    for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                        Debug.printDbg("[use in u]: " + pair.getUnit());
                    }
                }
                this.doBreak = false;
                for (Unit u : defs) {
                    if (u instanceof AssignStmt) {
                        this.l = (Local)((AssignStmt)u).getLeftOp();
                    } else if (u instanceof IdentityStmt) {
                        this.l = (Local)((IdentityStmt)u).getLeftOp();
                    } else if (u instanceof IfStmt) {
                        throw new RuntimeException("ERROR: def can not be something else than Assign or Identity statement! (def: " + u + " class: " + u.getClass() + "");
                    }
                    Debug.printDbg("    target local: " + this.l + " (Unit: " + u + " )");
                    u.apply(new AbstractStmtSwitch(){

                        @Override
                        public void caseAssignStmt(AssignStmt stmt) {
                            Value r = stmt.getRightOp();
                            if (r instanceof FieldRef) {
                                DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(((FieldRef)r).getFieldRef().type());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof ArrayRef) {
                                ArrayRef ar = (ArrayRef)r;
                                if (ar.getType() instanceof UnknownType) {
                                    DexIfTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                } else {
                                    DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(ar.getType());
                                }
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof StringConstant || r instanceof NewExpr || r instanceof NewArrayExpr) {
                                DexIfTransformer.this.usedAsObject = true;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof CastExpr) {
                                DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(((CastExpr)r).getCastType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof InvokeExpr) {
                                DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(((InvokeExpr)r).getType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof LengthExpr) {
                                DexIfTransformer.this.usedAsObject = false;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof Local) {
                                // empty if block
                            }
                        }

                        @Override
                        public void caseIdentityStmt(IdentityStmt stmt) {
                            if (stmt.getLeftOp() == DexIfTransformer.this.l) {
                                DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(stmt.getRightOp().getType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                        }
                    });
                    if (this.doBreak) break;
                    for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                        Unit use = pair.getUnit();
                        Debug.printDbg("    use: " + use);
                        use.apply(new AbstractStmtSwitch(){

                            private boolean examineInvokeExpr(InvokeExpr e) {
                                AbstractInstanceInvokeExpr aiiexpr;
                                Value b;
                                List<Value> args = e.getArgs();
                                List<Type> argTypes = e.getMethod().getParameterTypes();
                                assert (args.size() == argTypes.size());
                                for (int i = 0; i < args.size(); ++i) {
                                    if (args.get(i) != DexIfTransformer.this.l || !DexIfTransformer.this.isObject(argTypes.get(i))) continue;
                                    return true;
                                }
                                SootMethodRef sm = e.getMethodRef();
                                return !sm.isStatic() && e instanceof AbstractInvokeExpr && (b = (aiiexpr = (AbstractInstanceInvokeExpr)e).getBase()) == DexIfTransformer.this.l;
                            }

                            @Override
                            public void caseInvokeStmt(InvokeStmt stmt) {
                                InvokeExpr e = stmt.getInvokeExpr();
                                DexIfTransformer.this.usedAsObject = this.examineInvokeExpr(e);
                                Debug.printDbg("use as object = " + DexIfTransformer.this.usedAsObject);
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseAssignStmt(AssignStmt stmt) {
                                Value left = stmt.getLeftOp();
                                Value r = stmt.getRightOp();
                                if (left instanceof ArrayRef && ((ArrayRef)left).getIndex() == DexIfTransformer.this.l) {
                                    return;
                                }
                                if (stmt.getRightOp() == DexIfTransformer.this.l) {
                                    Value l = stmt.getLeftOp();
                                    if (l instanceof StaticFieldRef && DexIfTransformer.this.isObject(((StaticFieldRef)l).getFieldRef().type())) {
                                        DexIfTransformer.this.usedAsObject = true;
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                    if (l instanceof InstanceFieldRef && DexIfTransformer.this.isObject(((InstanceFieldRef)l).getFieldRef().type())) {
                                        DexIfTransformer.this.usedAsObject = true;
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                    if (l instanceof ArrayRef) {
                                        Type aType = ((ArrayRef)l).getType();
                                        if (aType instanceof UnknownType) {
                                            DexIfTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                        } else {
                                            DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(aType);
                                        }
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                }
                                if (r instanceof FieldRef) {
                                    DexIfTransformer.this.usedAsObject = true;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof ArrayRef) {
                                    ArrayRef ar = (ArrayRef)r;
                                    if (ar.getBase() == DexIfTransformer.this.l) {
                                        DexIfTransformer.this.usedAsObject = true;
                                    } else {
                                        DexIfTransformer.this.usedAsObject = false;
                                    }
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof StringConstant || r instanceof NewExpr) {
                                    Debug.printDbg("NOT POSSIBLE StringConstant or NewExpr! " + stmt);
                                    System.exit(-1);
                                    DexIfTransformer.this.usedAsObject = true;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof NewArrayExpr) {
                                    DexIfTransformer.this.usedAsObject = false;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof CastExpr) {
                                    DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(((CastExpr)r).getCastType());
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof InvokeExpr) {
                                    DexIfTransformer.this.usedAsObject = this.examineInvokeExpr((InvokeExpr)stmt.getRightOp());
                                    Debug.printDbg("use as object 2 = " + DexIfTransformer.this.usedAsObject);
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof LengthExpr) {
                                    DexIfTransformer.this.usedAsObject = true;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof BinopExpr) {
                                    DexIfTransformer.this.usedAsObject = false;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                            }

                            @Override
                            public void caseIdentityStmt(IdentityStmt stmt) {
                                if (stmt.getLeftOp() == DexIfTransformer.this.l) {
                                    Debug.printDbg("IMPOSSIBLE 0");
                                    System.exit(-1);
                                    DexIfTransformer.this.usedAsObject = DexIfTransformer.this.isObject(stmt.getRightOp().getType());
                                }
                            }

                            @Override
                            public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseReturnStmt(ReturnStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l && DexIfTransformer.this.isObject(body.getMethod().getReturnType());
                                Debug.printDbg(" [return stmt] " + stmt + " usedAsObject: " + DexIfTransformer.this.usedAsObject + ", return type: " + body.getMethod().getReturnType());
                                Debug.printDbg(" class: " + body.getMethod().getReturnType().getClass());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseThrowStmt(ThrowStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }
                        });
                        if (!this.doBreak) continue;
                        break;
                    }
                    if (!this.doBreak) continue;
                    break;
                }
                if (!this.doBreak) continue;
                break;
            }
            if (!this.usedAsObject) continue;
            List<Unit> defsOp1 = this.collectDefinitionsWithAliases(lOp1, localDefs, localUses, body);
            List<Unit> defsOp2 = this.collectDefinitionsWithAliases(lOp1, localDefs, localUses, body);
            defsOp1.addAll(defsOp2);
            for (Unit u : defsOp1) {
                this.replaceWithNull(u);
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    Unit use = pair.getUnit();
                    this.replaceWithNull(use);
                }
            }
        }
    }

    private boolean isObject(Type t) {
        return t instanceof RefLikeType;
    }

    private Set<IfStmt> getNullIfCandidates(Body body) {
        HashSet<IfStmt> candidates = new HashSet<IfStmt>();
        for (Unit u : body.getUnits()) {
            if (!(u instanceof IfStmt)) continue;
            ConditionExpr expr = (ConditionExpr)((IfStmt)u).getCondition();
            boolean isTargetIf = false;
            if ((expr instanceof EqExpr || expr instanceof NeExpr) && expr.getOp1() instanceof Local && expr.getOp2() instanceof Local) {
                isTargetIf = true;
            }
            if (!isTargetIf) continue;
            candidates.add((IfStmt)u);
            Debug.printDbg("[add if candidate: " + u);
        }
        return candidates;
    }

    private void replaceWithNull(Unit u) {
        AssignStmt s;
        Value v;
        if (u instanceof AssignStmt && (v = (s = (AssignStmt)u).getRightOp()) instanceof IntConstant && ((IntConstant)v).value == 0) {
            s.setRightOp(NullConstant.v());
            Debug.printDbg("[null] replacing with null in " + u);
            Debug.printDbg(" new u: " + u);
        }
    }
}

