/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.AnnotationEncodedSubValue;
import org.jf.dexlib.EncodedValue.ArrayEncodedValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.TypeEncodedValue;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import soot.Body;
import soot.MethodSource;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexClass;
import soot.dexpler.DexType;
import soot.dexpler.Util;

public class DexMethod {
    protected String name;
    protected DexClass dexClass;
    protected int accessFlags;
    protected List<String> thrownExceptions;
    protected DexType returnType;
    protected List<DexType> parameterTypes;
    private DexBody dexBody;

    public DexMethod(DexFile dexFile, ClassDataItem.EncodedMethod method, DexClass dexClass) {
        this.dexClass = dexClass;
        this.accessFlags = method.accessFlags;
        this.parameterTypes = new ArrayList<DexType>();
        this.name = method.method.getMethodName().getStringValue();
        Debug.printDbg("processing method '" + dexClass.name + " " + this.name + "'");
        this.thrownExceptions = new ArrayList<String>();
        class MyMethodDelegator
        implements AnnotationDirectoryItem.MethodAnnotationIteratorDelegate {
            MethodIdItem method;
            AnnotationSetItem methodAnnotations;

            public AnnotationSetItem getMethodAnnotations() {
                return this.methodAnnotations;
            }

            public void setMethodAnnotations(AnnotationSetItem methodAnnotations) {
                this.methodAnnotations = methodAnnotations;
            }

            public MyMethodDelegator(MethodIdItem method) {
                this.method = method;
            }

            @Override
            public void processMethodAnnotations(MethodIdItem method, AnnotationSetItem methodAnnotations) {
                if (method.equals(this.method)) {
                    this.setMethodAnnotations(methodAnnotations);
                }
            }
        }
        MyMethodDelegator delegate = new MyMethodDelegator(method.method);
        if (dexClass.annotations != null) {
            dexClass.annotations.iterateMethodAnnotations(delegate);
            AnnotationSetItem annotations = delegate.getMethodAnnotations();
            if (annotations != null) {
                for (AnnotationItem annotationItem : annotations.getAnnotations()) {
                    AnnotationEncodedSubValue value = annotationItem.getEncodedAnnotation();
                    for (EncodedValue encodedValue : value.values) {
                        if (!(encodedValue instanceof ArrayEncodedValue)) continue;
                        for (EncodedValue encodedValueSub : ((ArrayEncodedValue)encodedValue).values) {
                            if (!(encodedValueSub instanceof TypeEncodedValue)) continue;
                            TypeEncodedValue valueType = (TypeEncodedValue)encodedValueSub;
                            this.thrownExceptions.add(valueType.value.getTypeDescriptor());
                        }
                    }
                }
            }
        }
        if (method.method.getPrototype().getParameters() != null) {
            List<TypeIdItem> parameters = method.method.getPrototype().getParameters().getTypes();
            for (TypeIdItem t : parameters) {
                DexType type = new DexType(t);
                this.parameterTypes.add(type);
                dexClass.types.add(type);
            }
        }
        this.returnType = new DexType(method.method.getPrototype().getReturnType());
        dexClass.types.add(this.returnType);
        if (method.codeItem == null || method.codeItem.getInstructions() == null) {
            return;
        }
        DebugInfoItem debugInfo = method.codeItem.getDebugInfo();
        if (debugInfo != null) {
            for (Item item : debugInfo.getReferencedItems()) {
                if (!(item instanceof TypeIdItem)) continue;
                DexType type = new DexType((TypeIdItem)item);
                dexClass.types.add(type);
            }
        }
        this.dexBody = new DexBody(dexFile, method.codeItem, (RefType)DexType.toSoot(dexClass.getType()));
        for (DexType t : this.dexBody.usedTypes()) {
            dexClass.types.add(t);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.dexClass.getName() + "->" + this.name;
    }

    public DexClass getDexClass() {
        return this.dexClass;
    }

    public DexType getReturnType() {
        return this.returnType;
    }

    public int getModifiers() {
        return this.accessFlags;
    }

    public List<String> thrownExceptions() {
        return this.thrownExceptions;
    }

    public List<DexType> getParameterTypes() {
        return this.parameterTypes;
    }

    public SootMethod toSoot() {
        ArrayList<Type> parameters = new ArrayList<Type>();
        for (DexType t : this.parameterTypes) {
            parameters.add(t.toSoot());
        }
        ArrayList<SootClass> exceptions = new ArrayList<SootClass>();
        for (String exceptionName : this.thrownExceptions()) {
            String dottedName = Util.dottedClassName(exceptionName);
            exceptions.add(SootResolver.v().makeClassRef(dottedName));
        }
        SootMethod m = new SootMethod(this.name, parameters, this.returnType.toSoot(), this.accessFlags, exceptions);
        if (this.dexBody != null) {
            m.setSource(new MethodSource(){

                @Override
                public Body getBody(SootMethod m, String phaseName) {
                    m.setActiveBody(DexMethod.this.dexBody.jimplify(m));
                    return m.getActiveBody();
                }
            });
        }
        return m;
    }
}

