/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Immediate;
import soot.Unit;
import soot.Value;
import soot.dexpler.Debug;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.nullcheck.NullnessAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class DexNullArrayRefTransformer
extends BodyTransformer {
    public static DexNullArrayRefTransformer v() {
        return new DexNullArrayRefTransformer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        boolean isAlwaysNullBefore;
        Value base;
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body);
        ArrayList<Stmt> arrayRefs = new ArrayList<Stmt>();
        ArrayList<Stmt> lengthExprs = new ArrayList<Stmt>();
        for (Unit u : body.getUnits()) {
            AssignStmt ass;
            Value rightOp;
            Stmt s = (Stmt)u;
            if (s.containsArrayRef()) {
                arrayRefs.add(s);
                continue;
            }
            if (!(s instanceof AssignStmt) || !((rightOp = (ass = (AssignStmt)s).getRightOp()) instanceof LengthExpr)) continue;
            lengthExprs.add(s);
        }
        NullnessAnalysis na = new NullnessAnalysis(g);
        for (Stmt s : arrayRefs) {
            Debug.printDbg("statement contains arrayref: " + s);
            ArrayRef ar = s.getArrayRef();
            base = ar.getBase();
            isAlwaysNullBefore = na.isAlwaysNullBefore(s, (Immediate)base);
            Debug.printDbg("is always null: " + isAlwaysNullBefore);
            if (!isAlwaysNullBefore) continue;
            body.getUnits().swapWith(s, Jimple.v().newNopStmt());
        }
        for (Stmt s : lengthExprs) {
            Debug.printDbg("statement contains length expr: " + s);
            LengthExpr l = (LengthExpr)((AssignStmt)s).getRightOp();
            base = l.getOp();
            isAlwaysNullBefore = na.isAlwaysNullBefore(s, (Immediate)base);
            Debug.printDbg("is always null: " + isAlwaysNullBefore);
            if (!isAlwaysNullBefore) continue;
            body.getUnits().swapWith(s, Jimple.v().newNopStmt());
        }
    }
}

