/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.RefLikeType;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.dexpler.Debug;
import soot.dexpler.DexTransformer;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DexNullTransformer
extends DexTransformer {
    private boolean usedAsObject;
    private boolean doBreak = false;
    Local l = null;

    public static DexNullTransformer v() {
        return new DexNullTransformer();
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map options) {
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body);
        SmartLocalDefs localDefs = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        SimpleLocalUses localUses = new SimpleLocalUses(g, (LocalDefs)localDefs);
        for (Local loc : this.getNullCandidates(body)) {
            Unit use;
            Debug.printDbg("\n[null candidate] " + loc);
            this.usedAsObject = false;
            List<Unit> defs = this.collectDefinitionsWithAliases(loc, localDefs, localUses, body);
            for (Unit u : defs) {
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    Debug.printDbg("[use in u]: " + pair.getUnit());
                }
            }
            this.doBreak = false;
            for (Unit u : defs) {
                if (u instanceof AssignStmt) {
                    this.l = (Local)((AssignStmt)u).getLeftOp();
                } else if (u instanceof IdentityStmt) {
                    this.l = (Local)((IdentityStmt)u).getLeftOp();
                } else if (u instanceof IfStmt) {
                    throw new RuntimeException("ERROR: def can not be something else than Assign or Identity statement! (def: " + u + " class: " + u.getClass() + "");
                }
                Debug.printDbg("    target local: " + this.l + " (Unit: " + u + " )");
                u.apply(new AbstractStmtSwitch(){

                    @Override
                    public void caseAssignStmt(AssignStmt stmt) {
                        Value r = stmt.getRightOp();
                        if (r instanceof FieldRef) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((FieldRef)r).getFieldRef().type());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof ArrayRef) {
                            ArrayRef ar = (ArrayRef)r;
                            if (ar.getType() instanceof UnknownType) {
                                DexNullTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                            } else {
                                DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(ar.getType());
                            }
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof StringConstant || r instanceof NewExpr || r instanceof NewArrayExpr) {
                            DexNullTransformer.this.usedAsObject = true;
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof CastExpr) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((CastExpr)r).getCastType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof InvokeExpr) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((InvokeExpr)r).getType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof LengthExpr) {
                            DexNullTransformer.this.usedAsObject = false;
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                        if (r instanceof Local) {
                            // empty if block
                        }
                    }

                    @Override
                    public void caseIdentityStmt(IdentityStmt stmt) {
                        if (stmt.getLeftOp() == DexNullTransformer.this.l) {
                            DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(stmt.getRightOp().getType());
                            DexNullTransformer.this.doBreak = true;
                            return;
                        }
                    }
                });
                if (this.doBreak) break;
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    use = pair.getUnit();
                    Debug.printDbg("    use: " + use);
                    use.apply(new AbstractStmtSwitch(){

                        private boolean examineInvokeExpr(InvokeExpr e) {
                            AbstractInstanceInvokeExpr aiiexpr;
                            Value b;
                            List<Value> args = e.getArgs();
                            List argTypes = e.getMethodRef().parameterTypes();
                            assert (args.size() == argTypes.size());
                            for (int i = 0; i < args.size(); ++i) {
                                if (args.get(i) != DexNullTransformer.this.l || !DexNullTransformer.this.isObject((Type)argTypes.get(i))) continue;
                                return true;
                            }
                            SootMethodRef sm = e.getMethodRef();
                            return !sm.isStatic() && e instanceof AbstractInvokeExpr && (b = (aiiexpr = (AbstractInstanceInvokeExpr)e).getBase()) == DexNullTransformer.this.l;
                        }

                        @Override
                        public void caseInvokeStmt(InvokeStmt stmt) {
                            InvokeExpr e = stmt.getInvokeExpr();
                            DexNullTransformer.this.usedAsObject = this.examineInvokeExpr(e);
                            Debug.printDbg("use as object = " + DexNullTransformer.this.usedAsObject);
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseAssignStmt(AssignStmt stmt) {
                            Value left = stmt.getLeftOp();
                            Value r = stmt.getRightOp();
                            if (left instanceof ArrayRef && ((ArrayRef)left).getIndex() == DexNullTransformer.this.l) {
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (stmt.getRightOp() == DexNullTransformer.this.l) {
                                Value l = stmt.getLeftOp();
                                if (l instanceof StaticFieldRef && DexNullTransformer.this.isObject(((StaticFieldRef)l).getFieldRef().type())) {
                                    DexNullTransformer.this.usedAsObject = true;
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                                if (l instanceof InstanceFieldRef && DexNullTransformer.this.isObject(((InstanceFieldRef)l).getFieldRef().type())) {
                                    DexNullTransformer.this.usedAsObject = true;
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                                if (l instanceof ArrayRef) {
                                    Type aType = ((ArrayRef)l).getType();
                                    if (aType instanceof UnknownType) {
                                        DexNullTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                    } else {
                                        DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(aType);
                                    }
                                    DexNullTransformer.this.doBreak = true;
                                    return;
                                }
                            }
                            if (r instanceof FieldRef) {
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof ArrayRef) {
                                ArrayRef ar = (ArrayRef)r;
                                if (ar.getBase() == DexNullTransformer.this.l) {
                                    DexNullTransformer.this.usedAsObject = true;
                                } else {
                                    DexNullTransformer.this.usedAsObject = false;
                                }
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof StringConstant || r instanceof NewExpr) {
                                Debug.printDbg("NOT POSSIBLE StringConstant or NewExpr! " + stmt);
                                System.exit(-1);
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof NewArrayExpr) {
                                DexNullTransformer.this.usedAsObject = false;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof CastExpr) {
                                DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(((CastExpr)r).getCastType());
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof InvokeExpr) {
                                DexNullTransformer.this.usedAsObject = this.examineInvokeExpr((InvokeExpr)stmt.getRightOp());
                                Debug.printDbg("use as object 2 = " + DexNullTransformer.this.usedAsObject);
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof LengthExpr) {
                                DexNullTransformer.this.usedAsObject = true;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                            if (r instanceof BinopExpr) {
                                DexNullTransformer.this.usedAsObject = false;
                                DexNullTransformer.this.doBreak = true;
                                return;
                            }
                        }

                        @Override
                        public void caseIdentityStmt(IdentityStmt stmt) {
                            if (stmt.getLeftOp() == DexNullTransformer.this.l) {
                                Debug.printDbg("IMPOSSIBLE 0");
                                System.exit(-1);
                                DexNullTransformer.this.usedAsObject = DexNullTransformer.this.isObject(stmt.getRightOp().getType());
                            }
                        }

                        @Override
                        public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseReturnStmt(ReturnStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l && DexNullTransformer.this.isObject(body.getMethod().getReturnType());
                            Debug.printDbg(" [return stmt] " + stmt + " usedAsObject: " + DexNullTransformer.this.usedAsObject + ", return type: " + body.getMethod().getReturnType());
                            Debug.printDbg(" class: " + body.getMethod().getReturnType().getClass());
                            DexNullTransformer.this.doBreak = true;
                        }

                        @Override
                        public void caseThrowStmt(ThrowStmt stmt) {
                            DexNullTransformer.this.usedAsObject = stmt.getOp() == DexNullTransformer.this.l;
                            DexNullTransformer.this.doBreak = true;
                        }
                    });
                    if (!this.doBreak) continue;
                    break;
                }
                if (!this.doBreak) continue;
                break;
            }
            if (!this.usedAsObject) continue;
            for (Unit u : defs) {
                this.replaceWithNull(u);
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    use = pair.getUnit();
                    this.replaceWithNull(use);
                }
            }
        }
    }

    private boolean isObject(Type t) {
        return t instanceof RefLikeType;
    }

    private Set<Local> getNullCandidates(Body body) {
        HashSet<Local> candidates = new HashSet<Local>();
        for (Unit u : body.getUnits()) {
            ConditionExpr expr;
            if (u instanceof AssignStmt) {
                AssignStmt a = (AssignStmt)u;
                if (!(a.getLeftOp() instanceof Local)) continue;
                Local l = (Local)a.getLeftOp();
                Value r = a.getRightOp();
                if (!(r instanceof IntConstant) || ((IntConstant)r).value != 0) continue;
                candidates.add(l);
                Debug.printDbg("[add null candidate: " + u);
                continue;
            }
            if (!(u instanceof IfStmt) || !this.isZeroComparison(expr = (ConditionExpr)((IfStmt)u).getCondition()) || !(expr.getOp1() instanceof Local)) continue;
            candidates.add((Local)expr.getOp1());
            Debug.printDbg("[add null candidate if: " + u);
        }
        return candidates;
    }

    private void replaceWithNull(Unit u) {
        AssignStmt s;
        Value v;
        if (u instanceof IfStmt) {
            ConditionExpr expr = (ConditionExpr)((IfStmt)u).getCondition();
            if (this.isZeroComparison(expr)) {
                expr.setOp2(NullConstant.v());
                Debug.printDbg("[null] replacing with null in " + u);
                Debug.printDbg(" new u: " + u);
            }
        } else if (u instanceof AssignStmt && (v = (s = (AssignStmt)u).getRightOp()) instanceof IntConstant && ((IntConstant)v).value == 0) {
            s.setRightOp(NullConstant.v());
            Debug.printDbg("[null] replacing with null in " + u);
            Debug.printDbg(" new u: " + u);
        }
    }

    private boolean isZeroComparison(ConditionExpr expr) {
        return expr.getOp2() instanceof IntConstant && ((IntConstant)expr.getOp2()).value == 0 && (expr instanceof EqExpr || expr instanceof NeExpr);
    }
}

