/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import soot.SootClass;
import soot.SootResolver;
import soot.dexpler.DexClass;
import soot.dexpler.DexField;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.DexlibWrapper;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;

public class DexResolver {
    private static Map<File, DexlibWrapper> cache = new TreeMap<File, DexlibWrapper>();

    public static IInitialResolver.Dependencies resolveFromFile(File file, String className, SootClass sc) {
        DexClass c;
        DexlibWrapper wrapper = cache.get(file);
        if (wrapper == null) {
            wrapper = new DexlibWrapper(file);
            cache.put(file, wrapper);
            wrapper.initialize();
        }
        if ((c = wrapper.getClass(className)) == null) {
            throw new RuntimeException("Class " + className + " not found at " + file.getPath());
        }
        sc.setModifiers(c.getModifiers());
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        for (String interfaceName : c.getInterfaces()) {
            String interfaceClassName = Util.dottedClassName(interfaceName);
            SootClass interfaceClass = SootResolver.v().makeClassRef(interfaceClassName);
            sc.addInterface(interfaceClass);
            deps.typesToHierarchy.add(interfaceClass.getType());
        }
        String superClassName = Util.dottedClassName(c.getSuperclass());
        SootClass superClass = SootResolver.v().makeClassRef(superClassName);
        sc.setSuperclass(superClass);
        deps.typesToHierarchy.add(superClass.getType());
        for (DexType t : c.getAllTypes()) {
            deps.typesToSignature.add(t.toSoot());
        }
        for (DexField f : c.getDeclaredFields()) {
            sc.addField(f.toSoot());
        }
        for (DexMethod m : c.getDeclaredMethods()) {
            sc.addMethod(m.toSoot());
        }
        return deps;
    }

    public static void reset() {
        cache.clear();
    }
}

