/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import org.jf.dexlib.TypeIdItem;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.UnknownType;
import soot.VoidType;
import soot.dexpler.Util;

public class DexType {
    protected String name;
    protected TypeIdItem type;

    public DexType(TypeIdItem type) {
        this.type = type;
        this.name = type.getConciseIdentity();
    }

    public String getName() {
        return this.name;
    }

    public boolean overwriteEquivalent(DexType field) {
        return this.name.equals(field.getName());
    }

    public TypeIdItem getType() {
        return this.type;
    }

    public Type toSoot() {
        return DexType.toSoot(this.type.getTypeDescriptor(), 0);
    }

    public static Type toSoot(TypeIdItem type) {
        return DexType.toSoot(type.getTypeDescriptor(), 0);
    }

    public static boolean isWide(TypeIdItem type) {
        String t = type.getTypeDescriptor();
        return t.startsWith("J") || t.startsWith("D");
    }

    private static Type toSoot(String typeDescriptor, int pos) {
        Type type;
        char typeDesignator = typeDescriptor.charAt(pos);
        switch (typeDesignator) {
            case 'Z': {
                type = BooleanType.v();
                break;
            }
            case 'B': {
                type = ByteType.v();
                break;
            }
            case 'S': {
                type = ShortType.v();
                break;
            }
            case 'C': {
                type = CharType.v();
                break;
            }
            case 'I': {
                type = IntType.v();
                break;
            }
            case 'J': {
                type = LongType.v();
                break;
            }
            case 'F': {
                type = FloatType.v();
                break;
            }
            case 'D': {
                type = DoubleType.v();
                break;
            }
            case 'L': {
                type = RefType.v(Util.dottedClassName(typeDescriptor));
                break;
            }
            case 'V': {
                type = VoidType.v();
                break;
            }
            case '[': {
                type = DexType.toSoot(typeDescriptor, pos + 1).makeArrayType();
                break;
            }
            default: {
                type = UnknownType.v();
            }
        }
        return type;
    }

    public String toString() {
        return this.name;
    }
}

