/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import soot.ArrayType;
import soot.PrimType;
import soot.Scene;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;
import soot.dexpler.Debug;
import soot.dexpler.DexClass;
import soot.dexpler.DexType;
import soot.dexpler.Util;

public class DexlibWrapper {
    private DexFile dexFile;
    private Map<String, ClassDefItem> dexClasses;
    private Map<String, DexClass> classesByName;
    private static final Set<String> systemAnnotationNames;
    private final File inputDexFile;

    public DexlibWrapper(File inputDexFile) {
        this.inputDexFile = inputDexFile;
    }

    public void initialize() {
        this.dexClasses = new HashMap<String, ClassDefItem>();
        this.classesByName = new HashMap<String, DexClass>();
        try {
            this.dexFile = new DexFile(this.inputDexFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        for (ClassDefItem defItem : this.dexFile.ClassDefsSection.getItems()) {
            this.dexClasses.put(Util.dottedClassName(defItem.getClassType().getTypeDescriptor()), defItem);
        }
        for (TypeIdItem t : this.dexFile.TypeIdsSection.getItems()) {
            DexType dt = new DexType(t);
            Type st = dt.toSoot();
            if (st instanceof ArrayType) {
                st = ((ArrayType)st).baseType;
            }
            String sootTypeName = st.toString();
            if (Scene.v().containsClass(sootTypeName) || st instanceof PrimType || st instanceof VoidType || systemAnnotationNames.contains(sootTypeName)) continue;
            SootResolver.v().makeClassRef(sootTypeName);
            SootResolver.v().resolveClass(sootTypeName, 1);
        }
        for (StringIdItem i : this.dexFile.StringIdsSection.getItems()) {
            Debug.printDbg("String: " + i);
        }
    }

    public DexClass getClass(String className) {
        DexClass dexClass;
        if (Util.isByteCodeClassName(className)) {
            className = Util.dottedClassName(className);
        }
        if ((dexClass = this.classesByName.get(className)) != null) {
            return dexClass;
        }
        ClassDefItem defItem = this.dexClasses.get(className);
        if (defItem != null) {
            DexClass newDexClass = new DexClass(defItem);
            this.classesByName.put(className, newDexClass);
            return newDexClass;
        }
        return null;
    }

    public Map<String, ClassDefItem> getDexClasses() {
        return this.dexClasses;
    }

    static {
        HashSet<String> systemAnnotationNamesModifiable = new HashSet<String>();
        systemAnnotationNamesModifiable.add("dalvik.annotation.AnnotationDefault");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingMethod");
        systemAnnotationNamesModifiable.add("dalvik.annotation.InnerClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.MemberClasses");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Signature");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Throws");
        systemAnnotationNames = Collections.unmodifiableSet(systemAnnotationNamesModifiable);
    }
}

