/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Arrays;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootField;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dexpler.Debug;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;

public class Util {
    public static String dottedClassName(String typeDescriptor) {
        int idx;
        if (!Util.isByteCodeClassName(typeDescriptor)) {
            int idx2;
            String t = typeDescriptor;
            for (idx2 = 0; idx2 < t.length() && t.charAt(idx2) == '['; ++idx2) {
            }
            String c = t.substring(idx2);
            if (c.length() == 1 && (c.startsWith("I") || c.startsWith("B") || c.startsWith("C") || c.startsWith("S") || c.startsWith("J") || c.startsWith("D") || c.startsWith("F") || c.startsWith("Z"))) {
                return Util.getType(t).toString();
            }
            throw new IllegalArgumentException("typeDescriptor is not a class typedescriptor: '" + typeDescriptor + "'");
        }
        String t = typeDescriptor;
        for (idx = 0; idx < t.length() && t.charAt(idx) == '['; ++idx) {
        }
        String className = typeDescriptor.substring(idx);
        className = className.substring(className.indexOf(76) + 1, className.indexOf(59));
        className = className.replace('/', '.');
        return className;
    }

    public static Type getType(String type) {
        int idx = 0;
        int arraySize = 0;
        Type returnType = null;
        boolean notFound = true;
        block13: while (idx < type.length() && notFound) {
            switch (type.charAt(idx)) {
                case '[': {
                    while (idx < type.length() && type.charAt(idx) == '[') {
                        ++arraySize;
                        ++idx;
                    }
                    continue block13;
                }
                case 'L': {
                    String objectName = type.replaceAll("^[^L]*L", "").replaceAll(";$", "");
                    returnType = RefType.v(objectName.replace("/", "."));
                    notFound = false;
                    break;
                }
                case 'J': {
                    returnType = LongType.v();
                    notFound = false;
                    break;
                }
                case 'S': {
                    returnType = ShortType.v();
                    notFound = false;
                    break;
                }
                case 'D': {
                    returnType = DoubleType.v();
                    notFound = false;
                    break;
                }
                case 'I': {
                    returnType = IntType.v();
                    notFound = false;
                    break;
                }
                case 'F': {
                    returnType = FloatType.v();
                    notFound = false;
                    break;
                }
                case 'B': {
                    returnType = ByteType.v();
                    notFound = false;
                    break;
                }
                case 'C': {
                    returnType = CharType.v();
                    notFound = false;
                    break;
                }
                case 'V': {
                    returnType = VoidType.v();
                    notFound = false;
                    break;
                }
                case 'Z': {
                    returnType = BooleanType.v();
                    notFound = false;
                    break;
                }
                default: {
                    Debug.printDbg("unknown type: '" + type + "'");
                    Thread.dumpStack();
                    System.exit(-1);
                }
            }
            ++idx;
        }
        if (arraySize > 0) {
            returnType = ArrayType.v(returnType, arraySize);
        }
        Debug.printDbg("casttype i:" + returnType);
        return returnType;
    }

    public static boolean isByteCodeClassName(String className) {
        return !(!className.startsWith("L") && !className.startsWith("[") || !className.endsWith(";") || className.indexOf(47) == -1 && className.indexOf(46) != -1);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean isFloatLike(Type t) {
        return t.equals(FloatType.v()) || t.equals(DoubleType.v()) || t.equals(RefType.v("java.lang.Float")) || t.equals(RefType.v("java.lang.Double"));
    }

    public static void addRuntimeExceptionAfterUnit(Body b, Unit u, String m) {
        Local l = Jimple.v().newLocal("myException", RefType.v("java.lang.RuntimeException"));
        b.getLocals().add(l);
        ArrayList<Stmt> newUnits = new ArrayList<Stmt>();
        AssignStmt u1 = Jimple.v().newAssignStmt(l, Jimple.v().newNewExpr(RefType.v("java.lang.RuntimeException")));
        InvokeStmt u2 = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l, Scene.v().getMethod("<java.lang.RuntimeException: void <init(java.lang.String)>").makeRef(), StringConstant.v(m)));
        ThrowStmt u3 = Jimple.v().newThrowStmt(l);
        newUnits.add(u1);
        newUnits.add(u2);
        newUnits.add(u3);
        b.getUnits().insertBefore((Unit)((Object)newUnits), u);
    }

    public static void addConstantTags(Body b) {
        for (Unit u : b.getUnits()) {
            Stmt s = (Stmt)u;
            if (!(s instanceof AssignStmt) || !s.containsFieldRef()) continue;
            AssignStmt ass = (AssignStmt)s;
            Value r = ass.getRightOp();
            Value l = ass.getLeftOp();
            if (!(l instanceof FieldRef) || !(r instanceof Constant)) continue;
            FieldRef fr = ass.getFieldRef();
            SootField sf = fr.getField();
            System.out.println("sootfield: " + sf + " modifiers: " + sf.getModifiers());
            System.out.println("final: 16");
            if (!sf.isFinal()) continue;
            Util.addConstantTag(sf, (Constant)r);
        }
    }

    private static void addConstantTag(SootField sf, Constant c) {
        System.out.println("add constant tag: ");
        Type ft = sf.getType();
        if (c instanceof IntConstant) {
            sf.addTag(new IntegerConstantValueTag(((IntConstant)c).value));
        } else if (c instanceof LongConstant) {
            sf.addTag(new LongConstantValueTag(((LongConstant)c).value));
        } else if (c instanceof DoubleConstant) {
            sf.addTag(new DoubleConstantValueTag(((DoubleConstant)c).value));
        } else if (c instanceof FloatConstant) {
            sf.addTag(new FloatConstantValueTag(((FloatConstant)c).value));
        } else if (c instanceof StringConstant) {
            sf.addTag(new StringConstantValueTag(((StringConstant)c).value));
        }
    }
}

