/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction12x;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import soot.Local;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;

public class ArrayLengthInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ArrayLengthInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction12x)) {
            throw new IllegalArgumentException("Expected Instruction12x but got: " + this.instruction.getClass());
        }
        Instruction12x lengthOfArrayInstruction = (Instruction12x)this.instruction;
        int dest = lengthOfArrayInstruction.getRegisterA();
        Local arrayReference = body.getRegisterLocal(lengthOfArrayInstruction.getRegisterB());
        LengthExpr lengthExpr = Jimple.v().newLengthExpr(arrayReference);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), lengthExpr);
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }
}

