/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction12x;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import soot.Local;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.TaggedInstruction;
import soot.dexpler.tags.DoubleOpTag;
import soot.dexpler.tags.FloatOpTag;
import soot.dexpler.tags.IntOpTag;
import soot.dexpler.tags.LongOpTag;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;

public class Binop2addrInstruction
extends TaggedInstruction {
    Value expr = null;
    AssignStmt assign = null;

    public Binop2addrInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction12x)) {
            throw new IllegalArgumentException("Expected Instruction12x but got: " + this.instruction.getClass());
        }
        Instruction12x binOp2AddrInstr = (Instruction12x)this.instruction;
        int dest = binOp2AddrInstr.getRegisterA();
        Local source1 = body.getRegisterLocal(binOp2AddrInstr.getRegisterA());
        Local source2 = body.getRegisterLocal(binOp2AddrInstr.getRegisterB());
        this.expr = this.getExpression(source1, source2);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), this.expr);
        this.assign.addTag(this.getTag());
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    private Value getExpression(Local source1, Local source2) {
        switch (this.instruction.opcode) {
            case ADD_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newAddExpr(source1, source2);
            }
            case ADD_FLOAT_2ADDR: {
                this.setTag(new FloatOpTag());
                return Jimple.v().newAddExpr(source1, source2);
            }
            case ADD_DOUBLE_2ADDR: {
                this.setTag(new DoubleOpTag());
                return Jimple.v().newAddExpr(source1, source2);
            }
            case ADD_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newAddExpr(source1, source2);
            }
            case SUB_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newSubExpr(source1, source2);
            }
            case SUB_FLOAT_2ADDR: {
                this.setTag(new FloatOpTag());
                return Jimple.v().newSubExpr(source1, source2);
            }
            case SUB_DOUBLE_2ADDR: {
                this.setTag(new DoubleOpTag());
                return Jimple.v().newSubExpr(source1, source2);
            }
            case SUB_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newSubExpr(source1, source2);
            }
            case MUL_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newMulExpr(source1, source2);
            }
            case MUL_FLOAT_2ADDR: {
                this.setTag(new FloatOpTag());
                return Jimple.v().newMulExpr(source1, source2);
            }
            case MUL_DOUBLE_2ADDR: {
                this.setTag(new DoubleOpTag());
                return Jimple.v().newMulExpr(source1, source2);
            }
            case MUL_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newMulExpr(source1, source2);
            }
            case DIV_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newDivExpr(source1, source2);
            }
            case DIV_FLOAT_2ADDR: {
                this.setTag(new FloatOpTag());
                return Jimple.v().newDivExpr(source1, source2);
            }
            case DIV_DOUBLE_2ADDR: {
                this.setTag(new DoubleOpTag());
                return Jimple.v().newDivExpr(source1, source2);
            }
            case DIV_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newDivExpr(source1, source2);
            }
            case REM_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newRemExpr(source1, source2);
            }
            case REM_FLOAT_2ADDR: {
                this.setTag(new FloatOpTag());
                return Jimple.v().newRemExpr(source1, source2);
            }
            case REM_DOUBLE_2ADDR: {
                this.setTag(new DoubleOpTag());
                return Jimple.v().newRemExpr(source1, source2);
            }
            case REM_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newRemExpr(source1, source2);
            }
            case AND_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newAndExpr(source1, source2);
            }
            case AND_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newAndExpr(source1, source2);
            }
            case OR_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newOrExpr(source1, source2);
            }
            case OR_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newOrExpr(source1, source2);
            }
            case XOR_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newXorExpr(source1, source2);
            }
            case XOR_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newXorExpr(source1, source2);
            }
            case SHL_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newShlExpr(source1, source2);
            }
            case SHL_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newShlExpr(source1, source2);
            }
            case SHR_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newShrExpr(source1, source2);
            }
            case SHR_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newShrExpr(source1, source2);
            }
            case USHR_LONG_2ADDR: {
                this.setTag(new LongOpTag());
                return Jimple.v().newUshrExpr(source1, source2);
            }
            case USHR_INT_2ADDR: {
                this.setTag(new IntOpTag());
                return Jimple.v().newUshrExpr(source1, source2);
            }
        }
        throw new RuntimeException("Invalid Opcode: " + (Object)((Object)this.instruction.opcode));
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }
}

