/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction22b;
import org.jf.dexlib.Code.Format.Instruction22s;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import soot.Local;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.TaggedInstruction;
import soot.dexpler.tags.IntOpTag;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;

public class BinopLitInstruction
extends TaggedInstruction {
    Value expr = null;
    AssignStmt assign = null;

    public BinopLitInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction22s) && !(this.instruction instanceof Instruction22b)) {
            throw new IllegalArgumentException("Expected Instruction22s or Instruction22b but got: " + this.instruction.getClass());
        }
        LiteralInstruction binOpLitInstr = (LiteralInstruction)((Object)this.instruction);
        int dest = ((TwoRegisterInstruction)((Object)this.instruction)).getRegisterA();
        int source = ((TwoRegisterInstruction)((Object)this.instruction)).getRegisterB();
        Local source1 = body.getRegisterLocal(source);
        IntConstant constant = IntConstant.v((int)binOpLitInstr.getLiteral());
        this.expr = this.getExpression(source1, constant);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), this.expr);
        this.assign.addTag(this.getTag());
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    private Value getExpression(Local source1, Value source2) {
        switch (this.instruction.opcode) {
            case ADD_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case ADD_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newAddExpr(source1, source2);
            }
            case RSUB_INT: {
                this.setTag(new IntOpTag());
            }
            case RSUB_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newSubExpr(source1, source2);
            }
            case MUL_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case MUL_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newMulExpr(source1, source2);
            }
            case DIV_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case DIV_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newDivExpr(source1, source2);
            }
            case REM_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case REM_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newRemExpr(source1, source2);
            }
            case AND_INT_LIT8: {
                this.setTag(new IntOpTag());
            }
            case AND_INT_LIT16: {
                this.setTag(new IntOpTag());
                return Jimple.v().newAndExpr(source1, source2);
            }
            case OR_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case OR_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newOrExpr(source1, source2);
            }
            case XOR_INT_LIT16: {
                this.setTag(new IntOpTag());
            }
            case XOR_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newXorExpr(source1, source2);
            }
            case SHL_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newShlExpr(source1, source2);
            }
            case SHR_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newShrExpr(source1, source2);
            }
            case USHR_INT_LIT8: {
                this.setTag(new IntOpTag());
                return Jimple.v().newUshrExpr(source1, source2);
            }
        }
        throw new RuntimeException("Invalid Opcode: " + (Object)((Object)this.instruction.opcode));
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }
}

