/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction23x;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import soot.DoubleType;
import soot.FloatType;
import soot.Local;
import soot.LongType;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.TaggedInstruction;
import soot.dexpler.tags.DoubleOpTag;
import soot.dexpler.tags.FloatOpTag;
import soot.dexpler.tags.LongOpTag;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.Jimple;

public class CmpInstruction
extends TaggedInstruction {
    AssignStmt assign = null;
    Expr cmpExpr = null;
    Type type = null;

    public CmpInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction23x)) {
            throw new IllegalArgumentException("Expected Instruction23x but got: " + this.instruction.getClass());
        }
        Instruction23x cmpInstr = (Instruction23x)this.instruction;
        int dest = cmpInstr.getRegisterA();
        Local first = body.getRegisterLocal(cmpInstr.getRegisterB());
        Local second = body.getRegisterLocal(cmpInstr.getRegisterC());
        switch (this.instruction.opcode) {
            case CMPL_DOUBLE: {
                this.setTag(new DoubleOpTag());
                this.type = DoubleType.v();
                this.cmpExpr = Jimple.v().newCmplExpr(first, second);
                break;
            }
            case CMPL_FLOAT: {
                this.setTag(new FloatOpTag());
                this.type = FloatType.v();
                this.cmpExpr = Jimple.v().newCmplExpr(first, second);
                break;
            }
            case CMPG_DOUBLE: {
                this.setTag(new DoubleOpTag());
                this.type = DoubleType.v();
                this.cmpExpr = Jimple.v().newCmpgExpr(first, second);
                break;
            }
            case CMPG_FLOAT: {
                this.setTag(new FloatOpTag());
                this.type = FloatType.v();
                this.cmpExpr = Jimple.v().newCmpgExpr(first, second);
                break;
            }
            case CMP_LONG: {
                this.setTag(new LongOpTag());
                this.type = LongType.v();
                this.cmpExpr = Jimple.v().newCmpExpr(first, second);
                break;
            }
            default: {
                System.out.println("no opcode for CMP: 0x" + Integer.toHexString(this.instruction.opcode.value));
                System.exit(-1);
                this.cmpExpr = Jimple.v().newCmpExpr(first, second);
            }
        }
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), this.cmpExpr);
        this.assign.addTag(this.getTag());
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean overridesRegister(int register) {
        ThreeRegisterInstruction i = (ThreeRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }
}

