/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.TypeIdItem;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.Jimple;

public class ConstClassInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ConstClassInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction21c)) {
            throw new IllegalArgumentException("Expected Instruction21c but got: " + this.instruction.getClass());
        }
        InstructionWithReference constClass = (InstructionWithReference)this.instruction;
        TypeIdItem tidi = (TypeIdItem)constClass.getReferencedItem();
        String type = tidi.toString().split(" ")[1];
        if (type.startsWith("L") && type.endsWith(";")) {
            type = type.replaceAll("^L", "").replaceAll(";$", "");
        }
        int dest = ((SingleRegisterInstruction)((Object)this.instruction)).getRegisterA();
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), ClassConstant.v(type));
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean overridesRegister(int register) {
        SingleRegisterInstruction i = (SingleRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public Set<DexType> introducedTypes() {
        InstructionWithReference i = (InstructionWithReference)this.instruction;
        HashSet<DexType> types = new HashSet<DexType>();
        types.add(new DexType((TypeIdItem)i.getReferencedItem()));
        return types;
    }
}

