/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;

public class ConstInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ConstInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        int dest = ((SingleRegisterInstruction)((Object)this.instruction)).getRegisterA();
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), this.getConstant(dest, body));
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    private Constant getConstant(int dest, DexBody body) {
        long literal = ((LiteralInstruction)((Object)this.instruction)).getLiteral();
        boolean isFloatingPoint = false;
        switch (this.instruction.opcode) {
            case CONST: 
            case CONST_4: 
            case CONST_16: {
                if (isFloatingPoint) {
                    return FloatConstant.v(Float.intBitsToFloat((int)literal));
                }
                return IntConstant.v((int)literal);
            }
            case CONST_HIGH16: {
                return IntConstant.v((int)literal << 16);
            }
            case CONST_WIDE_HIGH16: {
                return LongConstant.v(literal << 48);
            }
            case CONST_WIDE: 
            case CONST_WIDE_16: 
            case CONST_WIDE_32: {
                if (isFloatingPoint) {
                    return DoubleConstant.v(Double.longBitsToDouble(literal));
                }
                return LongConstant.v(literal);
            }
        }
        throw new IllegalArgumentException("Expected a const or a const-wide instruction, got neither.");
    }

    @Override
    boolean overridesRegister(int register) {
        SingleRegisterInstruction i = (SingleRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }
}

