/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.Collections;
import java.util.Set;
import org.jf.dexlib.Code.Instruction;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.Type;
import soot.Unit;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.tagkit.Host;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLineNumberTag;

public abstract class DexlibAbstractInstruction {
    protected int lineNumber = -1;
    protected Instruction instruction;
    protected int codeAddress;
    protected Unit unit;
    protected DexBody body = null;
    protected Type[] opUnType = new Type[]{IntType.v(), IntType.v(), LongType.v(), LongType.v(), FloatType.v(), DoubleType.v(), IntType.v(), IntType.v(), IntType.v(), LongType.v(), LongType.v(), LongType.v(), FloatType.v(), FloatType.v(), FloatType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), IntType.v(), IntType.v(), IntType.v()};
    protected Type[] resUnType = new Type[]{IntType.v(), IntType.v(), LongType.v(), LongType.v(), FloatType.v(), DoubleType.v(), LongType.v(), FloatType.v(), DoubleType.v(), IntType.v(), FloatType.v(), DoubleType.v(), IntType.v(), LongType.v(), DoubleType.v(), IntType.v(), LongType.v(), FloatType.v(), IntType.v(), IntType.v(), IntType.v()};
    protected Type[] resBinType = new Type[]{IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v()};
    protected Type[] op1BinType = new Type[]{IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v()};
    protected Type[] op2BinType = new Type[]{IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), IntType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), LongType.v(), IntType.v(), IntType.v(), IntType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), FloatType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v(), DoubleType.v()};

    public Instruction getInstruction() {
        return this.instruction;
    }

    public abstract void jimplify(DexBody var1);

    int movesRegister(int register) {
        return -1;
    }

    int movesToRegister(int register) {
        return -1;
    }

    boolean overridesRegister(int register) {
        return false;
    }

    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        return false;
    }

    public Set<DexType> introducedTypes() {
        return Collections.emptySet();
    }

    public DexlibAbstractInstruction(Instruction instruction, int codeAddress) {
        this.instruction = instruction;
        this.codeAddress = codeAddress;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    protected void tagWithLineNumber(Host host) {
        if (this.lineNumber != -1) {
            host.addTag(new LineNumberTag(this.lineNumber));
            host.addTag(new SourceLineNumberTag(this.lineNumber));
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    protected void setUnit(Unit u) {
        this.unit = u;
    }

    public abstract void getConstraint(IDalvikTyper var1);
}

