/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Format.Instruction23x;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.FieldIdItem;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootResolver;
import soot.Type;
import soot.UnknownType;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.ConcreteRef;
import soot.jimple.Jimple;

public abstract class FieldInstruction
extends DexlibAbstractInstruction {
    public FieldInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    protected SootFieldRef getStaticSootFieldRef(FieldIdItem item) {
        return this.getSootFieldRef(item, true);
    }

    protected SootFieldRef getSootFieldRef(FieldIdItem item) {
        return this.getSootFieldRef(item, false);
    }

    private SootFieldRef getSootFieldRef(FieldIdItem item, boolean isStatic) {
        String className = Util.dottedClassName(item.getContainingClass().getTypeDescriptor());
        SootClass sc = SootResolver.v().makeClassRef(className);
        return Scene.v().makeFieldRef(sc, item.getFieldName().getStringValue(), DexType.toSoot(item.getFieldType()), isStatic);
    }

    protected AssignStmt getAssignStmt(DexBody body, Local sourceValue, ConcreteRef instanceField) {
        AssignStmt assign = Jimple.v().newAssignStmt(instanceField, sourceValue);
        return assign;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        return this.sourceRegister() == register && Util.isFloatLike(this.getTargetType(body));
    }

    private int sourceRegister() {
        if (this.instruction instanceof Instruction23x) {
            return ((Instruction23x)this.instruction).getRegisterA();
        }
        if (this.instruction instanceof Instruction22c) {
            return ((Instruction22c)this.instruction).getRegisterA();
        }
        if (this.instruction instanceof Instruction21c) {
            return ((Instruction21c)this.instruction).getRegisterA();
        }
        throw new RuntimeException("Instruction is not a instance, array or static op");
    }

    protected Type getTargetType(DexBody body) {
        return UnknownType.v();
    }

    @Override
    public Set<DexType> introducedTypes() {
        HashSet<DexType> types = new HashSet<DexType>();
        if (!(this.instruction instanceof InstructionWithReference)) {
            return types;
        }
        InstructionWithReference i = (InstructionWithReference)this.instruction;
        FieldIdItem field = (FieldIdItem)i.getReferencedItem();
        types.add(new DexType(field.getFieldType()));
        types.add(new DexType(field.getContainingClass()));
        return types;
    }
}

