/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Format.Instruction31t;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.ShortType;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.NewArrayInstruction;
import soot.dexpler.instructions.PseudoInstruction;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NumericConstant;
import soot.jimple.Stmt;

public class FillArrayDataInstruction
extends PseudoInstruction {
    public FillArrayDataInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction31t)) {
            throw new IllegalArgumentException("Expected Instruction31t but got: " + this.instruction.getClass());
        }
        Instruction31t fillArrayInstr = (Instruction31t)this.instruction;
        int destRegister = fillArrayInstr.getRegisterA();
        int offset = fillArrayInstr.getTargetAddressOffset();
        int targetAddress = this.codeAddress + offset;
        Instruction referenceTable = body.instructionAtAddress((int)targetAddress).instruction;
        if (!(referenceTable instanceof ArrayDataPseudoInstruction)) {
            throw new RuntimeException("Address " + targetAddress + "refers to an invalid PseudoInstruction.");
        }
        ArrayDataPseudoInstruction arrayTable = (ArrayDataPseudoInstruction)referenceTable;
        int numElements = arrayTable.getElementCount();
        Local arrayReference = body.getRegisterLocal(destRegister);
        Iterator<ArrayDataPseudoInstruction.ArrayElement> elements = arrayTable.getElements();
        Stmt firstAssign = null;
        for (int i = 0; i < numElements; ++i) {
            ArrayRef arrayRef = Jimple.v().newArrayRef(arrayReference, IntConstant.v(i));
            NumericConstant element = this.getArrayElement(elements.next(), body, destRegister);
            if (element == null) break;
            AssignStmt assign = Jimple.v().newAssignStmt(arrayRef, element);
            this.tagWithLineNumber(assign);
            body.add(assign);
            if (i != 0) continue;
            firstAssign = assign;
        }
        if (firstAssign == null) {
            firstAssign = Jimple.v().newNopStmt();
            body.add(firstAssign);
        }
        this.setUnit(firstAssign);
    }

    private NumericConstant getArrayElement(ArrayDataPseudoInstruction.ArrayElement element, DexBody body, int arrayRegister) {
        NumericConstant value;
        List<DexlibAbstractInstruction> instructions = body.instructionsBefore(this);
        HashSet<Integer> usedRegisters = new HashSet<Integer>();
        usedRegisters.add(arrayRegister);
        Type elementType = null;
        block0: for (DexlibAbstractInstruction i : instructions) {
            int reg;
            if (usedRegisters.isEmpty()) break;
            Iterator i$ = usedRegisters.iterator();
            while (i$.hasNext()) {
                reg = (Integer)i$.next();
                if (!(i instanceof NewArrayInstruction)) continue;
                NewArrayInstruction newArrayInstruction = (NewArrayInstruction)i;
                Instruction22c instruction22c = (Instruction22c)newArrayInstruction.instruction;
                if (instruction22c.getRegisterA() != reg) continue;
                ArrayType arrayType = (ArrayType)DexType.toSoot((TypeIdItem)instruction22c.getReferencedItem());
                elementType = arrayType.getElementType();
                break block0;
            }
            i$ = usedRegisters.iterator();
            while (i$.hasNext()) {
                reg = (Integer)i$.next();
                int newRegister = i.movesToRegister(reg);
                if (newRegister == -1) continue;
                usedRegisters.add(newRegister);
                usedRegisters.remove(reg);
                continue block0;
            }
        }
        if (elementType == null) {
            G.v().out.println("Warning: Unable to find array type to type array elements! Array was not defined! (obfuscated bytecode?)");
            return null;
        }
        ByteArrayInput byteArray = new ByteArrayInput(element.buffer);
        byteArray.setCursor(element.bufferIndex);
        if (elementType instanceof BooleanType) {
            IntConstant ic = value = IntConstant.v(byteArray.readByte());
            if (ic.value != 0 && ic.value != 1) {
                throw new RuntimeException("ERROR: Invalid value for boolean: " + value);
            }
        } else if (elementType instanceof ByteType) {
            value = IntConstant.v(byteArray.readByte());
        } else if (elementType instanceof CharType || elementType instanceof ShortType) {
            value = IntConstant.v(byteArray.readShort());
        } else if (elementType instanceof DoubleType) {
            value = DoubleConstant.v(byteArray.readLong());
        } else if (elementType instanceof FloatType) {
            value = FloatConstant.v(byteArray.readInt());
        } else if (elementType instanceof IntType) {
            value = IntConstant.v(byteArray.readInt());
        } else if (elementType instanceof LongType) {
            value = LongConstant.v(byteArray.readLong());
        } else {
            throw new RuntimeException("Invalid Array Type occured in FillArrayDataInstruction: " + elementType);
        }
        Debug.printDbg("array element: " + value);
        return value;
    }

    @Override
    public void computeDataOffsets(DexBody body) {
        Debug.printDbg("compute data offset");
        if (!(this.instruction instanceof Instruction31t)) {
            throw new IllegalArgumentException("Expected Instruction31t but got: " + this.instruction.getClass());
        }
        Instruction31t fillArrayInstr = (Instruction31t)this.instruction;
        int offset = fillArrayInstr.getTargetAddressOffset();
        int targetAddress = this.codeAddress + offset;
        Instruction referenceTable = body.instructionAtAddress((int)targetAddress).instruction;
        if (!(referenceTable instanceof ArrayDataPseudoInstruction)) {
            throw new RuntimeException("Address 0x" + Integer.toHexString(targetAddress) + " refers to an invalid PseudoInstruction (" + referenceTable.getClass() + ").");
        }
        ArrayDataPseudoInstruction arrayTable = (ArrayDataPseudoInstruction)referenceTable;
        int numElements = arrayTable.getElementCount();
        int widthElement = arrayTable.getElementWidth();
        int size = widthElement * numElements / 2;
        this.setDataFirstByte(targetAddress + 3);
        this.setDataLastByte(targetAddress + 3 + size);
        this.setDataSize(size);
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        arrayTable.write(out, targetAddress);
        byte[] outa = out.getArray();
        byte[] data = new byte[outa.length - 6];
        for (int i = 6; i < outa.length; ++i) {
            data[i - 6] = outa[i];
        }
        this.setData(data);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }
}

