/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction35c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.TypeIdItem;
import soot.ArrayType;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.Util;
import soot.dexpler.instructions.FilledArrayInstruction;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;

public class FilledNewArrayInstruction
extends FilledArrayInstruction {
    AssignStmt assign = null;

    public FilledNewArrayInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction35c)) {
            throw new IllegalArgumentException("Expected Instruction35c but got: " + this.instruction.getClass());
        }
        Instruction35c filledNewArrayInstr = (Instruction35c)this.instruction;
        int[] regs = new int[]{filledNewArrayInstr.getRegisterD(), filledNewArrayInstr.getRegisterE(), filledNewArrayInstr.getRegisterF(), filledNewArrayInstr.getRegisterG(), filledNewArrayInstr.getRegisterA()};
        int usedRegister = filledNewArrayInstr.getRegCount();
        Type t = DexType.toSoot((TypeIdItem)filledNewArrayInstr.getReferencedItem());
        Type arrayType = ((ArrayType)t).getElementType();
        NewArrayExpr arrayExpr = Jimple.v().newNewArrayExpr(arrayType, IntConstant.v(usedRegister));
        this.arrayLocal = body.getStoreResultLocal();
        this.assign = Jimple.v().newAssignStmt(this.arrayLocal, arrayExpr);
        body.add(this.assign);
        for (int i = 0; i < usedRegister; ++i) {
            ArrayRef arrayRef = Jimple.v().newArrayRef(this.arrayLocal, IntConstant.v(i));
            AssignStmt assign = Jimple.v().newAssignStmt(arrayRef, body.getRegisterLocal(regs[i]));
            this.tagWithLineNumber(assign);
            body.add(assign);
        }
        this.setUnit(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        Instruction35c i = (Instruction35c)this.instruction;
        Type arrayType = DexType.toSoot((TypeIdItem)i.getReferencedItem());
        return this.isRegisterUsed(register) && Util.isFloatLike(arrayType);
    }

    private boolean isRegisterUsed(int register) {
        Instruction35c i = (Instruction35c)this.instruction;
        return register == i.getRegisterD() || register == i.getRegisterE() || register == i.getRegisterF() || register == i.getRegisterG() || register == i.getRegisterA();
    }
}

