/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction3rc;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.TypeIdItem;
import soot.ArrayType;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.Util;
import soot.dexpler.instructions.FilledArrayInstruction;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;

public class FilledNewArrayRangeInstruction
extends FilledArrayInstruction {
    public FilledNewArrayRangeInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction3rc)) {
            throw new IllegalArgumentException("Expected Instruction3rc but got: " + this.instruction.getClass());
        }
        Instruction3rc filledNewArrayInstr = (Instruction3rc)this.instruction;
        int usedRegister = filledNewArrayInstr.getRegCount();
        Type t = DexType.toSoot((TypeIdItem)filledNewArrayInstr.getReferencedItem());
        Type arrayType = ((ArrayType)t).getElementType();
        NewArrayExpr arrayExpr = Jimple.v().newNewArrayExpr(arrayType, IntConstant.v(usedRegister));
        this.arrayLocal = body.getStoreResultLocal();
        AssignStmt assignStmt = Jimple.v().newAssignStmt(this.arrayLocal, arrayExpr);
        body.add(assignStmt);
        for (int i = 0; i < usedRegister; ++i) {
            ArrayRef arrayRef = Jimple.v().newArrayRef(this.arrayLocal, IntConstant.v(i));
            AssignStmt assign = Jimple.v().newAssignStmt(arrayRef, body.getRegisterLocal(i + filledNewArrayInstr.getStartRegister()));
            this.tagWithLineNumber(assign);
            body.add(assign);
        }
        this.setUnit(assignStmt);
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        Instruction3rc i = (Instruction3rc)this.instruction;
        Type arrayType = DexType.toSoot((TypeIdItem)i.getReferencedItem());
        int startRegister = i.getStartRegister();
        int endRegister = startRegister + i.getRegCount();
        return register >= startRegister && register <= endRegister && Util.isFloatLike(arrayType);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }
}

