/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.TypeIdItem;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.Jimple;

public class InstanceOfInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public InstanceOfInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        Instruction22c i = (Instruction22c)this.instruction;
        int dest = i.getRegisterA();
        int source = i.getRegisterB();
        Type t = DexType.toSoot((TypeIdItem)i.getReferencedItem());
        InstanceOfExpr e = Jimple.v().newInstanceOfExpr(body.getRegisterLocal(source), t);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), e);
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public Set<DexType> introducedTypes() {
        InstructionWithReference i = (InstructionWithReference)this.instruction;
        HashSet<DexType> types = new HashSet<DexType>();
        types.add(new DexType((TypeIdItem)i.getReferencedItem()));
        return types;
    }
}

