/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jf.dexlib.Code.Format.Instruction35c;
import org.jf.dexlib.Code.Format.Instruction3rc;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.Util;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.MoveResultInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;

public abstract class MethodInvocationInstruction
extends DexlibAbstractInstruction
implements DanglingInstruction {
    protected InvokeExpr invocation;
    protected AssignStmt assign = null;

    public MethodInvocationInstruction(Instruction instruction, int codeAddress) {
        super(instruction, codeAddress);
    }

    @Override
    public void finalize(DexBody body, DexlibAbstractInstruction successor) {
        if (successor instanceof MoveResultInstruction) {
            this.assign = Jimple.v().newAssignStmt(body.getStoreResultLocal(), this.invocation);
            this.setUnit(this.assign);
            this.tagWithLineNumber(this.assign);
            body.add(this.assign);
            this.unit = this.assign;
        } else {
            InvokeStmt invoke = Jimple.v().newInvokeStmt(this.invocation);
            this.setUnit(invoke);
            this.tagWithLineNumber(invoke);
            body.add(invoke);
            this.unit = invoke;
        }
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    public Set<DexType> introducedTypes() {
        HashSet<DexType> types = new HashSet<DexType>();
        MethodIdItem method = (MethodIdItem)((InstructionWithReference)this.instruction).getReferencedItem();
        types.add(new DexType(method.getContainingClass()));
        ProtoIdItem prototype = method.getPrototype();
        types.add(new DexType(prototype.getReturnType()));
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(prototype.getParameters());
        if (paramTypes != null) {
            for (TypeIdItem type : paramTypes) {
                types.add(new DexType(type));
            }
        }
        return types;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        return this.isUsedAsFloatingPoint(body, register, false);
    }

    protected boolean isUsedAsFloatingPoint(DexBody body, int register, boolean isStatic) {
        MethodIdItem item = (MethodIdItem)((InstructionWithReference)this.instruction).getReferencedItem();
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(item.getPrototype().getParameters());
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register && Util.isFloatLike(DexType.toSoot(paramTypes.get(j)))) {
                    return true;
                }
                if (DexType.isWide(paramTypes.get(j))) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected boolean isUsedAsObject(DexBody body, int register, boolean isStatic) {
        MethodIdItem item = (MethodIdItem)((InstructionWithReference)this.instruction).getReferencedItem();
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(item.getPrototype().getParameters());
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        if (!isStatic && regs.get(0) == register) {
            return true;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register && DexType.toSoot(paramTypes.get(j)) instanceof RefType) {
                    return true;
                }
                if (DexType.isWide(paramTypes.get(j))) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected SootMethodRef getSootMethodRef() {
        return this.getSootMethodRef(false);
    }

    protected SootMethodRef getStaticSootMethodRef() {
        return this.getSootMethodRef(true);
    }

    private SootMethodRef getSootMethodRef(boolean isStatic) {
        String tItem;
        MethodIdItem mItem = (MethodIdItem)((InstructionWithReference)this.instruction).getReferencedItem();
        String className = tItem = mItem.getContainingClass().getTypeDescriptor();
        Debug.printDbg("tItem: " + tItem + " class name: " + className);
        className = className.startsWith("[") ? "java.lang.Object" : Util.dottedClassName(tItem);
        SootClass sc = SootResolver.v().makeClassRef(className);
        String methodName = mItem.getMethodName().getStringValue();
        ProtoIdItem prototype = mItem.getPrototype();
        Type returnType = DexType.toSoot(prototype.getReturnType());
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(prototype.getParameters());
        if (paramTypes != null) {
            for (TypeIdItem type : paramTypes) {
                parameterTypes.add(DexType.toSoot(type));
            }
        }
        Debug.printDbg("sc: " + sc);
        Debug.printDbg("methodName: " + methodName);
        Debug.printDbg("parameterTypes: ");
        for (Type t : parameterTypes) {
            Debug.printDbg(" t: " + t);
        }
        Debug.printDbg("returnType: " + returnType);
        Debug.printDbg("isStatic: " + isStatic);
        return Scene.v().makeMethodRef(sc, methodName, parameterTypes, returnType, isStatic);
    }

    protected List<Local> buildParameters(DexBody body, boolean isStatic) {
        MethodIdItem item = (MethodIdItem)((InstructionWithReference)this.instruction).getReferencedItem();
        List<TypeIdItem> paramTypes = TypeListItem.getTypes(item.getPrototype().getParameters());
        ArrayList<Local> parameters = new ArrayList<Local>();
        List<Integer> regs = this.getUsedRegistersNums();
        Debug.printDbg(" [methodIdItem]: " + item);
        Debug.printDbg(" params types:");
        if (paramTypes != null) {
            for (TypeIdItem t : paramTypes) {
                Debug.printDbg(" t: " + t);
            }
        }
        Debug.printDbg(" used registers (" + regs.size() + "): ");
        Iterator<Comparable<TypeIdItem>> i$ = regs.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            Debug.printDbg(" r: " + i);
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            parameters.add(body.getRegisterLocal(regs.get(i)));
            if (!isStatic && i == 0) {
                --j;
            } else if (paramTypes != null && DexType.isWide(paramTypes.get(j))) {
                ++i;
            }
            ++i;
            ++j;
        }
        return parameters;
    }

    protected List<Integer> getUsedRegistersNums() {
        if (this.instruction instanceof Instruction35c) {
            return MethodInvocationInstruction.getUsedRegistersNums((Instruction35c)this.instruction);
        }
        if (this.instruction instanceof Instruction3rc) {
            return MethodInvocationInstruction.getUsedRegistersNums((Instruction3rc)this.instruction);
        }
        throw new RuntimeException("Instruction is neither a InvokeInstruction nor a InvokeRangeInstruction");
    }

    private static List<Integer> getUsedRegistersNums(Instruction35c instruction) {
        int[] regs = new int[]{instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getRegisterA()};
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < instruction.getRegCount(); ++i) {
            l.add(regs[i]);
        }
        return l;
    }

    private static List<Integer> getUsedRegistersNums(Instruction3rc instruction) {
        int start;
        ArrayList<Integer> regs = new ArrayList<Integer>();
        for (int i = start = instruction.getStartRegister(); i < start + instruction.getRegCount(); ++i) {
            regs.add(i);
        }
        return regs;
    }
}

